/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ChartItem {
    public static final int VERTICAL_SCALE_WIDTH = 86;
    public static final int HORIZONTAL_SCALE_HEIGHT = 26;
    private Composite composite;
    private Canvas canvas;
    private Canvas verticalScaleCanvas;
    private Canvas horizontalScaleCanvas;
    private Image image;
    private Image verticalScaleImage;
    private Image horizontalScaleImage;
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public ChartItem(Composite parent, int style) {
        this.composite = new Composite(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 3;
        gridLayout.horizontalSpacing = 3;
        this.composite.setLayout((Layout)gridLayout);
        this.canvas = new Canvas(this.composite, 0x20000000);
        this.canvas.setBackground(Display.getCurrent().getSystemColor(25));
        this.canvas.setData((Object)this);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.verticalScaleCanvas = new Canvas(this.composite, 0x20000000);
        this.verticalScaleCanvas.setBackground(Display.getCurrent().getSystemColor(25));
        this.verticalScaleCanvas.setLayoutData((Object)new GridData(1, 4, false, false));
        ((GridData)this.verticalScaleCanvas.getLayoutData()).widthHint = 86;
        ((GridData)this.verticalScaleCanvas.getLayoutData()).exclude = true;
        this.verticalScaleCanvas.setVisible(false);
        this.verticalScaleCanvas.setData((Object)this);
        this.verticalScaleCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ChartItem.this.verticalScaleImage != null) {
                    ChartItem.this.verticalScaleImage.dispose();
                    ChartItem.this.verticalScaleImage = null;
                }
                ChartItem.this.verticalScaleCanvas.redraw();
            }
        });
        this.verticalScaleCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartItem.this.verticalScaleImage != null) {
                    ChartItem.this.verticalScaleImage.dispose();
                    ChartItem.this.verticalScaleImage = null;
                }
            }
        });
        this.horizontalScaleCanvas = new Canvas(this.composite, 0x20000000);
        this.horizontalScaleCanvas.setBackground(Display.getCurrent().getSystemColor(25));
        this.horizontalScaleCanvas.setLayoutData((Object)new GridData(4, 1, false, false));
        ((GridData)this.horizontalScaleCanvas.getLayoutData()).heightHint = 26;
        ((GridData)this.horizontalScaleCanvas.getLayoutData()).exclude = true;
        this.horizontalScaleCanvas.setVisible(false);
        this.horizontalScaleCanvas.setData((Object)this);
        this.horizontalScaleCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ChartItem.this.horizontalScaleImage != null) {
                    ChartItem.this.horizontalScaleImage.dispose();
                    ChartItem.this.horizontalScaleImage = null;
                }
            }
        });
        this.horizontalScaleCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartItem.this.horizontalScaleImage != null) {
                    ChartItem.this.horizontalScaleImage.dispose();
                    ChartItem.this.horizontalScaleImage = null;
                }
            }
        });
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartItem.this.image != null) {
                    ChartItem.this.image.dispose();
                    ChartItem.this.image = null;
                }
            }
        });
    }

    public void dispose() {
        this.canvas.dispose();
    }

    public void setHorizontalScaleVisible(boolean visible) {
        if (visible && !this.horizontalScaleCanvas.getVisible()) {
            ((GridData)this.horizontalScaleCanvas.getLayoutData()).exclude = false;
            this.horizontalScaleCanvas.setVisible(true);
            this.composite.layout();
        }
        if (!visible && this.horizontalScaleCanvas.getVisible()) {
            ((GridData)this.horizontalScaleCanvas.getLayoutData()).exclude = true;
            this.horizontalScaleCanvas.setVisible(false);
            this.composite.layout();
        }
    }

    public void setVerticalScaleVisible(boolean visible) {
        if (visible && !this.verticalScaleCanvas.getVisible()) {
            ((GridData)this.verticalScaleCanvas.getLayoutData()).exclude = false;
            this.verticalScaleCanvas.setVisible(true);
            this.composite.layout();
        }
        if (!visible && this.verticalScaleCanvas.getVisible()) {
            ((GridData)this.verticalScaleCanvas.getLayoutData()).exclude = true;
            this.verticalScaleCanvas.setVisible(false);
            this.composite.layout();
        }
    }

    public Display getDisplay() {
        return this.canvas.getDisplay();
    }

    public boolean isDisposed() {
        return this.canvas.isDisposed();
    }

    public Control getControl() {
        return this.composite;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Canvas getVerticalScaleCanvas() {
        return this.verticalScaleCanvas;
    }

    public Image getVerticalScaleImage() {
        return this.verticalScaleImage;
    }

    public void setVerticalScaleImage(Image verticalScaleImage) {
        this.verticalScaleImage = verticalScaleImage;
    }

    public Canvas getHorizontalScaleCanvas() {
        return this.horizontalScaleCanvas;
    }

    public Image getHorizontalScaleImage() {
        return this.horizontalScaleImage;
    }

    public void setHorizontalScaleImage(Image horizontalScaleImage) {
        this.horizontalScaleImage = horizontalScaleImage;
    }

    public Object getData() {
        return this.dataMap.get(null);
    }

    public void setData(Object data) {
        this.dataMap.put(null, data);
    }

    public Object getData(String key) {
        return this.dataMap.get(key);
    }

    public void setData(String key, Object data) {
        this.dataMap.put(key, data);
    }

    public void redraw() {
        this.canvas.redraw();
        if (this.horizontalScaleCanvas != null) {
            this.horizontalScaleCanvas.redraw();
        }
        if (this.verticalScaleCanvas != null) {
            this.verticalScaleCanvas.redraw();
        }
    }

    public void layout() {
        this.composite.layout();
    }
}

