/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.charts.AdaptableWrapper;
import org.eclipsetrader.ui.charts.DataBounds;
import org.eclipsetrader.ui.charts.DateValuesAxis;
import org.eclipsetrader.ui.charts.DoubleValuesAxis;
import org.eclipsetrader.ui.charts.Graphics;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.ISummaryBarDecorator;
import org.eclipsetrader.ui.charts.Messages;
import org.eclipsetrader.ui.charts.SummaryBar;
import org.eclipsetrader.ui.charts.Util;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;
import pk.com.softech.tradingterminal.core.CorePlugin;

public class ChartCanvas {
    private Composite composite;
    private SummaryBar summary;
    private Canvas canvas;
    private Canvas verticalScaleCanvas;
    private Image image;
    private Image verticalScaleImage;
    private Label label;
    private IChartObject[] chartObject;
    private TimeSpan resolutionTimeSpan;
    private DoubleValuesAxis verticalAxis;
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    Date[] visibleDates;
    Date firstDate;
    Date lastDate;
    Point location;
    DateValuesAxis datesAxis;
    private Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            ChartCanvas.this.canvas.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ChartCanvas.this.canvas.isDisposed()) {
                        ChartCanvas.this.redraw();
                    }
                }
            });
        }
    };

    public ChartCanvas(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GC gc = new GC((Drawable)this.composite);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.summary = new SummaryBar(this.composite, 0);
        this.summary.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.canvas = new Canvas(this.composite, 0x20040000);
        this.canvas.setData((Object)this);
        this.canvas.setBackground(Display.getCurrent().getSystemColor(25));
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ChartCanvas.this.image != null) {
                    ChartCanvas.this.image.dispose();
                    ChartCanvas.this.image = null;
                }
                ChartCanvas.this.redraw();
            }
        });
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChartCanvas.this.removeObservers();
                if (ChartCanvas.this.image != null) {
                    ChartCanvas.this.image.dispose();
                    ChartCanvas.this.image = null;
                }
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ChartCanvas.this.chartObject != null) {
                    ChartCanvas.this.onPaint(e);
                }
            }
        });
        this.verticalScaleCanvas = new Canvas(this.composite, 0x20040000);
        this.verticalScaleCanvas.setBackground(Display.getCurrent().getSystemColor(25));
        this.verticalScaleCanvas.setLayoutData((Object)new GridData(1, 4, false, false));
        ((GridData)this.verticalScaleCanvas.getLayoutData()).widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)12);
        this.verticalScaleCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ChartCanvas.this.verticalScaleImage != null) {
                    ChartCanvas.this.verticalScaleImage.dispose();
                    ChartCanvas.this.verticalScaleImage = null;
                }
                ChartCanvas.this.redraw();
            }
        });
        this.verticalScaleCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartCanvas.this.verticalScaleImage != null) {
                    ChartCanvas.this.verticalScaleImage.dispose();
                    ChartCanvas.this.verticalScaleImage = null;
                }
            }
        });
        this.verticalScaleCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ChartCanvas.this.chartObject != null) {
                    ChartCanvas.this.onPaintVerticalScale(e);
                }
            }
        });
        this.label = new Label((Composite)this.verticalScaleCanvas, 0);
        this.label.setBackground(this.verticalScaleCanvas.getDisplay().getSystemColor(29));
        this.label.setBounds(-200, 0, 0, 0);
    }

    public void setDatesAxis(DateValuesAxis datesAxis) {
        this.datesAxis = datesAxis;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public void setDateRange(Date firstDate, Date lastDate) {
        this.firstDate = firstDate;
        this.lastDate = lastDate;
    }

    public void setVisibleDates(Date[] visibleDates) {
        this.visibleDates = visibleDates;
    }

    public void dispose() {
        this.composite.dispose();
    }

    public boolean isDisposed() {
        return this.composite.isDisposed();
    }

    public Control getControl() {
        return this.composite;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Canvas getVerticalScaleCanvas() {
        return this.verticalScaleCanvas;
    }

    public DoubleValuesAxis getVerticalAxis() {
        return this.verticalAxis;
    }

    private void buildVerticalAxis() {
        if (this.verticalAxis == null) {
            this.verticalAxis = new DoubleValuesAxis();
        }
        if (Boolean.TRUE.equals(this.verticalScaleCanvas.getData("needs_redraw"))) {
            this.verticalAxis.clear();
            this.accept(new IChartObjectVisitor(){

                @Override
                public boolean visit(IChartObject object) {
                    IDataSeries series;
                    if (object.getDataSeries() != null && (series = object.getDataSeries().getSeries((IAdaptable)new AdaptableWrapper(ChartCanvas.this.firstDate), (IAdaptable)new AdaptableWrapper(ChartCanvas.this.lastDate))) != null) {
                        ChartCanvas.this.verticalAxis.addValues(new Object[]{series.getLowest(), series.getHighest()});
                    }
                    return true;
                }
            });
        }
    }

    private void onPaint(PaintEvent event) {
        block9: {
            Rectangle clientArea = this.canvas.getClientArea();
            boolean needsRedraw = Boolean.TRUE.equals(this.canvas.getData("needs_redraw"));
            if (!(this.image == null || this.image.isDisposed() || this.image.getBounds().width == clientArea.width && this.image.getBounds().height == clientArea.height)) {
                this.image.dispose();
            }
            if (this.image == null || this.image.isDisposed()) {
                this.image = new Image((Device)this.canvas.getDisplay(), clientArea.width, clientArea.height);
                needsRedraw = true;
            }
            if (needsRedraw) {
                this.buildVerticalAxis();
                this.verticalAxis.computeSize(clientArea.height);
                Graphics graphics = new Graphics((Drawable)this.image, this.location, this.datesAxis, this.verticalAxis);
                try {
                    try {
                        graphics.fillRectangle(clientArea);
                        if (this.visibleDates != null) {
                            this.paintBackground(graphics, clientArea);
                        }
                        this.paintObjects(graphics, clientArea);
                    }
                    catch (Throwable e) {
                        Status status = new Status(4, "org.eclipsetrader.ui.charts", Messages.ChartCanvas_RenderingChartError, e);
                        ChartsUIActivator.log((IStatus)status);
                        this.canvas.setData("needs_redraw", (Object)Boolean.FALSE);
                        graphics.dispose();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.canvas.setData("needs_redraw", (Object)Boolean.FALSE);
                    graphics.dispose();
                    throw throwable;
                }
                this.canvas.setData("needs_redraw", (Object)Boolean.FALSE);
                graphics.dispose();
            }
        }
        Util.paintImage(event, this.image);
    }

    void paintBackground(Graphics graphics, Rectangle clientArea) {
        graphics.pushState();
        try {
            graphics.setLineDash(new int[]{3, 3});
            graphics.setForegroundColor(Util.blend(graphics.getForegroundColor(), graphics.getBackgroundColor(), 15));
            Calendar oldDate = null;
            Calendar currentDate = Calendar.getInstance();
            int tickCount = 0;
            int monthRatio = 1;
            int ratio1 = 0;
            int ratio2 = 0;
            if (this.visibleDates != null && this.visibleDates.length > 0) {
                ratio1 = this.visibleDates.length / 150;
                ratio2 = Math.max(4 - clientArea.width / this.visibleDates.length, 0);
                monthRatio = Math.max(ratio1 + ratio2, 1);
                if (monthRatio > 6) {
                    monthRatio = 12;
                } else if (monthRatio >= 4) {
                    monthRatio = 6;
                }
            }
            int i = 0;
            while (i < this.visibleDates.length) {
                ++tickCount;
                Date date = this.visibleDates[i];
                boolean tick = false;
                currentDate.setTime(date);
                if (oldDate != null) {
                    if (this.resolutionTimeSpan == null || this.resolutionTimeSpan.getUnits() == TimeSpan.Units.Days) {
                        if (this.datesAxis.fillAvailableSpace) {
                            if (this.visibleDates.length < 730) {
                                int monthNo = oldDate.get(2) + 1;
                                if (currentDate.get(1) != oldDate.get(1)) {
                                    tick = true;
                                } else if (currentDate.get(2) != oldDate.get(2) && monthRatio != 0 && monthNo % monthRatio == 0) {
                                    tick = true;
                                }
                            } else if (currentDate.get(1) != oldDate.get(1)) {
                                tick = true;
                            }
                        } else if (currentDate.get(1) != oldDate.get(1)) {
                            tick = true;
                        } else if (currentDate.get(2) != oldDate.get(2)) {
                            tick = true;
                        }
                    } else if (currentDate.get(2) != oldDate.get(2)) {
                        tick = true;
                    } else if (currentDate.get(5) != oldDate.get(5)) {
                        tick = true;
                    } else if (currentDate.get(11) != oldDate.get(11) && tickCount > 10) {
                        tickCount = 0;
                        tick = true;
                    }
                    oldDate.setTime(date);
                } else {
                    oldDate = Calendar.getInstance();
                    oldDate.setTime(date);
                }
                if (tick) {
                    int x = graphics.mapToHorizontalAxis(date);
                    graphics.drawLine(x, 0, x, clientArea.height);
                }
                ++i;
            }
            Object[] numberArray = this.verticalAxis.getValues();
            int i2 = 0;
            while (i2 < numberArray.length) {
                int y = graphics.mapToVerticalAxis(numberArray[i2]);
                graphics.drawLine(0, y, clientArea.width, y);
                ++i2;
            }
        }
        finally {
            graphics.popState();
        }
    }

    void paintObjects(Graphics graphics, Rectangle clientArea) {
        Double lowestValue = (Double)this.verticalAxis.getFirstValue();
        Double highestValue = (Double)this.verticalAxis.getLastValue();
        DataBounds dataBounds = new DataBounds(this.visibleDates, lowestValue, highestValue, clientArea, (int)this.datesAxis.gridSize);
        int i = 0;
        while (i < this.chartObject.length) {
            graphics.pushState();
            try {
                this.chartObject[i].setDataBounds(dataBounds);
                this.chartObject[i].paint(graphics);
            }
            finally {
                graphics.popState();
            }
            ++i;
        }
    }

    private void onPaintVerticalScale(PaintEvent event) {
        block16: {
            Rectangle clientArea = this.verticalScaleCanvas.getClientArea();
            boolean needsRedraw = Boolean.TRUE.equals(this.verticalScaleCanvas.getData("needs_redraw"));
            if (!(this.verticalScaleImage == null || this.verticalScaleImage.isDisposed() || this.verticalScaleImage.getBounds().width == clientArea.width && this.verticalScaleImage.getBounds().height == clientArea.height)) {
                this.verticalScaleImage.dispose();
            }
            if (this.verticalScaleImage == null || this.verticalScaleImage.isDisposed()) {
                this.verticalScaleImage = new Image((Device)this.verticalScaleCanvas.getDisplay(), clientArea.width, clientArea.height);
                needsRedraw = true;
            }
            if (needsRedraw) {
                this.buildVerticalAxis();
                this.verticalAxis.computeSize(clientArea.height);
                Graphics graphics = new Graphics((Drawable)this.verticalScaleImage, this.location, this.datesAxis, this.verticalAxis);
                try {
                    try {
                        graphics.fillRectangle(clientArea);
                        Object[] scaleArray = this.verticalAxis.getValues();
                        int loop = 0;
                        while (loop < scaleArray.length) {
                            String s;
                            int y = this.verticalAxis.mapToAxis(scaleArray[loop]);
                            if ((Double)scaleArray[loop] > 1000000.0) {
                                Double value = (Double)scaleArray[loop];
                                s = String.valueOf(this.pf.format(value / 1000000.0)) + "M";
                            } else {
                                s = this.pf.format(scaleArray[loop]);
                            }
                            int h = graphics.stringExtent((String)s).y / 2;
                            graphics.drawLine(0, y, 4, y);
                            graphics.drawString(s, 7, y - h);
                            ++loop;
                        }
                        int i = 0;
                        while (i < this.chartObject.length) {
                            graphics.pushState();
                            try {
                                this.chartObject[i].paintScale(graphics);
                            }
                            finally {
                                graphics.popState();
                            }
                            ++i;
                        }
                    }
                    catch (Error e) {
                        Status status = new Status(4, "org.eclipsetrader.ui.charts", Messages.ChartCanvas_VerticalScaleRenderingError, (Throwable)e);
                        ChartsUIActivator.log((IStatus)status);
                        this.verticalScaleCanvas.setData("needs_redraw", (Object)Boolean.FALSE);
                        graphics.dispose();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    this.verticalScaleCanvas.setData("needs_redraw", (Object)Boolean.FALSE);
                    graphics.dispose();
                    throw throwable;
                }
                this.verticalScaleCanvas.setData("needs_redraw", (Object)Boolean.FALSE);
                graphics.dispose();
            }
        }
        Util.paintImage(event, this.verticalScaleImage);
    }

    public void setVerticalScaleVisible(boolean visible) {
        if (visible && !this.verticalScaleCanvas.getVisible()) {
            ((GridData)this.verticalScaleCanvas.getLayoutData()).exclude = false;
            ((GridData)this.canvas.getLayoutData()).horizontalSpan = 1;
            this.verticalScaleCanvas.setVisible(true);
        }
        if (!visible && this.verticalScaleCanvas.getVisible()) {
            ((GridData)this.verticalScaleCanvas.getLayoutData()).exclude = true;
            ((GridData)this.canvas.getLayoutData()).horizontalSpan = 2;
            this.verticalScaleCanvas.setVisible(false);
        }
    }

    public IChartObject[] getChartObject() {
        return this.chartObject;
    }

    public void setChartObject(IChartObject[] chartObject) {
        this.removeObservers();
        this.chartObject = chartObject;
        this.addObservers();
        this.updateSummary();
    }

    public void redraw() {
        this.canvas.setData("needs_redraw", (Object)Boolean.TRUE);
        this.verticalScaleCanvas.setData("needs_redraw", (Object)Boolean.TRUE);
        this.canvas.redraw();
        this.verticalScaleCanvas.redraw();
    }

    public void hideToolTip() {
        this.label.setLocation(-200, 0);
    }

    public void showToolTip(int x, int y) {
        if (this.verticalAxis == null) {
            return;
        }
        Number value = (Number)this.verticalAxis.mapToValue(y);
        if (value != null) {
            this.label.setText(this.pf.format(value));
            this.label.pack();
            this.label.setLocation(0, y - this.label.getSize().y / 2);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public Image getVerticalScaleImage() {
        return this.verticalScaleImage;
    }

    protected void updateSummary() {
        this.summary.removeAll();
        this.accept(new IChartObjectVisitor(){

            @Override
            public boolean visit(IChartObject object) {
                ISummaryBarDecorator factory = null;
                if (object instanceof IAdaptable && (factory = (ISummaryBarDecorator)((IAdaptable)object).getAdapter(ISummaryBarDecorator.class)) != null) {
                    factory.createDecorator(ChartCanvas.this.summary.getCompositeControl());
                }
                return true;
            }
        });
        this.summary.layout();
        this.summary.getParent().layout();
    }

    public TimeSpan getResolutionTimeSpan() {
        return this.resolutionTimeSpan;
    }

    public void setResolutionTimeSpan(TimeSpan resolutionTimeSpan) {
        this.resolutionTimeSpan = resolutionTimeSpan;
    }

    public void accept(IChartObjectVisitor visitor) {
        if (this.chartObject == null) {
            return;
        }
        int i = 0;
        while (i < this.chartObject.length) {
            this.chartObject[i].accept(visitor);
            ++i;
        }
    }

    void addObservers() {
        this.accept(new IChartObjectVisitor(){

            @Override
            public boolean visit(IChartObject object) {
                if (!(object instanceof IAdaptable)) {
                    return true;
                }
                IAdaptable adaptable = (IAdaptable)object;
                Observable observable = (Observable)adaptable.getAdapter(Observable.class);
                if (observable != null) {
                    observable.addObserver(ChartCanvas.this.observer);
                }
                return true;
            }
        });
    }

    void removeObservers() {
        this.accept(new IChartObjectVisitor(){

            @Override
            public boolean visit(IChartObject object) {
                if (!(object instanceof IAdaptable)) {
                    return true;
                }
                IAdaptable adaptable = (IAdaptable)object;
                Observable observable = (Observable)adaptable.getAdapter(Observable.class);
                if (observable != null) {
                    observable.deleteObserver(ChartCanvas.this.observer);
                }
                return true;
            }
        });
    }
}

