/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.charts.ChartCanvas;
import org.eclipsetrader.ui.charts.ChartObjectFocusEvent;
import org.eclipsetrader.ui.charts.ChartToolEditor;
import org.eclipsetrader.ui.charts.CrosshairDecorator;
import org.eclipsetrader.ui.charts.DateScaleCanvas;
import org.eclipsetrader.ui.charts.DateValuesAxis;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectVisitor;
import org.eclipsetrader.ui.charts.IEditableChartObject;
import org.eclipsetrader.ui.charts.Messages;
import org.eclipsetrader.ui.charts.SummaryBarDecorator;
import org.eclipsetrader.ui.internal.charts.ChartObjectHitVisitor;
import org.eclipsetrader.ui.internal.charts.ChartsUIActivator;

public class BaseChartViewer
implements ISelectionProvider {
    static final String K_NEEDS_REDRAW = "needs_redraw";
    private Composite composite;
    public SashForm sashForm;
    private DateScaleCanvas dateScaleCanvas;
    private Label verticalScaleLabel;
    private IChartObject[][] input;
    private ChartCanvas[] chartCanvas = new ChartCanvas[0];
    DateValuesAxis datesAxis;
    private ChartCanvas selectedChartCanvas;
    private IChartObject selectedObject;
    private ListenerList selectionListeners = new ListenerList(1);
    private boolean showTooltips;
    private boolean showScaleTooltips;
    private SummaryBarDecorator summaryDecorator;
    private CrosshairDecorator decorator;
    private int decoratorMode;
    private boolean fillAvailableSpace;
    private ChartToolEditor activeEditor = new ChartToolEditor();

    public BaseChartViewer(Composite parent, int style) {
        this.composite = new Composite(parent, style | 0x100);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 3;
        gridLayout.horizontalSpacing = 3;
        this.composite.setLayout((Layout)gridLayout);
        GC gc = new GC((Drawable)this.composite);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.sashForm = new SashForm(this.composite, 524800);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.datesAxis = new DateValuesAxis();
        this.datesAxis.additionalSpace = 15;
        this.dateScaleCanvas = new DateScaleCanvas(this.composite);
        this.dateScaleCanvas.getControl().setVisible(false);
        ((GridData)this.dateScaleCanvas.getControl().getLayoutData()).exclude = true;
        this.dateScaleCanvas.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                BaseChartViewer.this.updateScrollbars();
                BaseChartViewer.this.revalidate();
                BaseChartViewer.this.redraw();
            }
        });
        this.verticalScaleLabel = new Label(this.composite, 0);
        this.verticalScaleLabel.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)12), -1));
        this.verticalScaleLabel.setVisible(false);
        ((GridData)this.verticalScaleLabel.getLayoutData()).exclude = true;
        Label label = new Label((Composite)this.sashForm, 0);
        label.setBackground(Display.getCurrent().getSystemColor(25));
        this.composite.getHorizontalBar().setVisible(false);
        this.composite.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseChartViewer.this.revalidate();
                BaseChartViewer.this.redraw();
                BaseChartViewer.this.composite.update();
            }
        });
        this.composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                BaseChartViewer.this.redraw();
            }
        });
        this.summaryDecorator = new SummaryBarDecorator();
        this.decorator = new CrosshairDecorator();
        this.decorator.createSummaryLabel((Composite)this.sashForm);
    }

    public void dispose() {
        this.composite.dispose();
    }

    public boolean isDisposed() {
        return this.composite.isDisposed();
    }

    public Control getControl() {
        return this.composite;
    }

    public ChartCanvas[] getChildren() {
        return this.chartCanvas;
    }

    public void setHorizontalScaleVisible(boolean visible) {
    }

    public void setVerticalScaleVisible(boolean visible) {
    }

    public Display getDisplay() {
        return this.composite.getDisplay();
    }

    protected Point getLocation() {
        return new Point(this.composite.getHorizontalBar().getSelection(), 0);
    }

    private void revalidate() {
        Rectangle clientArea = this.dateScaleCanvas.getCanvas().getClientArea();
        ScrollBar hScroll = this.composite.getHorizontalBar();
        Date firstDate = (Date)this.datesAxis.mapToValue(hScroll.getSelection());
        Date lastDate = (Date)this.datesAxis.mapToValue(hScroll.getSelection() + clientArea.width);
        ArrayList<Date> l = new ArrayList<Date>();
        Object[] values = this.datesAxis.getValues();
        int i = 0;
        while (i < values.length) {
            Date date = (Date)values[i];
            if (!(firstDate != null && date.before(firstDate) || lastDate != null && date.after(lastDate))) {
                l.add(date);
            }
            ++i;
        }
        Date[] visibleDates = l.toArray(new Date[l.size()]);
        this.dateScaleCanvas.setDatesAxis(this.datesAxis);
        this.dateScaleCanvas.setVisibleDates(visibleDates);
        this.dateScaleCanvas.setLocation(this.getLocation());
        int i2 = 0;
        while (i2 < this.chartCanvas.length) {
            if (this.chartCanvas[i2] != null && !this.chartCanvas[i2].isDisposed()) {
                this.chartCanvas[i2].setDatesAxis(this.datesAxis);
                this.chartCanvas[i2].setVisibleDates(visibleDates);
                this.chartCanvas[i2].setDateRange(firstDate, lastDate);
                this.chartCanvas[i2].setLocation(this.getLocation());
            }
            ++i2;
        }
    }

    public void print(Printer printer) {
        GC gc = new GC((Drawable)printer);
        try {
            Rectangle printerBounds = printer.getClientArea();
            Rectangle trimBounds = printer.computeTrim(printerBounds.x, printerBounds.y, printerBounds.width, printerBounds.height);
            printerBounds.x -= trimBounds.x;
            printerBounds.y -= trimBounds.y;
            printerBounds.width -= printerBounds.x;
            printerBounds.height -= printerBounds.y;
            double ratio = (double)printerBounds.width / (double)printerBounds.height;
            int y = printerBounds.y;
            int i = 0;
            while (i < this.chartCanvas.length) {
                Image image = this.chartCanvas[i].getImage();
                if (image != null) {
                    Rectangle imageBounds = image.getBounds();
                    int destHeight = (int)((double)imageBounds.height * ratio);
                    gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, printerBounds.x, y, printerBounds.width, destHeight);
                    gc.drawLine(printerBounds.x, y += destHeight, printerBounds.x + printerBounds.width, y);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateScrollbars() {
        Rectangle clientArea = this.dateScaleCanvas.getCanvas().getClientArea();
        if (clientArea.width == 0) {
            return;
        }
        ScrollBar hScroll = this.composite.getHorizontalBar();
        boolean wasVisible = hScroll.getVisible();
        Point chartSize = new Point(this.datesAxis.computeSize(clientArea.width), clientArea.height);
        int i = 0;
        while (i < 2) {
            if (hScroll != null) {
                if (chartSize.x > clientArea.width) {
                    hScroll.setVisible(true);
                } else {
                    hScroll.setVisible(false);
                    hScroll.setValues(0, 0, 1, 1, 1, 1);
                }
            }
            clientArea = this.dateScaleCanvas.getCanvas().getClientArea();
            chartSize = new Point(this.datesAxis.computeSize(clientArea.width), clientArea.height);
            ++i;
        }
        if (hScroll.getVisible()) {
            int hiddenArea = chartSize.x - clientArea.width + 1;
            int currentSelection = hScroll.getSelection();
            int rightAnchor = hScroll.getMaximum() - hScroll.getThumb();
            int selection = Math.min(currentSelection, hiddenArea - 1);
            if (!wasVisible || currentSelection == rightAnchor) {
                selection = hiddenArea;
            }
            hScroll.setValues(selection, 0, chartSize.x, clientArea.width, 5, clientArea.width);
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(IChartObject[][] input) {
        this.input = input;
        this.refresh();
    }

    private void refresh() {
        Control[] c;
        this.datesAxis.fillAvailableSpace = this.isFillAvailableSpace();
        ChartCanvas[] newCanvas = new ChartCanvas[this.input.length];
        int length = Math.min(this.chartCanvas.length, newCanvas.length);
        System.arraycopy(this.chartCanvas, 0, newCanvas, 0, length);
        int i = length;
        while (i < this.chartCanvas.length) {
            this.chartCanvas[i].getCanvas().setMenu(null);
            this.chartCanvas[i].dispose();
            ++i;
        }
        if (this.chartCanvas.length == 0 && (c = this.sashForm.getChildren()).length != 0) {
            c[0].dispose();
        }
        this.chartCanvas = newCanvas;
        this.selectedChartCanvas = null;
        this.datesAxis.clear();
        i = 0;
        while (i < this.input.length) {
            int c2 = 0;
            while (c2 < this.input[i].length) {
                this.input[i][c2].accept(new IChartObjectVisitor(){

                    @Override
                    public boolean visit(IChartObject object) {
                        if (object.getDataSeries() != null) {
                            BaseChartViewer.this.datesAxis.addValues(object.getDataSeries().getValues());
                        }
                        return true;
                    }
                });
                ++c2;
            }
            ++i;
        }
        i = 0;
        while (i < this.input.length) {
            if (this.chartCanvas[i] == null || this.chartCanvas[i].isDisposed()) {
                this.chartCanvas[i] = new ChartCanvas((Composite)this.sashForm);
                this.chartCanvas[i].getCanvas().setMenu(this.composite.getMenu());
                this.chartCanvas[i].getCanvas().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseExit(MouseEvent e) {
                        ChartCanvas chartCanvas = (ChartCanvas)e.widget.getData();
                        if (BaseChartViewer.this.activeEditor.isActive()) {
                            return;
                        }
                        chartCanvas.hideToolTip();
                        BaseChartViewer.this.dateScaleCanvas.hideToolTip();
                    }
                });
                this.chartCanvas[i].getCanvas().addMouseMoveListener(new MouseMoveListener(){
                    private ChartObjectHitVisitor visitor = new ChartObjectHitVisitor();

                    public void mouseMove(MouseEvent e) {
                        ChartCanvas chartCanvas = (ChartCanvas)e.widget.getData();
                        if (BaseChartViewer.this.showTooltips && !BaseChartViewer.this.decorator.isVisible()) {
                            String s = null;
                            if (this.visitor.getChartObject() != null) {
                                s = this.visitor.getChartObject().getToolTip(e.x, e.y);
                            }
                            if (s != null && !s.equals(chartCanvas.getCanvas().getToolTipText()) || s == null && chartCanvas.getCanvas().getToolTipText() != null) {
                                chartCanvas.getCanvas().setToolTipText(s);
                            }
                        }
                        if (BaseChartViewer.this.showScaleTooltips) {
                            chartCanvas.showToolTip(e.x, e.y);
                            int x = e.x + BaseChartViewer.this.composite.getHorizontalBar().getSelection();
                            Date value = (Date)BaseChartViewer.this.datesAxis.mapToValue(x);
                            if (value != null) {
                                BaseChartViewer.this.dateScaleCanvas.showToolTip(e.x, e.y, value);
                            }
                        }
                        if (BaseChartViewer.this.activeEditor != null && !BaseChartViewer.this.activeEditor.isActive()) {
                            this.visitor.setLocation(e.x, e.y);
                            chartCanvas.accept(this.visitor);
                            if (this.visitor.getChartObject() instanceof IEditableChartObject) {
                                Cursor cursor;
                                IEditableChartObject editableObject = (IEditableChartObject)this.visitor.getChartObject();
                                if (editableObject.isOnEditHandle(e.x, e.y)) {
                                    cursor = Display.getCurrent().getSystemCursor(2);
                                    if (chartCanvas.getCanvas().getCursor() != cursor) {
                                        chartCanvas.getCanvas().setCursor(cursor);
                                    }
                                } else if (editableObject.isOnDragHandle(e.x, e.y)) {
                                    cursor = Display.getCurrent().getSystemCursor(21);
                                    if (chartCanvas.getCanvas().getCursor() != cursor) {
                                        chartCanvas.getCanvas().setCursor(cursor);
                                    }
                                }
                            } else if (this.visitor.getChartObject() != null && chartCanvas.getCanvas().getCursor() == null) {
                                chartCanvas.getCanvas().setCursor(Display.getCurrent().getSystemCursor(21));
                            } else if (this.visitor.getChartObject() == null && chartCanvas.getCanvas().getCursor() != null) {
                                chartCanvas.getCanvas().setCursor(null);
                            }
                        }
                    }
                });
                this.chartCanvas[i].getCanvas().addMouseListener((MouseListener)new MouseAdapter(){
                    private ChartObjectHitVisitor visitor = new ChartObjectHitVisitor();

                    public void mouseDown(MouseEvent e) {
                        ChartCanvas eventCanvas = (ChartCanvas)e.widget.getData();
                        this.visitor.setLocation(e.x, e.y);
                        eventCanvas.accept(this.visitor);
                        if (BaseChartViewer.this.selectedObject != this.visitor.getChartObject()) {
                            if (BaseChartViewer.this.decorator.getMode() != 2) {
                                BaseChartViewer.this.decorator.deactivate();
                            }
                        } else if (BaseChartViewer.this.selectedObject == null) {
                            BaseChartViewer.this.decorator.activate();
                        }
                        BaseChartViewer.this.handleSelectionChanged(eventCanvas, this.visitor.getChartObject());
                        if (this.visitor.getChartObject() instanceof IEditableChartObject && e.button == 1) {
                            eventCanvas.getCanvas().update();
                            BaseChartViewer.this.decorator.setMode(0);
                            IEditableChartObject object = (IEditableChartObject)this.visitor.getChartObject();
                            BaseChartViewer.this.activeEditor.activate(BaseChartViewer.this, eventCanvas, object);
                            BaseChartViewer.this.activeEditor.handleMouseDown(BaseChartViewer.this.activeEditor.createEvent(e));
                        }
                    }
                });
                this.summaryDecorator.decorateCanvas(this.chartCanvas[i]);
                this.decorator.decorateCanvas(this.chartCanvas[i]);
            }
            if (this.selectedChartCanvas == null) {
                this.selectedChartCanvas = this.chartCanvas[i];
            }
            this.chartCanvas[i].setResolutionTimeSpan(this.getResolutionTimeSpan());
            this.chartCanvas[i].setChartObject(this.input[i]);
            this.chartCanvas[i].redraw();
            ++i;
        }
        int[] weights = new int[this.chartCanvas.length];
        if (weights.length != 0) {
            weights[0] = 100;
            int i2 = 1;
            while (i2 < weights.length) {
                weights[i2] = 25;
                ++i2;
            }
            this.sashForm.setWeights(weights);
        }
        this.sashForm.layout();
        if (this.chartCanvas.length != 0) {
            this.dateScaleCanvas.getControl().setVisible(true);
            ((GridData)this.dateScaleCanvas.getControl().getLayoutData()).exclude = false;
            this.verticalScaleLabel.setVisible(true);
            ((GridData)this.verticalScaleLabel.getLayoutData()).exclude = false;
        } else {
            this.dateScaleCanvas.getControl().setVisible(false);
            ((GridData)this.dateScaleCanvas.getControl().getLayoutData()).exclude = true;
            this.verticalScaleLabel.setVisible(false);
            ((GridData)this.verticalScaleLabel.getLayoutData()).exclude = true;
        }
        this.composite.layout();
        final HashMap set = new HashMap();
        int i3 = 0;
        while (i3 < this.chartCanvas.length) {
            this.chartCanvas[i3].accept(new IChartObjectVisitor(){

                @Override
                public boolean visit(IChartObject object) {
                    if (object == BaseChartViewer.this.selectedObject) {
                        set.put("selectedObject", object);
                    }
                    return true;
                }
            });
            ++i3;
        }
        this.handleSelectionChanged(this.selectedChartCanvas, (IChartObject)set.get("selectedObject"));
        this.updateScrollbars();
        this.revalidate();
        this.redraw();
    }

    protected void handleSelectionChanged(ChartCanvas newChartCanvas, IChartObject newSelection) {
        if (this.selectedObject != newSelection) {
            ChartObjectFocusEvent event = new ChartObjectFocusEvent(this.selectedObject, newSelection);
            if (this.selectedObject != null) {
                this.selectedObject.handleFocusLost(event);
            }
            this.selectedObject = newSelection;
            this.selectedChartCanvas = newChartCanvas;
            if (this.selectedObject != null) {
                this.selectedObject.handleFocusGained(event);
            }
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
            int i = 0;
            while (i < this.chartCanvas.length) {
                this.chartCanvas[i].redraw();
                ++i;
            }
        }
    }

    public void redraw() {
        int i = 0;
        while (i < this.chartCanvas.length) {
            if (this.chartCanvas[i] != null && !this.chartCanvas[i].isDisposed()) {
                this.chartCanvas[i].redraw();
            }
            ++i;
        }
        this.dateScaleCanvas.redraw();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.selectedObject != null ? new StructuredSelection((Object)this.selectedObject) : StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection newSelection) {
        Object element;
        if (!newSelection.isEmpty() && newSelection instanceof IStructuredSelection && (element = ((IStructuredSelection)newSelection).getFirstElement()) instanceof IChartObject) {
            int i = 0;
            while (i < this.chartCanvas.length) {
                final ChartCanvas currentCanvas = this.chartCanvas[i];
                currentCanvas.accept(new IChartObjectVisitor(){

                    @Override
                    public boolean visit(IChartObject object) {
                        if (object == element) {
                            BaseChartViewer.this.handleSelectionChanged(currentCanvas, object);
                        }
                        return true;
                    }
                });
                ++i;
            }
        }
        if (this.selectedObject != null && newSelection.isEmpty()) {
            this.handleSelectionChanged(this.selectedChartCanvas, null);
        }
    }

    protected void fireSelectionChangedEvent(SelectionChangedEvent event) {
        Object[] l = this.selectionListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((ISelectionChangedListener)l[i]).selectionChanged(event);
            }
            catch (Throwable e) {
                Status status = new Status(4, "org.eclipsetrader.ui.charts", Messages.BaseChartViewer_ExceptionErrorMessage, e);
                ChartsUIActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    public void setShowTooltips(boolean showTooltips) {
        this.showTooltips = showTooltips;
    }

    public void setCrosshairMode(int mode) {
        this.decoratorMode = mode;
        this.decorator.setMode(mode);
    }

    public void setShowScaleTooltips(boolean showScaleTooltips) {
        this.showScaleTooltips = showScaleTooltips;
    }

    public void activateEditor(IEditableChartObject object) {
        if (this.activeEditor.isActive()) {
            this.activeEditor.cancelEditing();
        }
        if (this.selectedObject != null) {
            this.handleSelectionChanged(this.selectedChartCanvas, null);
            this.selectedChartCanvas.getCanvas().update();
        }
        this.selectedChartCanvas.getCanvas().setCursor(Display.getCurrent().getSystemCursor(2));
        this.decorator.setMode(0);
        this.activeEditor.activate(this, this.selectedChartCanvas, object);
    }

    public void deactivateEditor() {
        if (this.activeEditor != null) {
            this.selectedChartCanvas.getCanvas().setCursor(null);
            this.decorator.setMode(this.decoratorMode);
        }
    }

    public ChartToolEditor getEditor() {
        return this.activeEditor;
    }

    public void setEditor(ChartToolEditor activeEditor) {
        if (this.activeEditor != null) {
            this.activeEditor.cancelEditing();
        }
        this.activeEditor = activeEditor;
    }

    public ChartCanvas getSelectedChartCanvas() {
        return this.selectedChartCanvas;
    }

    public int getSelectedChartCanvasIndex() {
        int i = 0;
        while (i < this.chartCanvas.length) {
            if (this.selectedChartCanvas == this.chartCanvas[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ChartCanvas getChartCanvas(int x, int y) {
        Point p = this.getControl().toDisplay(x, y);
        int i = 0;
        while (i < this.chartCanvas.length) {
            Rectangle bounds = this.chartCanvas[i].getCanvas().getBounds();
            if (bounds.contains(this.chartCanvas[i].getCanvas().toControl(p))) {
                return this.chartCanvas[i];
            }
            ++i;
        }
        return null;
    }

    public void setDecoratorSummaryTooltips(boolean show) {
        this.decorator.setShowSummaryTooltip(show);
    }

    public int getZoomFactor() {
        return this.datesAxis.getZoomFactor();
    }

    public void setZoomFactor(int zoomFactor) {
        this.datesAxis.setZoomFactor(zoomFactor);
        this.updateScrollbars();
        this.revalidate();
        this.redraw();
    }

    public TimeSpan getResolutionTimeSpan() {
        return this.dateScaleCanvas.getResolutionTimeSpan();
    }

    public void setResolutionTimeSpan(TimeSpan resolutionTimeSpan) {
        this.dateScaleCanvas.setResolutionTimeSpan(resolutionTimeSpan);
    }

    public int[] getWeights() {
        return this.sashForm.getWeights();
    }

    public void setWeights(int[] weights) {
        this.sashForm.setWeights(weights);
        this.sashForm.layout();
    }

    public void setFillAvailableSpace(boolean fillAvailableSpace) {
        this.fillAvailableSpace = fillAvailableSpace;
    }

    public boolean isFillAvailableSpace() {
        return this.fillAvailableSpace;
    }
}

