/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb20;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import org.mapdb20.CC;
import org.mapdb20.DBException;
import org.mapdb20.DataIO;
import org.mapdb20.Engine;
import org.mapdb20.Fun;
import org.mapdb20.Serializer;
import org.mapdb20.Store;
import org.mapdb20.StoreCached;
import org.mapdb20.StoreWAL;
import org.mapdb20.Volume;

public class StoreDirect
extends Store {
    protected static final int STORE_VERSION = 100;
    protected static final int HEADER = -1478819740;
    protected static final long PAGE_SIZE = 0x100000L;
    protected static final long PAGE_MASK = 1048575L;
    protected static final long PAGE_MASK_INVERSE = -1048576L;
    protected static final long MOFFSET = 0xFFFFFFFFFFF0L;
    protected static final long MLINKED = 8L;
    protected static final long MUNUSED = 4L;
    protected static final long MARCHIVE = 2L;
    protected static final long MPARITY = 1L;
    protected static final long STORE_SIZE = 16L;
    protected static final long MAX_RECID_OFFSET = 24L;
    protected static final long LAST_PHYS_ALLOCATED_DATA_OFFSET = 32L;
    protected static final long FREE_RECID_STACK = 40L;
    protected static final long UNUSED1 = 48L;
    protected static final long UNUSED2 = 56L;
    protected static final long UNUSED3 = 64L;
    protected static final long UNUSED4 = 72L;
    protected static final long UNUSED5 = 80L;
    protected static final int MAX_REC_SIZE = 65535;
    protected static final int SLOTS_COUNT = 4097;
    protected static final long HEAD_END = 32856L;
    protected static final long INITCRC_INDEX_PAGE = 4329042389490239043L;
    protected static final long[] EMPTY_LONGS = new long[0];
    protected volatile Volume vol;
    protected volatile Volume headVol;
    protected volatile long[] indexPages;
    protected final ScheduledExecutorService executor;
    protected final List<Snapshot> snapshots;
    protected static final long INDEX_VAL_SIZE = 8L;
    protected final long startSize;
    protected final long sizeIncrement;
    protected final boolean recidReuseDisable;
    protected final int sliceShift;
    protected final AtomicLong freeSize = new AtomicLong(-1L);
    protected static final long LONG_STACK_PREF_SIZE = 160L;
    protected static final long LONG_STACK_MIN_SIZE = 32L;
    protected static final long LONG_STACK_MAX_SIZE = 256L;

    public StoreDirect(String fileName, Volume.VolumeFactory volumeFactory, Store.Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat, ScheduledExecutorService executor, long startSize, long sizeIncrement, boolean recidReuseDisable) {
        super(fileName, volumeFactory, cache, lockScale, lockingStrategy, checksum, compress, password, readonly, snapshotEnable, fileLockDisable, fileLockHeartbeat);
        this.executor = executor;
        this.snapshots = snapshotEnable ? new CopyOnWriteArrayList() : null;
        this.sizeIncrement = Math.max(0x100000L, DataIO.nextPowTwo(sizeIncrement));
        this.startSize = Fun.roundUp(Math.max(0x100000L, startSize), this.sizeIncrement);
        this.recidReuseDisable = recidReuseDisable;
        this.sliceShift = Volume.sliceShiftFromSize(this.sizeIncrement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        this.commitLock.lock();
        try {
            this.structuralLock.lock();
            try {
                boolean empty = Volume.isEmptyFile(this.fileName);
                this.vol = this.volumeFactory.makeVolume(this.fileName, this.readonly, this.fileLockDisable, this.sliceShift, this.startSize, false);
                if (empty) {
                    this.initCreate();
                } else {
                    this.initOpen();
                }
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        catch (RuntimeException e) {
            this.initFailedCloseFiles();
            if (this.vol != null && !this.vol.isClosed()) {
                this.vol.close();
            }
            this.vol = null;
            throw e;
        }
        finally {
            this.commitLock.unlock();
        }
    }

    protected void initFailedCloseFiles() {
    }

    protected void storeSizeSet(long storeSize) {
        if (storeSize < 0x100000L) {
            throw new AssertionError();
        }
        if (storeSize % 0x100000L != 0L) {
            throw new AssertionError();
        }
        this.headVol.putLong(16L, DataIO.parity16Set(storeSize));
    }

    protected long storeSizeGet() {
        return DataIO.parity16Get(this.headVol.getLong(16L));
    }

    protected void initOpen() {
        if (!this.commitLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        int header = this.vol.getInt(0L);
        if (header != -1478819740) {
            throw new DBException.WrongConfig("This is not MapDB file");
        }
        this.checkFeaturesBitmap(this.vol.getLong(8L));
        this.initHeadVol();
        int expectedChecksum = this.vol.getInt(4L);
        int actualChecksum = this.headChecksum(this.vol);
        if (actualChecksum != expectedChecksum) {
            throw new DBException.HeadChecksumBroken();
        }
        long[] ip = new long[]{0L};
        long indexPage = DataIO.parity16Get(this.vol.getLong(32856L));
        int i = 1;
        while (indexPage != 0L) {
            if (indexPage % 0x100000L != 0L) {
                throw new DBException.DataCorruption();
            }
            if (ip.length == i) {
                ip = Arrays.copyOf(ip, ip.length * 4);
            }
            ip[i] = indexPage;
            indexPage = DataIO.parity16Get(this.vol.getLong(indexPage));
            ++i;
        }
        this.indexPages = Arrays.copyOf(ip, i);
    }

    protected void initCreate() {
        if (!this.commitLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        long features = this.makeFeaturesBitmap();
        this.indexPages = new long[]{0L};
        this.vol.ensureAvailable(0x100000L);
        this.vol.clear(0L, 0x100000L);
        this.vol.putLong(16L, DataIO.parity16Set(0x100000L));
        this.vol.putLong(24L, DataIO.parity4Set(112L));
        this.vol.putLong(32856L, DataIO.parity16Set(0L));
        this.vol.putLong(32L, DataIO.parity3Set(0L));
        for (long recid = 1L; recid < 8L; ++recid) {
            long indexVal = DataIO.parity1Set(10L);
            long indexOffset = this.recidToOffset(recid);
            this.vol.putLong(indexOffset, indexVal);
        }
        for (long masterLinkOffset = 40L; masterLinkOffset < 32856L; masterLinkOffset += 8L) {
            this.vol.putLong(masterLinkOffset, DataIO.parity4Set(0L));
        }
        this.vol.putInt(0L, -1478819740);
        this.vol.putLong(8L, features);
        this.vol.putInt(4L, this.headChecksum(this.vol));
        this.vol.sync();
        this.initHeadVol();
    }

    protected void initHeadVol() {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        this.headVol = this.vol;
    }

    public StoreDirect(String fileName) {
        this(fileName, fileName == null ? CC.DEFAULT_MEMORY_VOLUME_FACTORY : CC.DEFAULT_FILE_VOLUME_FACTORY, null, 16, 0, false, false, null, false, false, false, null, null, 0L, 0L, false);
    }

    protected int headChecksum(Volume vol2) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        int ret = 0;
        int offset = 8;
        while ((long)offset < 32856L) {
            long val = vol2.getLong(offset);
            ret += DataIO.longHash((long)offset + val);
            offset += 8;
        }
        return ret;
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        this.assertReadLocked(this.lockPos(recid));
        long[] offsets = this.offsetsGet(this.lockPos(recid), this.indexValGet(recid));
        return this.getFromOffset(serializer, offsets);
    }

    protected <A> A getFromOffset(Serializer<A> serializer, long[] offsets) {
        if (offsets == null) {
            return null;
        }
        if (offsets.length == 0) {
            return this.deserialize(serializer, 0, new DataIO.DataInputByteArray(new byte[0]));
        }
        if (offsets.length == 1) {
            int size = (int)(offsets[0] >>> 48);
            long offset = offsets[0] & 0xFFFFFFFFFFF0L;
            DataInput in = this.vol.getDataInput(offset, size);
            return this.deserialize(serializer, size, in);
        }
        int totalSize = this.offsetsTotalSize(offsets);
        byte[] b = this.getLoadLinkedRecord(offsets, totalSize);
        DataIO.DataInputByteArray in = new DataIO.DataInputByteArray(b);
        return this.deserialize(serializer, totalSize, in);
    }

    private byte[] getLoadLinkedRecord(long[] offsets, int totalSize) {
        byte[] b = new byte[totalSize];
        int bpos = 0;
        for (int i = 0; i < offsets.length; ++i) {
            int plus = i == offsets.length - 1 ? 0 : 8;
            long size = (offsets[i] >>> 48) - (long)plus;
            if ((size & 0xFFFFL) != size) {
                throw new DBException.DataCorruption("size mismatch");
            }
            long offset = offsets[i] & 0xFFFFFFFFFFF0L;
            this.vol.getData(offset + (long)plus, b, bpos, (int)size);
            bpos = (int)((long)bpos + size);
        }
        if (bpos != totalSize) {
            throw new DBException.DataCorruption("size does not match");
        }
        return b;
    }

    protected int offsetsTotalSize(long[] offsets) {
        if (offsets == null || offsets.length == 0) {
            return 0;
        }
        int totalSize = 8;
        for (long l : offsets) {
            totalSize = (int)((long)totalSize + ((l >>> 48) - 8L));
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void update2(long recid, DataIO.DataOutputByteArray out) {
        long[] newOffsets;
        int newSize;
        int pos = this.lockPos(recid);
        this.assertWriteLocked(pos);
        long oldIndexVal = this.indexValGet(recid);
        boolean releaseOld = true;
        if (this.snapshotEnable) {
            for (Snapshot snap : this.snapshots) {
                snap.oldRecids[pos].putIfAbsent(recid, oldIndexVal);
                releaseOld = false;
            }
        }
        long[] oldOffsets = this.offsetsGet(pos, oldIndexVal);
        int oldSize = this.offsetsTotalSize(oldOffsets);
        int n = newSize = out == null ? 0 : out.pos;
        if (releaseOld && oldSize == newSize) {
            newOffsets = oldOffsets;
        } else {
            this.structuralLock.lock();
            try {
                if (releaseOld && oldOffsets != null) {
                    this.freeDataPut(pos, oldOffsets);
                }
                newOffsets = newSize == 0 ? null : this.freeDataTake(out.pos);
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        this.offsetsVerify(newOffsets);
        this.putData(recid, newOffsets, out == null ? null : out.buf, out == null ? 0 : out.pos);
    }

    protected void offsetsVerify(long[] ret) {
        if (ret == null) {
            return;
        }
        for (int i = 0; i < ret.length; ++i) {
            boolean linked;
            boolean last = i == ret.length - 1;
            boolean bl = linked = (ret[i] & 8L) != 0L;
            if (!last && !linked) {
                throw new DBException.DataCorruption("body not linked");
            }
            if (last && linked) {
                throw new DBException.DataCorruption("tail is linked");
            }
            long offset = ret[i] & 0xFFFFFFFFFFF0L;
            if (offset < 0x100000L) {
                throw new DBException.DataCorruption("offset is too small");
            }
            if ((offset & 0xFFFFFFFFFFF0L) % 16L != 0L) {
                throw new DBException.DataCorruption("offset not mod 16");
            }
            int size = (int)(ret[i] >>> 48);
            if (size > 0) continue;
            throw new DBException.DataCorruption("size too small");
        }
    }

    protected long[] offsetsGet(int segment, long indexVal) {
        if (indexVal >>> 48 == 0L) {
            return (indexVal & 8L) != 0L ? null : EMPTY_LONGS;
        }
        long[] ret = new long[]{indexVal};
        while ((ret[ret.length - 1] & 8L) != 0L) {
            ret = Arrays.copyOf(ret, ret.length + 1);
            ret[ret.length - 1] = DataIO.parity3Get(this.vol.getLong(ret[ret.length - 2] & 0xFFFFFFFFFFF0L));
        }
        this.offsetsVerify(ret);
        return ret;
    }

    protected void indexValPut(long recid, int size, long offset, boolean linked, boolean unused) {
        this.assertWriteLocked(this.lockPos(recid));
        long indexOffset = this.recidToOffset(recid);
        long newval = StoreDirect.composeIndexVal(size, offset, linked, unused, true);
        this.vol.putLong(indexOffset, newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <A> void delete2(long recid, Serializer<A> serializer) {
        this.assertWriteLocked(this.lockPos(recid));
        int pos = this.lockPos(recid);
        long oldIndexVal = this.indexValGet(recid);
        long[] offsets = this.offsetsGet(pos, oldIndexVal);
        boolean releaseOld = true;
        if (this.snapshotEnable) {
            for (Snapshot snap : this.snapshots) {
                snap.oldRecids[pos].putIfAbsent(recid, oldIndexVal);
                releaseOld = false;
            }
        }
        if (offsets != null && releaseOld) {
            this.structuralLock.lock();
            try {
                this.freeDataPut(pos, offsets);
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        this.indexValPut(recid, 0, 0L, true, true);
        if (!this.recidReuseDisable) {
            this.structuralLock.lock();
            try {
                this.longStackPut(40L, recid, false);
            }
            finally {
                this.structuralLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrSize() {
        this.structuralLock.lock();
        try {
            long l = this.vol.length() - this.lastAllocatedDataGet() % 0x100000L;
            return l;
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFreeSize() {
        long ret = this.freeSize.get();
        if (ret != -1L) {
            return ret;
        }
        this.structuralLock.lock();
        try {
            ret = this.freeSize.get();
            if (ret != -1L) {
                long l = ret;
                return l;
            }
            ret = 8L * this.longStackCount(40L);
            for (long stackNum = 1L; stackNum <= 4097L; ++stackNum) {
                long indexOffset = 40L + stackNum * 8L;
                long size = stackNum * 16L;
                ret += size * this.longStackCount(indexOffset);
            }
            this.freeSize.set(ret);
            long l = ret;
            return l;
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    @Override
    public boolean fileLoad() {
        return this.vol.fileLoad();
    }

    protected void freeSizeIncrement(int increment) {
        long val;
        while ((val = this.freeSize.get()) != -1L && !this.freeSize.compareAndSet(val, val + (long)increment)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long recid;
        this.structuralLock.lock();
        try {
            recid = this.freeRecidTake();
        }
        finally {
            this.structuralLock.unlock();
        }
        Lock lock = this.locks[this.lockPos(recid)].writeLock();
        lock.lock();
        try {
            this.indexValPut(recid, 0, 0L, true, true);
        }
        finally {
            lock.unlock();
        }
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long recid;
        DataIO.DataOutputByteArray out = this.serialize(value, serializer);
        boolean notalloc = out == null || out.pos == 0;
        this.commitLock.lock();
        try {
            this.structuralLock.lock();
            try {
                recid = this.freeRecidTake();
            }
            finally {
                this.structuralLock.unlock();
            }
            int pos = this.lockPos(recid);
            Lock lock = this.locks[pos].writeLock();
            lock.lock();
            try {
                long[] offsets;
                if (this.recidReuseDisable && this.vol.getLong(this.recidToOffset(recid)) != 0L) {
                    throw new AssertionError((Object)("Recid not empty: " + recid));
                }
                if (this.caches != null) {
                    this.caches[pos].put(recid, value);
                }
                if (this.snapshotEnable) {
                    for (Snapshot snap : this.snapshots) {
                        snap.oldRecids[pos].putIfAbsent(recid, 0L);
                    }
                }
                this.structuralLock.lock();
                try {
                    offsets = notalloc ? null : this.freeDataTake(out.pos);
                }
                finally {
                    this.structuralLock.unlock();
                }
                if (offsets != null && (offsets[0] & 0xFFFFFFFFFFF0L) < 0x100000L) {
                    throw new DBException.DataCorruption();
                }
                this.putData(recid, offsets, out == null ? null : out.buf, out == null ? 0 : out.pos);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.commitLock.unlock();
        }
        return recid;
    }

    protected void putData(long recid, long[] offsets, byte[] src, int srcLen) {
        this.assertWriteLocked(this.lockPos(recid));
        if (this.offsetsTotalSize(offsets) != (src == null ? 0 : srcLen)) {
            throw new DBException.DataCorruption("size mismatch");
        }
        if (offsets != null) {
            int outPos = 0;
            for (int i = 0; i < offsets.length; ++i) {
                boolean last;
                if ((offsets[i] & 8L) == 0L != (last = i == offsets.length - 1)) {
                    throw new DBException.DataCorruption("linked bit set wrong way");
                }
                long offset = offsets[i] & 0xFFFFFFFFFFF0L;
                if (offset % 16L != 0L) {
                    throw new DBException.DataCorruption("not aligned to 16");
                }
                int plus = last ? 0 : 8;
                int size = (int)((offsets[i] >>> 48) - (long)plus);
                if ((size & 0xFFFF) != size || size == 0) {
                    throw new DBException.DataCorruption("size mismatch");
                }
                int segment = this.lockPos(recid);
                if (!last) {
                    this.putDataSingleWithLink(segment, offset, DataIO.parity3Set(offsets[i + 1]), src, outPos, size);
                } else {
                    this.putDataSingleWithoutLink(segment, offset, src, outPos, size);
                }
                outPos += size;
            }
            if (outPos != srcLen) {
                throw new DBException.DataCorruption("size mismatch");
            }
        }
        boolean firstLinked = offsets != null && offsets.length > 1 || src == null;
        boolean empty = offsets == null || offsets.length == 0;
        int firstSize = (int)(empty ? 0L : offsets[0] >>> 48);
        long firstOffset = empty ? 0L : offsets[0] & 0xFFFFFFFFFFF0L;
        this.indexValPut(recid, firstSize, firstOffset, firstLinked, false);
    }

    protected void putDataSingleWithoutLink(int segment, long offset, byte[] buf, int bufPos, int size) {
        this.vol.putData(offset, buf, bufPos, size);
    }

    protected void putDataSingleWithLink(int segment, long offset, long link, byte[] buf, int bufPos, int size) {
        this.vol.putLong(offset, link);
        this.vol.putData(offset + 8L, buf, bufPos, size);
    }

    protected void freeDataPut(int segment, long[] linkedOffsets) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        for (long v : linkedOffsets) {
            int size = StoreDirect.round16Up((int)(v >>> 48));
            this.freeDataPut(segment, v &= 0xFFFFFFFFFFF0L, size);
        }
    }

    protected void freeDataPut(int segment, long offset, int size) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (size % 16 != 0) {
            throw new DBException.DataCorruption("unalligned size");
        }
        if (offset % 16L != 0L || offset < 0x100000L) {
            throw new DBException.DataCorruption("wrong offset");
        }
        if (!(this instanceof StoreWAL)) {
            this.vol.clear(offset, offset + (long)size);
        }
        if (offset + (long)size == this.lastAllocatedDataGet()) {
            if (offset % 0x100000L == 0L) {
                if (offset + 0x100000L != this.storeSizeGet()) {
                    throw new AssertionError();
                }
                this.storeSizeSet(offset);
                this.lastAllocatedDataSet(0L);
            } else {
                this.lastAllocatedDataSet(offset);
            }
            return;
        }
        this.freeSizeIncrement(size);
        this.longStackPut(this.longStackMasterLinkOffset(size), offset >>> 4, false);
    }

    protected long[] freeDataTake(int size) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (size <= 0) {
            throw new DBException.DataCorruption("size too small");
        }
        long[] ret = EMPTY_LONGS;
        while (size > 65535) {
            ret = Arrays.copyOf(ret, ret.length + 1);
            ret[ret.length - 1] = 0xFFFF000000000000L | this.freeDataTakeSingle(StoreDirect.round16Up(65535), false) | 8L;
            size = size - 65535 + 8;
        }
        ret = Arrays.copyOf(ret, ret.length + 1);
        ret[ret.length - 1] = (long)size << 48 | this.freeDataTakeSingle(StoreDirect.round16Up(size), false);
        return ret;
    }

    protected long freeDataTakeSingle(int size, boolean recursive) {
        long lastAllocatedData;
        long ret;
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (size % 16 != 0) {
            throw new DBException.DataCorruption("unalligned size");
        }
        if (size > StoreDirect.round16Up(65535)) {
            throw new DBException.DataCorruption("size too big");
        }
        long l = ret = recursive ? 0L : this.longStackTake(this.longStackMasterLinkOffset(size), false) << 4;
        if (ret != 0L) {
            if (ret < 0x100000L) {
                throw new DBException.DataCorruption("wrong ret");
            }
            if (ret % 16L != 0L) {
                throw new DBException.DataCorruption("unalligned ret");
            }
            this.freeSizeIncrement(-size);
            return ret;
        }
        if (this.lastAllocatedDataGet() == 0L) {
            long page = this.pageAllocate();
            this.lastAllocatedDataSet(page + (long)size);
            if (page < 0x100000L) {
                throw new DBException.DataCorruption("wrong page");
            }
            if (page % 16L != 0L) {
                throw new DBException.DataCorruption("unalligned page");
            }
            return page;
        }
        if ((this.lastAllocatedDataGet() % 0x100000L + (long)size) / 0x100000L != 0L) {
            long offsetToFree = this.lastAllocatedDataGet();
            long sizeToFree = Fun.roundUp(offsetToFree, 0x100000L) - offsetToFree;
            if (offsetToFree % 16L != 0L || sizeToFree % 16L != 0L) {
                throw new AssertionError();
            }
            this.lastAllocatedDataSet(0L);
            this.freeDataPut(-1, offsetToFree, (int)sizeToFree);
            long retOffset = this.freeDataTakeSingle(size, recursive);
            return retOffset;
        }
        ret = lastAllocatedData = this.lastAllocatedDataGet();
        this.lastAllocatedDataSet(lastAllocatedData + (long)size);
        if (ret % 16L != 0L) {
            throw new DBException.DataCorruption();
        }
        if (lastAllocatedData % 16L != 0L) {
            throw new DBException.DataCorruption();
        }
        if (ret < 0x100000L) {
            throw new DBException.DataCorruption();
        }
        return ret;
    }

    protected void longStackPut(long masterLinkOffset, long value, boolean recursive) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % 8L != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        long masterLinkVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset));
        long pageOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        if (masterLinkVal == 0L) {
            this.longStackNewPage(masterLinkOffset, 0L, value, recursive);
            return;
        }
        long currSize = masterLinkVal >>> 48;
        long prevLinkVal = DataIO.parity4Get(this.vol.getLong(pageOffset));
        long pageSize = prevLinkVal >>> 48;
        if (currSize + 8L >= pageSize) {
            this.vol.clear(pageOffset + currSize, pageOffset + pageSize);
            this.longStackNewPage(masterLinkOffset, pageOffset, value, recursive);
            return;
        }
        currSize += (long)this.vol.putLongPackBidi(pageOffset + currSize, this.longParitySet(value));
        this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | pageOffset));
    }

    protected void longStackNewPage(long masterLinkOffset, long prevPageOffset, long value, boolean recursive) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        long newPageSize = 160L;
        if (!recursive) {
            for (long size = 256L; size >= 32L; size -= 16L) {
                long indexVal;
                long masterLinkOffset2 = this.longStackMasterLinkOffset(size);
                if (masterLinkOffset == masterLinkOffset2 || (indexVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset2))) == 0L) continue;
                newPageSize = size;
                break;
            }
            if (this.longStackMasterLinkOffset(newPageSize) == masterLinkOffset) {
                newPageSize += 16L;
            }
        }
        long newPageOffset = this.freeDataTakeSingle((int)newPageSize, true);
        this.vol.putLong(newPageOffset, DataIO.parity4Set(newPageSize << 48 | prevPageOffset));
        long currSize = 8 + this.vol.putLongPackBidi(newPageOffset + 8L, this.longParitySet(value));
        this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | newPageOffset));
    }

    protected long longStackTake(long masterLinkOffset, boolean recursive) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (masterLinkOffset < 40L || masterLinkOffset > this.longStackMasterLinkOffset(StoreDirect.round16Up(65535)) || masterLinkOffset % 8L != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        long masterLinkVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            return 0L;
        }
        long currSize = masterLinkVal >>> 48;
        long pageOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        long ret = this.vol.getLongPackBidiReverse(pageOffset + currSize, pageOffset + 8L);
        long oldCurrSize = currSize;
        this.vol.clear(pageOffset + (currSize -= ret >>> 60), pageOffset + oldCurrSize);
        ret = this.longParityGet(ret & 0xFFFFFFFFFFFFFFFL);
        if (currSize < 8L) {
            throw new DBException.DataCorruption();
        }
        if (currSize > 8L) {
            this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | pageOffset));
            return ret;
        }
        long prevPageOffset = DataIO.parity4Get(this.vol.getLong(pageOffset));
        int currPageSize = (int)(prevPageOffset >>> 48);
        if ((prevPageOffset &= 0xFFFFFFFFFFF0L) != 0L) {
            currSize = DataIO.parity4Get(this.vol.getLong(prevPageOffset)) >>> 48;
            while (this.vol.getUnsignedByte(prevPageOffset + currSize - 1L) == 0) {
                --currSize;
            }
            if (currSize < 10L) {
                throw new DBException.DataCorruption();
            }
        } else {
            currSize = 0L;
        }
        this.headVol.putLong(masterLinkOffset, DataIO.parity4Set(currSize << 48 | prevPageOffset));
        this.freeDataPut(-1, pageOffset, currPageSize);
        return ret;
    }

    protected long longStackCount(long masterLinkOffset) {
        long pageOffset;
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % 8L != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        long nextLinkVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset));
        long ret = 0L;
        while ((pageOffset = nextLinkVal & 0xFFFFFFFFFFF0L) != 0L) {
            long currSize = DataIO.parity4Get(this.vol.getLong(pageOffset)) >>> 48;
            while (this.vol.getUnsignedByte(pageOffset + currSize - 1L) == 0) {
                --currSize;
            }
            while (currSize > 8L) {
                long read = this.vol.getLongPackBidiReverse(pageOffset + currSize, pageOffset + 8L);
                currSize -= read >>> 60;
                ++ret;
            }
            nextLinkVal = DataIO.parity4Get(this.vol.getLong(pageOffset));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.commitLock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.flush();
            this.vol.close();
            this.vol = null;
            if (this instanceof StoreCached) {
                this.headVol.close();
            }
            if (this.caches != null) {
                for (Store.Cache c : this.caches) {
                    c.close();
                }
                Arrays.fill(this.caches, null);
            }
            if (this.fileLockHeartbeat != null) {
                this.fileLockHeartbeat.unlock();
                this.fileLockHeartbeat = null;
            }
            this.closed = true;
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.commitLock.lock();
        try {
            this.flush();
        }
        finally {
            this.commitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.commitLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        this.structuralLock.lock();
        try {
            this.vol.putInt(4L, this.headChecksum(this.vol));
        }
        finally {
            this.structuralLock.unlock();
        }
        this.vol.sync();
    }

    @Override
    public void rollback() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canRollback() {
        return false;
    }

    @Override
    public Engine snapshot() throws UnsupportedOperationException {
        if (!this.snapshotEnable) {
            throw new UnsupportedOperationException();
        }
        return new Snapshot(this);
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void backup(OutputStream out, boolean incremental) {
        for (ReadWriteLock lock : this.locks) {
            lock.writeLock().lock();
        }
        try {
            long maxRecid = this.maxRecidGet();
            for (long recid = 1L; recid <= maxRecid; ++recid) {
                long indexOffset = this.recidToOffset(recid);
                long indexVal = this.vol.getLong(indexOffset);
                if ((indexVal & 4L) != 0L || indexVal == 0L || incremental && (indexVal & 2L) == 0L) continue;
                indexVal = DataIO.parity1Get(indexVal);
                this.indexValPut(recid, (int)(indexVal >>> 48), indexVal & 0xFFFFFFFFFFF0L, (indexVal & 8L) != 0L, false);
                DataIO.packLong(out, recid);
                long[] offsets = this.offsetsGet(this.lockPos(recid), indexVal);
                int totalSize = this.offsetsTotalSize(offsets);
                if (offsets != null) {
                    byte[] b = this.getLoadLinkedRecord(offsets, totalSize);
                    DataIO.packLong(out, (long)(b.length + 1));
                    out.write(b);
                    continue;
                }
                DataIO.packLong(out, 0L);
            }
            DataIO.packLong(out, -1L);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        finally {
            for (int i = this.locks.length - 1; i >= 0; --i) {
                this.locks[i].writeLock().unlock();
            }
        }
    }

    @Override
    public void backupRestore(InputStream[] ins) {
        if (8L != this.maxRecidGet()) {
            throw new DBException.WrongConfig("Can not restore backup, this store is not empty!");
        }
        for (ReadWriteLock lock : this.locks) {
            lock.writeLock().lock();
        }
        this.structuralLock.lock();
        try {
            BitSet usedRecid = new BitSet();
            for (int i = ins.length - 1; i >= 0; --i) {
                long recid;
                InputStream in = ins[i];
                while ((recid = DataIO.unpackLong(in)) != -1L) {
                    long len = DataIO.unpackLong(in);
                    if (ins.length != 1) {
                        if (recid > Integer.MAX_VALUE) {
                            throw new AssertionError();
                        }
                        if (usedRecid.get((int)recid)) {
                            long toSkip = len - 1L;
                            if (toSkip <= 0L) continue;
                            DataIO.skipFully(in, toSkip);
                            continue;
                        }
                        usedRecid.set((int)recid);
                    }
                    if (len == 0L) {
                        this.indexValPut(recid, 0, 0L, true, false);
                        continue;
                    }
                    byte[] data = new byte[(int)(len - 1L)];
                    DataIO.readFully(in, data);
                    long[] newOffsets = this.freeDataTake(data.length);
                    this.pageIndexEnsurePageForRecidAllocated(recid);
                    this.putData(recid, newOffsets, data, data.length);
                }
            }
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        finally {
            this.structuralLock.unlock();
            for (int i = this.locks.length - 1; i >= 0; --i) {
                this.locks[i].writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        if (this.compactOldFilesExists()) {
            return;
        }
        boolean isStoreCached = this instanceof StoreCached;
        this.commitLock.lock();
        try {
            for (int i = 0; i < this.locks.length; ++i) {
                Lock lock = this.locks[i].writeLock();
                lock.lock();
            }
            try {
                if (this.caches != null) {
                    for (Store.Cache c : this.caches) {
                        c.clear();
                    }
                }
                this.snapshotCloseAllOnCompact();
                String compactedFile = this.vol.getFile() == null ? null : this.fileName + ".compact";
                StoreDirect target = new StoreDirect(compactedFile, this.volumeFactory, null, this.lockScale, this.executor == null ? 2 : 1, this.checksum, this.compress, null, false, false, true, null, null, this.startSize, this.sizeIncrement, false);
                target.init();
                AtomicLong maxRecid = new AtomicLong(this.maxRecidGet());
                this.compactIndexPages(target, maxRecid);
                this.structuralLock.lock();
                try {
                    target.maxRecidSet(maxRecid.get());
                    this.indexPages = target.indexPages;
                    if (compactedFile == null) {
                        Volume oldVol = this.vol;
                        if (this instanceof StoreCached) {
                            this.headVol.close();
                        }
                        this.headVol = this.vol = target.vol;
                        oldVol.close();
                    } else {
                        File compactedFileF = new File(compactedFile);
                        target.vol.sync();
                        target.close();
                        this.vol.sync();
                        this.vol.close();
                        File currFile = new File(this.fileName);
                        File currFileRenamed = new File(currFile.getPath() + ".compact_orig");
                        if (!currFile.renameTo(currFileRenamed)) {
                            throw new AssertionError((Object)("failed to rename file " + currFile + " - " + currFile.exists() + " - " + currFileRenamed.exists()));
                        }
                        if (!compactedFileF.renameTo(currFile)) {
                            throw new AssertionError((Object)("failed to rename file " + compactedFileF));
                        }
                        if (this instanceof StoreCached) {
                            this.headVol.close();
                        }
                        this.headVol = this.vol = this.volumeFactory.makeVolume(this.fileName, this.readonly, this.fileLockDisable);
                        if (isStoreCached) {
                            ((StoreCached)this).uncommittedStackPages.clear();
                        }
                        if (!currFileRenamed.delete()) {
                            LOG.warning("Could not delete old compaction file: " + currFileRenamed);
                        }
                    }
                    this.freeSize.set(-1L);
                    this.structuralLock.unlock();
                }
                catch (Throwable throwable) {
                    this.structuralLock.unlock();
                    throw throwable;
                }
            }
            finally {
                for (int i = this.locks.length - 1; i >= 0; --i) {
                    Lock lock = this.locks[i].writeLock();
                    lock.unlock();
                }
            }
        }
        finally {
            this.commitLock.unlock();
        }
    }

    protected boolean compactOldFilesExists() {
        if (this.fileName != null) {
            for (String s : new String[]{".compact_orig", ".compact", ".wal.c", ".wal.c.compact"}) {
                File oldData = new File(this.fileName + s);
                if (!oldData.exists()) continue;
                LOG.warning("Old compaction data exists, compaction not started: " + oldData);
                return true;
            }
        }
        return false;
    }

    protected void snapshotCloseAllOnCompact() {
        if (this.snapshotEnable) {
            boolean someClosed = false;
            for (Snapshot snap : this.snapshots) {
                someClosed = true;
                snap.close();
            }
            if (someClosed) {
                LOG.log(Level.WARNING, "Compaction closed existing snapshots.");
            }
        }
    }

    protected void compactIndexPages(final StoreDirect target, final AtomicLong maxRecid) {
        long indexVal;
        int lastIndexPage = this.indexPages.length;
        while (maxRecid.get() > 7L && (((indexVal = this.indexValGetRaw(maxRecid.get())) & 4L) != 0L || indexVal == 0L)) {
            maxRecid.decrementAndGet();
        }
        long maxRecidOffset = this.recidToOffset(maxRecid.get());
        if (this.executor == null) {
            for (int indexPageI = 0; indexPageI < lastIndexPage && this.indexPages[indexPageI] <= maxRecidOffset; ++indexPageI) {
                this.compactIndexPage(target, indexPageI, maxRecid.get());
            }
        } else {
            ArrayList tasks = new ArrayList();
            int indexPageI = 0;
            while (indexPageI < lastIndexPage && this.indexPages[indexPageI] <= maxRecidOffset) {
                final int n = indexPageI++;
                Future<?> f = this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        StoreDirect.this.compactIndexPage(target, n, maxRecid.get());
                    }
                });
                tasks.add(f);
            }
            for (Future future : tasks) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new DBException.Interrupted(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void compactIndexPage(StoreDirect target, int indexPageI, long maxRecid) {
        long indexPage = this.indexPages[indexPageI];
        long recid = indexPageI == 0 ? 0L : ((long)indexPageI * 1048560L - 32856L + 8L) / 8L;
        long indexPageStart = indexPage == 0L ? 32864L : indexPage + 16L;
        long indexPageEnd = indexPage + 0x100000L;
        for (long indexOffset = indexPageStart; indexOffset < indexPageEnd; indexOffset += 8L) {
            if (indexOffset != this.recidToOffset(++recid)) {
                throw new AssertionError((Object)("Recid to offset conversion failed: indexOffset:" + indexOffset + ", recidToOffset: " + this.recidToOffset(recid) + ", recid:" + recid));
            }
            if (recid > maxRecid) break;
            long indexVal = this.vol.getLong(indexOffset);
            if ((indexVal & 4L) != 0L || indexVal == 0L) {
                target.structuralLock.lock();
                target.longStackPut(40L, recid, false);
                target.structuralLock.unlock();
                continue;
            }
            if ((indexVal & 8L) != 0L && indexVal >>> 48 != 0L) {
                long[] offsets = this.offsetsGet(this.lockPos(recid), this.indexValGet(recid));
                int totalSize = this.offsetsTotalSize(offsets);
                byte[] b = this.getLoadLinkedRecord(offsets, totalSize);
                target.locks[this.lockPos(recid)].writeLock().lock();
                target.structuralLock.lock();
                long[] newOffsets = target.freeDataTake(totalSize);
                target.pageIndexEnsurePageForRecidAllocated(recid);
                target.putData(recid, newOffsets, b, totalSize);
                target.structuralLock.unlock();
                target.locks[this.lockPos(recid)].writeLock().unlock();
                continue;
            }
            target.locks[this.lockPos(recid)].writeLock().lock();
            target.structuralLock.lock();
            target.pageIndexEnsurePageForRecidAllocated(recid);
            target.updateFromCompact(recid, indexVal, this.vol);
            target.structuralLock.unlock();
            target.locks[this.lockPos(recid)].writeLock().unlock();
        }
    }

    private void updateFromCompact(long recid, long indexVal, Volume oldVol) {
        long[] newOffset;
        int size = (int)(indexVal >>> 48);
        if (size > 0) {
            newOffset = this.freeDataTake(size);
            if (newOffset.length != 1) {
                throw new DBException.DataCorruption();
            }
            oldVol.transferInto(indexVal & 0xFFFFFFFFFFF0L, this.vol, newOffset[0] & 0xFFFFFFFFFFF0L, size);
        } else {
            newOffset = new long[1];
        }
        this.indexValPut(recid, size, newOffset[0] & 0xFFFFFFFFFFF0L, (indexVal & 8L) != 0L, false);
    }

    protected long indexValGet(long recid) {
        this.assertReadLocked(this.lockPos(recid));
        long offset = this.recidToOffset(recid);
        long indexVal = this.vol.getLong(offset);
        if (indexVal == 0L) {
            throw new DBException.EngineGetVoid();
        }
        return DataIO.parity1Get(indexVal);
    }

    protected long indexValGetRaw(long recid) {
        this.assertReadLocked(this.lockPos(recid));
        long offset = this.recidToOffset(recid);
        return this.vol.getLong(offset);
    }

    protected final long recidToOffset(long recid) {
        if (recid <= 0L) {
            throw new AssertionError();
        }
        if (recid >>> 48 != 0L) {
            throw new AssertionError();
        }
        recid = 32856L + recid * 8L;
        recid += Math.min(1L, recid / 0x100000L) * (16L + (recid - 0x100000L) / 1048560L * 16L);
        recid = this.indexPages[(int)(recid / 0x100000L)] + recid % 0x100000L;
        return recid;
    }

    protected boolean recidTooLarge(long recid) {
        try {
            this.recidToOffset(recid);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return true;
        }
    }

    protected static long composeIndexVal(int size, long offset, boolean linked, boolean unused, boolean archive) {
        if ((size & 0xFFFF) != size) {
            throw new DBException.DataCorruption("size too large");
        }
        if ((offset & 0xFFFFFFFFFFF0L) != offset) {
            throw new DBException.DataCorruption("offset too large");
        }
        offset = (long)size << 48 | offset | (linked ? 8L : 0L) | (unused ? 4L : 0L) | (archive ? 2L : 0L);
        return DataIO.parity1Set(offset);
    }

    protected long freeRecidTake() {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        long currentRecid = this.longStackTake(40L, false);
        if (currentRecid != 0L) {
            return currentRecid;
        }
        currentRecid = this.maxRecidGet() * 8L;
        this.maxRecidSet((currentRecid += 8L) / 8L);
        if (this.recidTooLarge(currentRecid /= 8L)) {
            this.pageIndexExtend();
        }
        return currentRecid;
    }

    protected void indexLongPut(long offset, long val) {
        this.vol.putLong(offset, val);
    }

    protected void pageIndexEnsurePageForRecidAllocated(long recid) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        recid = recid * 8L + 32856L;
        recid /= 1048560L;
        while ((long)this.indexPages.length <= recid) {
            this.pageIndexExtend();
        }
    }

    protected void pageIndexExtend() {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        long indexPage = this.pageAllocate();
        long nextPagePointerOffset = this.indexPages[this.indexPages.length - 1];
        nextPagePointerOffset = Math.max(nextPagePointerOffset, 32856L);
        this.indexLongPut(nextPagePointerOffset, DataIO.parity16Set(indexPage));
        this.indexLongPut(indexPage, DataIO.parity16Set(0L));
        this.indexLongPut(indexPage + 8L, 0L);
        long[] indexPages2 = Arrays.copyOf(this.indexPages, this.indexPages.length + 1);
        indexPages2[this.indexPages.length] = indexPage;
        this.indexPages = indexPages2;
    }

    protected long pageAllocate() {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        long storeSize = this.storeSizeGet();
        this.vol.ensureAvailable(storeSize + 0x100000L);
        this.vol.clear(storeSize, storeSize + 0x100000L);
        this.storeSizeSet(storeSize + 0x100000L);
        if (storeSize % 0x100000L != 0L) {
            throw new DBException.DataCorruption();
        }
        return storeSize;
    }

    protected static int round16Up(int pos) {
        return (pos + 15) / 16 * 16;
    }

    Map<Long, List<Long>> longStackDumpAll() {
        LinkedHashMap<Long, List<Long>> ret = new LinkedHashMap<Long, List<Long>>();
        for (long masterSize = 0L; masterSize < 65536L; masterSize += 16L) {
            long masterLinkOffset = masterSize == 0L ? 40L : this.longStackMasterLinkOffset(masterSize);
            List<Long> l = this.longStackDump(masterLinkOffset);
            if (l.isEmpty()) continue;
            ret.put(masterSize, l);
        }
        return ret;
    }

    protected long longStackMasterLinkOffset(long masterSize) {
        if (masterSize % 16L != 0L) {
            throw new AssertionError();
        }
        return masterSize / 2L + 40L;
    }

    List<Long> longStackDump(long masterLinkOffset) {
        long pageOffset;
        ArrayList<Long> ret = new ArrayList<Long>();
        long nextLinkVal = DataIO.parity4Get(this.headVol.getLong(masterLinkOffset));
        while ((pageOffset = nextLinkVal & 0xFFFFFFFFFFF0L) != 0L) {
            long currSize = DataIO.parity4Get(this.vol.getLong(pageOffset)) >>> 48;
            while (this.vol.getUnsignedByte(pageOffset + currSize - 1L) == 0) {
                --currSize;
            }
            while (currSize > 8L) {
                long read = this.vol.getLongPackBidiReverse(pageOffset + currSize, pageOffset + 8L);
                long val = read & 0xFFFFFFFFFFFFFFFL;
                val = this.longParityGet(val);
                ret.add(val);
                currSize -= read >>> 60;
            }
            nextLinkVal = DataIO.parity4Get(this.vol.getLong(pageOffset));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeCheck() {
        this.structuralLock.lock();
        try {
            long pageOffset;
            long storeSize = this.storeSizeGet();
            BitSet b = new BitSet((int)storeSize);
            b.set(0, 32864, true);
            if (this.vol.length() < storeSize) {
                throw new AssertionError((Object)("Store too small, need " + storeSize + ", got " + this.vol.length()));
            }
            this.vol.assertZeroes(storeSize, this.vol.length());
            for (long masterSize = 16L; masterSize <= 65536L; masterSize += 16L) {
                long pageOffset2;
                long masterOffset = this.longStackMasterLinkOffset(masterSize);
                long nextLinkVal = DataIO.parity4Get(this.headVol.getLong(masterOffset));
                while ((pageOffset2 = nextLinkVal & 0xFFFFFFFFFFF0L) != 0L) {
                    long pageSize = DataIO.parity4Get(this.vol.getLong(pageOffset2)) >>> 48;
                    this.storeCheckMark(b, true, pageOffset2, pageSize);
                    while (this.vol.getUnsignedByte(pageOffset2 + pageSize - 1L) == 0) {
                        --pageSize;
                    }
                    while (pageSize > 8L) {
                        long read = this.vol.getLongPackBidiReverse(pageOffset2 + pageSize, pageOffset2 + 8L);
                        long val = read & 0xFFFFFFFFFFFFFFFL;
                        val = this.longParityGet(val) << 4;
                        this.storeCheckMark(b, false, val & 0xFFFFFFFFFFF0L, masterSize);
                        pageSize -= read >>> 60;
                    }
                    nextLinkVal = DataIO.parity4Get(this.vol.getLong(pageOffset2));
                }
            }
            long maxRecid = this.maxRecidGet();
            long nextLinkVal = DataIO.parity4Get(this.headVol.getLong(40L));
            while ((pageOffset = nextLinkVal & 0xFFFFFFFFFFF0L) != 0L) {
                long currSize = DataIO.parity4Get(this.vol.getLong(pageOffset)) >>> 48;
                this.storeCheckMark(b, true, pageOffset, currSize);
                while (this.vol.getUnsignedByte(pageOffset + currSize - 1L) == 0) {
                    --currSize;
                }
                while (currSize > 8L) {
                    long read = this.vol.getLongPackBidiReverse(pageOffset + currSize, pageOffset + 8L);
                    long recid = this.longParityGet(read & 0xFFFFFFFFFFFFFFFL);
                    if (recid > maxRecid) {
                        throw new AssertionError((Object)"Recid too big");
                    }
                    long indexVal = this.vol.getLong(this.recidToOffset(recid));
                    if (indexVal != 0L) {
                        if ((indexVal = DataIO.parity1Get(indexVal)) >>> 48 != 0L) {
                            throw new AssertionError();
                        }
                        if ((indexVal & 0xFFFFFFFFFFF0L) != 0L) {
                            throw new AssertionError();
                        }
                        if ((indexVal & 4L) == 0L) {
                            throw new AssertionError();
                        }
                    }
                    currSize -= read >>> 60;
                }
                nextLinkVal = DataIO.parity4Get(this.vol.getLong(pageOffset));
            }
            block12: for (long recid = 1L; recid <= maxRecid; ++recid) {
                long recidVal = 0L;
                try {
                    recidVal = this.indexValGet(recid);
                }
                catch (DBException.EngineGetVoid currSize) {
                    // empty catch block
                }
                this.storeCheckMark(b, true, this.recidToOffset(recid), 8L);
                while (true) {
                    long offset = recidVal & 0xFFFFFFFFFFF0L;
                    long size = StoreDirect.round16Up((int)(recidVal >>> 48));
                    if (size == 0L) continue block12;
                    this.storeCheckMark(b, true, offset, size);
                    if ((recidVal & 8L) == 0L) continue block12;
                    recidVal = DataIO.parity3Get(this.vol.getLong(offset));
                }
            }
            long offset = this.recidToOffset(this.maxRecidGet()) + 8L;
            if (offset % 0x100000L != 0L) {
                long endOffset = Fun.roundUp(offset, 0x100000L);
                this.vol.assertZeroes(offset, endOffset);
                b.set((int)offset, (int)endOffset);
            }
            for (long pageOffset3 : this.indexPages) {
                if (pageOffset3 == 0L) continue;
                this.storeCheckMark(b, true, pageOffset3, 16L);
            }
            long lastAllocated = this.lastAllocatedDataGet();
            if (lastAllocated != 0L) {
                this.storeCheckMark(b, false, lastAllocated, Fun.roundUp(lastAllocated, 0x100000L) - lastAllocated);
            }
            int offset2 = 0;
            while ((long)offset2 < storeSize) {
                if (!b.get(offset2)) {
                    throw new AssertionError((Object)("zero at " + offset2 + " - " + this.lastAllocatedDataGet()));
                }
                ++offset2;
            }
        }
        finally {
            this.structuralLock.unlock();
        }
    }

    private void storeCheckMark(BitSet b, boolean used, long pageOffset, long pageSize) {
        int o = (int)pageOffset;
        while ((long)o < pageOffset + pageSize) {
            if (b.get(o)) {
                throw new AssertionError((Object)("Offset is marked twice: " + o));
            }
            ++o;
        }
        b.set((int)pageOffset, (int)(pageOffset + pageSize), true);
        if (!used) {
            this.vol.assertZeroes(pageOffset, pageOffset + pageSize);
        }
    }

    protected void closeFilesIgnoreException() {
        try {
            if (this.vol != null && !this.vol.isClosed()) {
                this.vol.close();
                this.vol = null;
                this.headVol = null;
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not close file: " + this.fileName, e);
        }
    }

    void assertZeroes(long startOffset, long endOffset) {
        this.vol.assertZeroes(startOffset, endOffset);
    }

    protected void maxRecidSet(long maxRecid) {
        this.headVol.putLong(24L, DataIO.parity4Set(maxRecid << 4));
    }

    protected long maxRecidGet() {
        return DataIO.parity4Get(this.headVol.getLong(24L)) >>> 4;
    }

    protected void lastAllocatedDataSet(long offset) {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (offset % 0x100000L == 0L && offset > 0L) {
            throw new AssertionError();
        }
        this.headVol.putLong(32L, DataIO.parity3Set(offset));
    }

    protected long lastAllocatedDataGet() {
        if (!this.structuralLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        return DataIO.parity3Get(this.headVol.getLong(32L));
    }

    public static final class Snapshot
    extends Engine.ReadOnly {
        protected StoreDirect engine;
        protected Store.LongLongMap[] oldRecids;

        public Snapshot(StoreDirect engine) {
            this.engine = engine;
            this.oldRecids = new Store.LongLongMap[engine.lockScale];
            for (int i = 0; i < this.oldRecids.length; ++i) {
                this.oldRecids[i] = new Store.LongLongMap();
            }
            engine.snapshots.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            StoreDirect engine = this.engine;
            int pos = engine.lockPos(recid);
            Lock lock = engine.locks[pos].readLock();
            lock.lock();
            try {
                long indexVal = this.oldRecids[pos].get(recid);
                if (indexVal == -1L) {
                    A a = null;
                    return a;
                }
                if (indexVal == -2L) {
                    A a = null;
                    return a;
                }
                if (indexVal != 0L) {
                    long[] offsets = engine.offsetsGet(pos, indexVal);
                    A a = engine.getFromOffset(serializer, offsets);
                    return a;
                }
                A a = engine.get2(recid, serializer);
                return a;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void close() {
            this.engine.snapshots.remove(this);
            this.engine = null;
            this.oldRecids = null;
        }

        @Override
        public boolean isClosed() {
            return this.engine != null;
        }

        @Override
        public boolean canRollback() {
            return false;
        }

        @Override
        public boolean canSnapshot() {
            return true;
        }

        @Override
        public Engine snapshot() throws UnsupportedOperationException {
            return this;
        }

        @Override
        public Engine getWrappedEngine() {
            return this.engine;
        }

        @Override
        public void clearCache() {
        }
    }
}

