/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb20;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NavigableMap;
import org.mapdb20.BTreeKeySerializer;
import org.mapdb20.DBException;
import org.mapdb20.DataIO;
import org.mapdb20.Engine;
import org.mapdb20.Fun;
import org.mapdb20.Pump;
import org.mapdb20.Serializer;
import org.mapdb20.Store;
import org.mapdb20.Volume;

public final class StoreArchive
extends Store {
    protected static final long FILE_SIZE_OFFSET = 16L;
    protected static final long FIRST_RESERVED_RECID_OFFSET = 88L;
    protected static final long DATA_START_OFFSET = 144L;
    protected Volume vol;
    protected long volSize;

    public StoreArchive(String fileName, Volume.VolumeFactory volumeFactory, boolean readonly) {
        this(fileName, volumeFactory, null, 1, 0, false, false, null, readonly, false, false, null);
    }

    public StoreArchive(String fileName, Volume.VolumeFactory volumeFactory, Store.Cache cache, int lockScale, int lockingStrategy, boolean checksum, boolean compress, byte[] password, boolean readonly, boolean snapshotEnable, boolean fileLockDisable, DataIO.HeartbeatFileLock fileLockHeartbeat) {
        super(fileName, volumeFactory, cache, lockScale, lockingStrategy, checksum, compress, password, readonly, snapshotEnable, fileLockDisable, fileLockHeartbeat);
    }

    @Override
    public void init() {
        boolean empty = Volume.isEmptyFile(this.fileName);
        this.vol = this.volumeFactory.makeVolume(this.fileName, this.readonly);
        if (empty) {
            this.volSize = 144L;
            this.vol.ensureAvailable(this.volSize);
            for (long recid = 1L; recid < 7L; ++recid) {
                long offset = 88L + recid * 8L - 8L;
                this.vol.putLong(offset, DataIO.parity4Set(0L));
            }
        } else {
            this.volSize = DataIO.parity4Get(this.vol.getLong(16L)) >>> 4;
        }
    }

    @Override
    protected <A> A get2(long recid, Serializer<A> serializer) {
        if (recid <= 7L && (recid = DataIO.parity4Get(this.vol.getLong(88L + recid * 8L - 8L)) >>> 4) == 0L) {
            return null;
        }
        if (recid > this.volSize) {
            throw new DBException.EngineGetVoid();
        }
        long recSize = this.vol.getPackedLong(recid);
        long recSizeBytesRead = recSize >>> 60;
        if ((recSize &= 0xFFFFFFFFFFFFFFFL) == 0L) {
            throw new DBException.EngineGetVoid();
        }
        if ((recSize = (DataIO.parity1Get(recSize) >>> 1) - 1L) == -1L) {
            return null;
        }
        if (recid + recSizeBytesRead + recSize > this.volSize) {
            throw new DBException.DataCorruption("Record goes beyond EOF");
        }
        DataInput in = this.vol.getDataInputOverlap(recid + recSizeBytesRead, (int)recSize);
        return this.deserialize(serializer, (int)recSize, in);
    }

    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        if (this.readonly) {
            throw new UnsupportedOperationException("StoreArchive is read-only");
        }
        if (value == null) {
            long ret = this.volSize;
            this.vol.ensureAvailable(this.volSize + 1L);
            this.volSize += (long)this.vol.putPackedLong(this.volSize, DataIO.parity1Set(0L));
            return ret;
        }
        DataIO.DataOutputByteArray out = this.serialize(value, serializer);
        return this.add2(out);
    }

    protected long add2(DataIO.DataOutputByteArray out) {
        long size = DataIO.parity1Set(1L + (long)out.pos << 1);
        if (this.volSize >>> 20 != this.volSize + 5L >> 20) {
            this.volSize = Fun.roundUp(this.volSize, 0x100000L);
        }
        long ret = this.volSize;
        this.vol.ensureAvailable(this.volSize + 5L);
        int bytesWritten = this.vol.putPackedLong(this.volSize, size);
        this.vol.ensureAvailable(this.volSize + (long)bytesWritten + (long)out.pos);
        this.vol.putDataOverlap(this.volSize + (long)bytesWritten, out.buf, 0, out.pos);
        this.volSize += (long)(bytesWritten + out.pos);
        return ret;
    }

    @Override
    public void close() {
        if (!this.readonly) {
            this.commit();
        }
        this.vol.close();
        this.vol = null;
    }

    @Override
    public void commit() {
        if (!this.readonly) {
            this.vol.putLong(16L, DataIO.parity4Set(this.volSize << 4));
            this.vol.sync();
        }
    }

    protected void rewriteNamedCatalog(NavigableMap<String, Object> catalog) {
        if (this.readonly) {
            throw new UnsupportedOperationException("StoreArchive is read-only");
        }
        long offset = Pump.buildTreeMap(catalog.descendingMap().entrySet().iterator(), this, Fun.extractMapEntryKey(), Fun.extractMapEntryValue(), true, 32, false, 0L, BTreeKeySerializer.STRING, Serializer.BASIC, null);
        offset = DataIO.parity4Set(offset << 4);
        this.vol.putLong(88L, offset);
    }

    @Override
    public long getCurrSize() {
        return this.volSize;
    }

    @Override
    protected void update2(long recid, DataIO.DataOutputByteArray out) {
        if (this.readonly) {
            throw new UnsupportedOperationException("StoreArchive is read-only");
        }
        if (recid <= 7L) {
            long recidVal = out == null ? 0L : this.add2(out);
            this.vol.putLong(88L + recid * 8L - 8L, DataIO.parity4Set(recidVal << 4));
            return;
        }
        if (recid > this.volSize) {
            throw new DBException.EngineGetVoid();
        }
        long recSize = this.vol.getPackedLong(recid);
        long recSizeBytesRead = recSize >>> 60;
        if ((recSize &= 0xFFFFFFFFFFFFFFFL) == 0L) {
            throw new DBException.EngineGetVoid();
        }
        if ((recSize = (DataIO.parity1Get(recSize) >>> 1) - 1L) == -1L && out != null) {
            throw new DBException.WrongConfig("StoreArchive supports updates only if old and new record has the same size.But here old=null, new!=null");
        }
        if (recSize != (long)out.pos) {
            throw new DBException.WrongConfig("StoreArchive supports updates only if old and new record has the same size.But here oldSize=" + recSize + ", newSize=" + out.pos);
        }
        this.vol.putDataOverlap(recid + recSizeBytesRead, out.buf, 0, out.pos);
    }

    @Override
    protected <A> void delete2(long recid, Serializer<A> serializer) {
        throw new UnsupportedOperationException("StoreArchive is read-only");
    }

    @Override
    public long getFreeSize() {
        return 0L;
    }

    @Override
    public boolean fileLoad() {
        return this.vol.fileLoad();
    }

    @Override
    public void backup(OutputStream out, boolean incremental) {
        throw new UnsupportedOperationException("StoreArchive has different RECID layout");
    }

    @Override
    public void backupRestore(InputStream[] in) {
        throw new UnsupportedOperationException("StoreArchive has different RECID layout");
    }

    @Override
    public long preallocate() {
        throw new UnsupportedOperationException("StoreArchive is read-only");
    }

    @Override
    public void rollback() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("StoreArchive is read-only");
    }

    @Override
    public boolean canRollback() {
        return false;
    }

    @Override
    public Engine snapshot() throws UnsupportedOperationException {
        return this;
    }

    @Override
    public void compact() {
    }
}

