/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb20;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.mapdb20.Serializer;
import org.mapdb20.SerializerBase;

public final class Fun {
    public static final Object PLACEHOLDER = new Object(){

        public String toString() {
            return "Fun.PLACEHOLDER";
        }
    };
    public static final Comparator COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    public static final Comparator REVERSE_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return -COMPARATOR.compare(o1, o2);
        }
    };
    public static final Iterator EMPTY_ITERATOR = new ArrayList(0).iterator();
    public static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (o1 == o2) {
                return 0;
            }
            int len = Math.min(o1.length, o2.length);
            for (int i = 0; i < len; ++i) {
                int b1 = o1[i] & 0xFF;
                int b2 = o2[i] & 0xFF;
                if (b1 == b2) continue;
                return b1 - b2;
            }
            return o1.length - o2.length;
        }
    };
    public static final Comparator<char[]> CHAR_ARRAY_COMPARATOR = new Comparator<char[]>(){

        @Override
        public int compare(char[] o1, char[] o2) {
            int len = Math.min(o1.length, o2.length);
            for (int i = 0; i < len; ++i) {
                char b1 = o1[i];
                char b2 = o2[i];
                if (b1 == b2) continue;
                return b1 - b2;
            }
            return Fun.compareInt(o1.length, o2.length);
        }
    };
    public static final Comparator<int[]> INT_ARRAY_COMPARATOR = new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            if (o1 == o2) {
                return 0;
            }
            int len = Math.min(o1.length, o2.length);
            for (int i = 0; i < len; ++i) {
                if (o1[i] == o2[i]) continue;
                if (o1[i] > o2[i]) {
                    return 1;
                }
                return -1;
            }
            return Fun.compareInt(o1.length, o2.length);
        }
    };
    public static final Comparator<long[]> LONG_ARRAY_COMPARATOR = new Comparator<long[]>(){

        @Override
        public int compare(long[] o1, long[] o2) {
            if (o1 == o2) {
                return 0;
            }
            int len = Math.min(o1.length, o2.length);
            for (int i = 0; i < len; ++i) {
                if (o1[i] == o2[i]) continue;
                if (o1[i] > o2[i]) {
                    return 1;
                }
                return -1;
            }
            return Fun.compareInt(o1.length, o2.length);
        }
    };
    public static final Comparator<double[]> DOUBLE_ARRAY_COMPARATOR = new Comparator<double[]>(){

        @Override
        public int compare(double[] o1, double[] o2) {
            if (o1 == o2) {
                return 0;
            }
            int len = Math.min(o1.length, o2.length);
            for (int i = 0; i < len; ++i) {
                if (o1[i] == o2[i]) continue;
                if (o1[i] > o2[i]) {
                    return 1;
                }
                return -1;
            }
            return Fun.compareInt(o1.length, o2.length);
        }
    };
    public static final Comparator<Object[]> COMPARABLE_ARRAY_COMPARATOR = new Comparator<Object[]>(){

        @Override
        public int compare(Object[] o1, Object[] o2) {
            if (o1 == o2) {
                return 0;
            }
            int len = Math.min(o1.length, o2.length);
            for (int i = 0; i < len; ++i) {
                int r = COMPARATOR.compare(o1[i], o2[i]);
                if (r == 0) continue;
                return r;
            }
            return Fun.compareInt(o1.length, o2.length);
        }
    };
    public static final RecordCondition RECORD_ALWAYS_TRUE = new RecordCondition(){

        public boolean run(long recid, Object value, Serializer serializer) {
            return true;
        }
    };

    public static <T> Comparator<T> comparator() {
        return COMPARATOR;
    }

    public static <T> Comparator<T> reverseComparator() {
        return REVERSE_COMPARATOR;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    private Fun() {
    }

    public static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static long roundUp(long number, long roundUpToMultipleOf) {
        return (number + roundUpToMultipleOf - 1L) / roundUpToMultipleOf * roundUpToMultipleOf;
    }

    public static long roundDown(long number, long roundDownToMultipleOf) {
        return number - number % roundDownToMultipleOf;
    }

    static String toString(Object keys) {
        if (keys instanceof long[]) {
            return Arrays.toString((long[])keys);
        }
        if (keys instanceof int[]) {
            return Arrays.toString((int[])keys);
        }
        if (keys instanceof byte[]) {
            return Arrays.toString((byte[])keys);
        }
        if (keys instanceof char[]) {
            return Arrays.toString((char[])keys);
        }
        if (keys instanceof float[]) {
            return Arrays.toString((float[])keys);
        }
        if (keys instanceof double[]) {
            return Arrays.toString((double[])keys);
        }
        if (keys instanceof boolean[]) {
            return Arrays.toString((boolean[])keys);
        }
        if (keys instanceof Object[]) {
            return Arrays.toString((Object[])keys);
        }
        return keys.toString();
    }

    public static boolean arrayContains(long[] longs, long val) {
        for (long val2 : longs) {
            if (val != val2) continue;
            return true;
        }
        return false;
    }

    public static <K, V> Function1<K, Pair<K, V>> extractKey() {
        return new Function1<K, Pair<K, V>>(){

            @Override
            public K run(Pair<K, V> t) {
                return t.a;
            }
        };
    }

    public static <K, V> Function1<V, Pair<K, V>> extractValue() {
        return new Function1<V, Pair<K, V>>(){

            @Override
            public V run(Pair<K, V> t) {
                return t.b;
            }
        };
    }

    public static <K, V> Function1<K, Map.Entry<K, V>> extractMapEntryKey() {
        return new Function1<K, Map.Entry<K, V>>(){

            @Override
            public K run(Map.Entry<K, V> t) {
                return t.getKey();
            }
        };
    }

    public static <K, V> Function1<V, Map.Entry<K, V>> extractMapEntryValue() {
        return new Function1<V, Map.Entry<K, V>>(){

            @Override
            public V run(Map.Entry<K, V> t) {
                return t.getValue();
            }
        };
    }

    public static <K> Function1<K, K> extractNoTransform() {
        return new Function1<K, K>(){

            @Override
            public K run(K k) {
                return k;
            }
        };
    }

    public static int compareInt(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareLong(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static Iterable<Object[]> filter(final NavigableSet<Object[]> set, final Object ... keys) {
        return new Iterable<Object[]>(){

            @Override
            public Iterator<Object[]> iterator() {
                final Iterator iter = set.tailSet(keys).iterator();
                if (!iter.hasNext()) {
                    return EMPTY_ITERATOR;
                }
                final Comparator comparator = set.comparator();
                return new Iterator<Object[]>(){
                    Object[] next = this.moveToNext();

                    Object[] moveToNext() {
                        Object[] next2;
                        if (!iter.hasNext()) {
                            return null;
                        }
                        Object[] next = (Object[])iter.next();
                        if (next == null) {
                            return null;
                        }
                        Object[] objectArray = next2 = next.length <= keys.length ? next : Arrays.copyOf(next, keys.length);
                        if (comparator.compare(next2, keys) != 0) {
                            return null;
                        }
                        return next;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Object[] next() {
                        Object[] ret = this.next;
                        if (ret == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = this.moveToNext();
                        return ret;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static interface RecordCondition<A> {
        public boolean run(long var1, A var3, Serializer<A> var4);
    }

    public static final class ArrayComparator
    implements Comparator<Object[]> {
        protected final Comparator[] comparators;

        public ArrayComparator(Comparator ... comparators2) {
            this.comparators = (Comparator[])comparators2.clone();
            for (int i = 0; i < this.comparators.length; ++i) {
                if (this.comparators[i] != null) continue;
                this.comparators[i] = COMPARATOR;
            }
        }

        protected ArrayComparator(SerializerBase serializer, DataInput in, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.comparators = (Comparator[])serializer.deserialize(in, objectStack);
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int len = Math.min(o1.length, o2.length);
            for (int i = 0; i < len; ++i) {
                Object a1 = o1[i];
                Object a2 = o2[i];
                int r = a1 == a2 ? 0 : (a1 == null ? 1 : (a2 == null ? -1 : this.comparators[i].compare(a1, a2)));
                if (r == 0) continue;
                return r;
            }
            return Fun.compareInt(o1.length, o2.length);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayComparator that = (ArrayComparator)o;
            return Arrays.equals(this.comparators, that.comparators);
        }

        public int hashCode() {
            return Arrays.hashCode(this.comparators);
        }
    }

    public static interface Function2<R, A, B> {
        public R run(A var1, B var2);
    }

    public static interface Function1Int<R> {
        public R run(int var1);
    }

    public static interface Function1<R, A> {
        public R run(A var1);
    }

    public static interface Function0<R> {
        public R run();
    }

    public static final class Pair<A, B>
    implements Comparable<Pair<A, B>>,
    Serializable {
        private static final long serialVersionUID = -8816277286657643283L;
        public final A a;
        public final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        protected Pair(SerializerBase serializer, DataInput in, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.a = serializer.deserialize(in, objectStack);
            this.b = serializer.deserialize(in, objectStack);
        }

        @Override
        public int compareTo(Pair<A, B> o) {
            int i = ((Comparable)this.a).compareTo(o.a);
            if (i != 0) {
                return i;
            }
            return ((Comparable)this.b).compareTo(o.b);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair t = (Pair)o;
            return Fun.eq(this.a, t.a) && Fun.eq(this.b, t.b);
        }

        public int hashCode() {
            int result = this.a != null ? this.a.hashCode() : 0;
            result = 31 * result + (this.b != null ? this.b.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Pair[" + this.a + ", " + this.b + "]";
        }
    }
}

