/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.fetcher.samples;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;

public class FeedAggregator {
    public static void main(String[] args) {
        boolean ok = false;
        if (args.length >= 2) {
            try {
                String outputType = args[0];
                SyndFeedImpl feed = new SyndFeedImpl();
                feed.setFeedType(outputType);
                feed.setTitle("Aggregated Feed");
                feed.setDescription("Anonymous Aggregated Feed");
                feed.setAuthor("anonymous");
                feed.setLink("http://www.anonymous.com");
                ArrayList entries = new ArrayList();
                feed.setEntries(entries);
                FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
                HttpURLFeedFetcher feedFetcher = new HttpURLFeedFetcher(feedInfoCache);
                int i = 1;
                while (i < args.length) {
                    URL inputUrl = new URL(args[i]);
                    SyndFeed inFeed = feedFetcher.retrieveFeed(inputUrl);
                    entries.addAll(inFeed.getEntries());
                    ++i;
                }
                SyndFeedOutput output = new SyndFeedOutput();
                output.output((SyndFeed)feed, (Writer)new PrintWriter(System.out));
                ok = true;
            }
            catch (Exception ex) {
                System.out.println("ERROR: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (!ok) {
            System.out.println();
            System.out.println("FeedAggregator aggregates different feeds into a single one.");
            System.out.println("The first parameter must be the feed type for the aggregated feed.");
            System.out.println(" [valid values are: rss_0.9, rss_0.91, rss_0.92, rss_0.93, ]");
            System.out.println(" [                  rss_0.94, rss_1.0, rss_2.0 & atom_0.3  ]");
            System.out.println("The second to last parameters are the URLs of feeds to aggregate.");
            System.out.println();
        }
    }
}

