/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.fetcher.impl;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.AbstractFeedFetcher;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class HttpURLFeedFetcher
extends AbstractFeedFetcher {
    static final int POLL_EVENT = 1;
    static final int RETRIEVE_EVENT = 2;
    static final int UNCHANGED_EVENT = 3;
    private FeedFetcherCache feedInfoCache;

    public HttpURLFeedFetcher() {
    }

    public HttpURLFeedFetcher(FeedFetcherCache feedInfoCache) {
        this();
        this.setFeedInfoCache(feedInfoCache);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyndFeed retrieveFeed(URL feedUrl) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        HttpURLConnection httpConnection;
        block16: {
            if (feedUrl == null) {
                throw new IllegalArgumentException("null is not a valid URL");
            }
            URLConnection connection = feedUrl.openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                throw new IllegalArgumentException(String.valueOf(feedUrl.toExternalForm()) + " is not a valid HTTP Url");
            }
            httpConnection = (HttpURLConnection)connection;
            FeedFetcherCache cache = this.getFeedInfoCache();
            if (cache != null) {
                SyndFeedInfo syndFeedInfo = cache.getFeedInfo(feedUrl);
                this.setRequestHeaders(connection, syndFeedInfo);
                httpConnection.connect();
                try {
                    this.fireEvent("FEED_POLLED", connection);
                    if (syndFeedInfo == null) {
                        syndFeedInfo = new SyndFeedInfo();
                        this.retrieveAndCacheFeed(feedUrl, syndFeedInfo, httpConnection);
                    } else {
                        int responseCode = httpConnection.getResponseCode();
                        if (responseCode != 304) {
                            this.retrieveAndCacheFeed(feedUrl, syndFeedInfo, httpConnection);
                        } else {
                            this.fireEvent("FEED_UNCHANGED", connection);
                        }
                    }
                    SyndFeed syndFeed = syndFeedInfo.getSyndFeed();
                    Object var7_11 = null;
                    httpConnection.disconnect();
                    return syndFeed;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    httpConnection.disconnect();
                    throw throwable;
                }
            }
            this.fireEvent("FEED_POLLED", connection);
            InputStream inputStream = null;
            this.setRequestHeaders(connection, null);
            httpConnection.connect();
            try {
                SyndFeed syndFeed;
                block15: {
                    try {
                        inputStream = httpConnection.getInputStream();
                        syndFeed = this.getSyndFeedFromStream(inputStream, connection);
                        Object var7_13 = null;
                        if (inputStream == null) break block15;
                    }
                    catch (IOException e) {
                        this.handleErrorCodes(((HttpURLConnection)connection).getResponseCode());
                    }
                    inputStream.close();
                }
                httpConnection.disconnect();
                return syndFeed;
                Object var7_15 = null;
                if (inputStream == null) break block16;
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                httpConnection.disconnect();
                throw throwable;
            }
            inputStream.close();
        }
        httpConnection.disconnect();
        return null;
    }

    protected void retrieveAndCacheFeed(URL feedUrl, SyndFeedInfo syndFeedInfo, HttpURLConnection connection) throws IllegalArgumentException, FeedException, FetcherException, IOException {
        this.handleErrorCodes(connection.getResponseCode());
        this.resetFeedInfo(feedUrl, syndFeedInfo, connection);
        FeedFetcherCache cache = this.getFeedInfoCache();
        if (cache != null) {
            cache.setFeedInfo(feedUrl, syndFeedInfo);
        }
    }

    /*
     * Exception decompiling
     */
    protected void resetFeedInfo(URL orignalUrl, SyndFeedInfo syndFeedInfo, HttpURLConnection connection) throws IllegalArgumentException, IOException, FeedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 172->176)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setRequestHeaders(URLConnection connection, SyndFeedInfo syndFeedInfo) {
        if (syndFeedInfo != null) {
            Object lastModified;
            if (syndFeedInfo.getLastModified() != null && (lastModified = syndFeedInfo.getLastModified()) instanceof Long) {
                connection.setIfModifiedSince((Long)syndFeedInfo.getLastModified());
            }
            if (syndFeedInfo.getETag() != null) {
                connection.setRequestProperty("If-None-Match", syndFeedInfo.getETag());
            }
        }
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.addRequestProperty("User-Agent", this.getUserAgent());
        if (this.isUsingDeltaEncoding()) {
            connection.addRequestProperty("A-IM", "feed");
        }
    }

    private static SyndFeed readSyndFeedFromStream(InputStream inputStream, URLConnection connection) throws IOException, IllegalArgumentException, FeedException {
        BufferedInputStream is = "gzip".equalsIgnoreCase(connection.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(inputStream)) : new BufferedInputStream(inputStream);
        XmlReader reader = null;
        reader = connection.getHeaderField("Content-Type") != null ? new XmlReader((InputStream)is, connection.getHeaderField("Content-Type"), true) : new XmlReader((InputStream)is, true);
        return new SyndFeedInput().build((Reader)reader);
    }

    private SyndFeed getSyndFeedFromStream(InputStream inputStream, URLConnection connection) throws IOException, IllegalArgumentException, FeedException {
        SyndFeed feed = HttpURLFeedFetcher.readSyndFeedFromStream(inputStream, connection);
        this.fireEvent("FEED_RETRIEVED", connection, feed);
        return feed;
    }

    public synchronized FeedFetcherCache getFeedInfoCache() {
        return this.feedInfoCache;
    }

    public synchronized void setFeedInfoCache(FeedFetcherCache cache) {
        this.feedInfoCache = cache;
    }
}

