/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.fetcher.impl;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.AbstractFeedFetcher;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.SyndFeedInfo;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class HttpClientFeedFetcher
extends AbstractFeedFetcher {
    private FeedFetcherCache feedInfoCache;
    private CredentialSupplier credentialSupplier;

    public HttpClientFeedFetcher() {
    }

    public HttpClientFeedFetcher(FeedFetcherCache cache) {
        this();
        this.setFeedInfoCache(cache);
    }

    public HttpClientFeedFetcher(FeedFetcherCache cache, CredentialSupplier credentialSupplier) {
        this(cache);
        this.setCredentialSupplier(credentialSupplier);
    }

    public synchronized FeedFetcherCache getFeedInfoCache() {
        return this.feedInfoCache;
    }

    public synchronized void setFeedInfoCache(FeedFetcherCache feedInfoCache) {
        this.feedInfoCache = feedInfoCache;
    }

    public synchronized CredentialSupplier getCredentialSupplier() {
        return this.credentialSupplier;
    }

    public synchronized void setCredentialSupplier(CredentialSupplier credentialSupplier) {
        this.credentialSupplier = credentialSupplier;
    }

    public SyndFeed retrieveFeed(URL feedUrl) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        HttpClient client = new HttpClient();
        if (this.getCredentialSupplier() != null) {
            client.getState().setAuthenticationPreemptive(true);
            Credentials credentials = this.getCredentialSupplier().getCredentials(null, feedUrl.getHost());
            if (credentials != null) {
                client.getState().setCredentials(null, feedUrl.getHost(), credentials);
            }
        }
        return this.retrieveFeed(feedUrl, client);
    }

    public SyndFeed retrieveFeed(URL feedUrl, HttpClient client) throws IllegalArgumentException, IOException, FeedException, FetcherException {
        SyndFeed syndFeed;
        if (feedUrl == null) {
            throw new IllegalArgumentException("null is not a valid URL");
        }
        System.setProperty("httpclient.useragent", this.getUserAgent());
        String urlStr = feedUrl.toString();
        FeedFetcherCache cache = this.getFeedInfoCache();
        if (cache != null) {
            SyndFeed syndFeed2;
            GetMethod method = new GetMethod(urlStr);
            method.addRequestHeader("Accept-Encoding", "gzip");
            try {
                SyndFeedInfo syndFeedInfo;
                if (this.isUsingDeltaEncoding()) {
                    method.setRequestHeader("A-IM", "feed");
                }
                if ((syndFeedInfo = cache.getFeedInfo(feedUrl)) != null) {
                    method.setRequestHeader("If-None-Match", syndFeedInfo.getETag());
                    if (syndFeedInfo.getLastModified() instanceof String) {
                        method.setRequestHeader("If-Modified-Since", (String)syndFeedInfo.getLastModified());
                    }
                }
                method.setFollowRedirects(true);
                int statusCode = client.executeMethod((HttpMethod)method);
                this.fireEvent("FEED_POLLED", urlStr);
                this.handleErrorCodes(statusCode);
                SyndFeed feed = this.getFeed(syndFeedInfo, urlStr, (HttpMethod)method, statusCode);
                syndFeedInfo = this.buildSyndFeedInfo(feedUrl, urlStr, (HttpMethod)method, feed, statusCode);
                cache.setFeedInfo(new URL(urlStr), syndFeedInfo);
                syndFeed2 = feed = syndFeedInfo.getSyndFeed();
                Object var9_15 = null;
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                method.releaseConnection();
                throw throwable;
            }
            method.releaseConnection();
            return syndFeed2;
        }
        GetMethod method = new GetMethod(urlStr);
        try {
            method.setFollowRedirects(true);
            int statusCode = client.executeMethod((HttpMethod)method);
            this.fireEvent("FEED_POLLED", urlStr);
            this.handleErrorCodes(statusCode);
            syndFeed = this.getFeed(null, urlStr, (HttpMethod)method, statusCode);
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
        return syndFeed;
    }

    private SyndFeedInfo buildSyndFeedInfo(URL feedUrl, String urlStr, HttpMethod method, SyndFeed feed, int statusCode) throws MalformedURLException {
        Header eTagHeader;
        Header lastModifiedHeader;
        SyndFeedInfo cachedInfo;
        FeedFetcherCache cache;
        SyndFeedInfo syndFeedInfo = new SyndFeedInfo();
        syndFeedInfo.setUrl(new URL(urlStr));
        syndFeedInfo.setId(feedUrl.toString());
        Header imHeader = method.getResponseHeader("IM");
        if (imHeader != null && imHeader.getValue().indexOf("feed") >= 0 && this.isUsingDeltaEncoding() && (cache = this.getFeedInfoCache()) != null && statusCode == 226 && (cachedInfo = cache.getFeedInfo(feedUrl)) != null) {
            SyndFeed cachedFeed = cachedInfo.getSyndFeed();
            feed = HttpClientFeedFetcher.combineFeeds(cachedFeed, feed);
        }
        if ((lastModifiedHeader = method.getResponseHeader("Last-Modified")) != null) {
            syndFeedInfo.setLastModified(lastModifiedHeader.getValue());
        }
        if ((eTagHeader = method.getResponseHeader("ETag")) != null) {
            syndFeedInfo.setETag(eTagHeader.getValue());
        }
        syndFeedInfo.setSyndFeed(feed);
        return syndFeedInfo;
    }

    private static SyndFeed retrieveFeed(String urlStr, HttpMethod method) throws IOException, HttpException, FetcherException, FeedException {
        SyndFeed syndFeed;
        block2: {
            InputStream stream = null;
            stream = method.getResponseHeader("Content-Encoding") != null && "gzip".equalsIgnoreCase(method.getResponseHeader("Content-Encoding").getValue()) ? new GZIPInputStream(method.getResponseBodyAsStream()) : method.getResponseBodyAsStream();
            try {
                XmlReader reader = null;
                reader = method.getResponseHeader("Content-Type") != null ? new XmlReader(stream, method.getResponseHeader("Content-Type").getValue(), true) : new XmlReader(stream, true);
                syndFeed = new SyndFeedInput().build((Reader)reader);
                Object var4_5 = null;
                if (stream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (stream == null) break block3;
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return syndFeed;
    }

    private SyndFeed getFeed(SyndFeedInfo syndFeedInfo, String urlStr, HttpMethod method, int statusCode) throws IOException, HttpException, FetcherException, FeedException {
        if (statusCode == 304 && syndFeedInfo != null) {
            this.fireEvent("FEED_UNCHANGED", urlStr);
            return syndFeedInfo.getSyndFeed();
        }
        SyndFeed feed = HttpClientFeedFetcher.retrieveFeed(urlStr, method);
        this.fireEvent("FEED_RETRIEVED", urlStr, feed);
        return feed;
    }

    public static interface CredentialSupplier {
        public Credentials getCredentials(String var1, String var2);
    }
}

