/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.charts.indicators.PPO;
import org.eclipsetrader.ui.internal.charts.MATypeInput;
import org.eclipsetrader.ui.internal.charts.OHLCFieldInput;

public class PPOPropertiesPage
extends PropertyPage {
    private OHLCFieldInput input;
    private Spinner fastPeriod;
    private Spinner slowPeriod;
    private MATypeInput type;

    public PPOPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle("Percentage Price Oscillator");
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        label.setText("Input Field");
        this.input = new OHLCFieldInput(content);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        label = new Label(content, 0);
        label.setText("Fast Period");
        this.fastPeriod = new Spinner(content, 2048);
        this.fastPeriod.setValues(3, 1, 9999, 0, 1, 5);
        label = new Label(content, 0);
        label.setText("Slow Period");
        this.slowPeriod = new Spinner(content, 2048);
        this.slowPeriod.setValues(10, 1, 9999, 0, 1, 5);
        label = new Label(content, 0);
        label.setText("MA Type");
        this.type = new MATypeInput(content);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        PPO object = (PPO)this.getElement().getAdapter(PPO.class);
        this.input.setSelection(object.getField());
        this.fastPeriod.setSelection(object.getFastPeriod());
        this.slowPeriod.setSelection(object.getSlowPeriod());
        this.type.setSelection(object.getMaType());
        super.performDefaults();
    }

    public boolean performOk() {
        PPO object = (PPO)this.getElement().getAdapter(PPO.class);
        object.setField(this.input.getSelection());
        object.setFastPeriod(this.fastPeriod.getSelection());
        object.setSlowPeriod(this.slowPeriod.getSelection());
        object.setMaType(this.type.getSelection());
        return super.performOk();
    }
}

