/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.IObjectRenderer;
import org.eclipsetrader.ui.charts.LineRenderers;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.charts.RenderTarget;

public class MultiLineElement
implements IAdaptable,
IObjectRenderer {
    private IDataSeries dataSeries;
    private List<Line> lines = new ArrayList<Line>();

    public void addElement(IDataSeries dataSeries, RenderStyle style, RGB color) {
        this.lines.add(new Line(dataSeries, style, color));
    }

    public void renderObject(RenderTarget target, IDataSeries dataSeries) {
        for (Line l : this.lines) {
            Color color = target.registry.getColor(l.color);
            switch (l.style) {
                case Dot: {
                    LineRenderers.renderDotLine((RenderTarget)target, (IAdaptable[])l.dataSeries.getValues(), (Color)color);
                    break;
                }
                case Dash: {
                    LineRenderers.renderDashLine((RenderTarget)target, (IAdaptable[])l.dataSeries.getValues(), (Color)color);
                    break;
                }
                case Histogram: {
                    LineRenderers.renderHistogram((RenderTarget)target, (IAdaptable[])l.dataSeries.getValues(), (Color)color, (Color)color);
                    break;
                }
                case HistogramBars: {
                    LineRenderers.renderHistogramBars((RenderTarget)target, (IAdaptable[])l.dataSeries.getValues(), (int)3, (Color)color);
                    break;
                }
                default: {
                    LineRenderers.renderLine((RenderTarget)target, (IAdaptable[])l.dataSeries.getValues(), (Color)color);
                }
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IDataSeries.class)) {
            if (this.dataSeries == null) {
                this.dataSeries = new DataSeries("", new IAdaptable[0]);
                IDataSeries[] series = new IDataSeries[this.lines.size()];
                int i = 0;
                while (i < series.length) {
                    series[i] = this.lines.get((int)i).dataSeries;
                    ++i;
                }
                this.dataSeries.setChildren(series);
            }
            return this.dataSeries;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    private class Line {
        public IDataSeries dataSeries;
        public RenderStyle style;
        public RGB color;

        public Line(IDataSeries dataSeries, RenderStyle style, RGB color) {
            this.dataSeries = dataSeries;
            this.style = style;
            this.color = color;
        }
    }
}

