/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.charts.indicators.MACD;

public class MACDGeneralPropertiesPage
extends PropertyPage {
    private Text text;
    private Button override;
    private ColorSelector macdLineColor;
    private ColorSelector signalLineColor;
    private ColorSelector histLineColor;

    public MACDGeneralPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle("General");
        Label label = new Label(content, 0);
        label.setText("Label");
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        this.text = new Text(content, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        this.override = new Button(content, 32);
        this.override.setText("Override color theme");
        this.override.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MACDGeneralPropertiesPage.this.updateControlsEnablement();
            }
        });
        label = new Label(content, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(content, 0);
        label.setText("MACD Line Color");
        this.macdLineColor = new ColorSelector(content);
        this.macdLineColor.setColorValue(new RGB(0, 0, 255));
        this.macdLineColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Signal Line Color");
        this.signalLineColor = new ColorSelector(content);
        this.signalLineColor.setColorValue(new RGB(0, 0, 255));
        this.signalLineColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Histeresis Line Color");
        this.histLineColor = new ColorSelector(content);
        this.histLineColor.setColorValue(new RGB(0, 0, 255));
        this.histLineColor.getButton().setData("label", (Object)label);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        MACD object = (MACD)this.getElement().getAdapter(MACD.class);
        this.text.setText(object.getName());
        this.override.setSelection(object.getMacdLineColor() != null || object.getSignalLineColor() != null || object.getHistLineColor() != null);
        if (object.getMacdLineColor() != null) {
            this.macdLineColor.setColorValue(object.getMacdLineColor());
        }
        if (object.getSignalLineColor() != null) {
            this.signalLineColor.setColorValue(object.getSignalLineColor());
        }
        if (object.getHistLineColor() != null) {
            this.histLineColor.setColorValue(object.getHistLineColor());
        }
        this.updateControlsEnablement();
        super.performDefaults();
    }

    public boolean performOk() {
        MACD object = (MACD)this.getElement().getAdapter(MACD.class);
        object.setName(this.text.getText());
        object.setMacdLineColor(this.override.getSelection() ? this.macdLineColor.getColorValue() : null);
        object.setSignalLineColor(this.override.getSelection() ? this.signalLineColor.getColorValue() : null);
        object.setHistLineColor(this.override.getSelection() ? this.histLineColor.getColorValue() : null);
        return super.performOk();
    }

    protected void updateControlsEnablement() {
        this.macdLineColor.setEnabled(this.override.getSelection());
        ((Label)this.macdLineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        this.signalLineColor.setEnabled(this.override.getSelection());
        ((Label)this.signalLineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        this.histLineColor.setEnabled(this.override.getSelection());
        ((Label)this.histLineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
    }
}

