/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.charts.indicators.BBANDS;
import org.eclipsetrader.ui.internal.charts.MATypeInput;
import org.eclipsetrader.ui.internal.charts.OHLCFieldInput;
import org.eclipsetrader.ui.internal.charts.RenderStyleInput;

public class BBANDSPropertiesPage
extends PropertyPage {
    private OHLCFieldInput input;
    private Spinner period;
    private Spinner upperDeviation;
    private Spinner lowerDeviation;
    private MATypeInput type;
    private RenderStyleInput upperLineStyle;
    private RenderStyleInput middleLineStyle;
    private RenderStyleInput lowerLineStyle;

    public BBANDSPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle("Bollinger Bands");
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        label.setText("Input Field");
        this.input = new OHLCFieldInput(content);
        label = new Label(content, 0);
        label.setText("Period");
        this.period = new Spinner(content, 2048);
        this.period.setValues(7, 1, 9999, 0, 1, 5);
        label = new Label(content, 0);
        label.setText("Upper Deviation");
        this.upperDeviation = new Spinner(content, 2048);
        this.upperDeviation.setValues(7, 1, 9999, 2, 1, 5);
        label = new Label(content, 0);
        label.setText("Lower Deviation");
        this.lowerDeviation = new Spinner(content, 2048);
        this.lowerDeviation.setValues(7, 1, 9999, 2, 1, 5);
        label = new Label(content, 0);
        label.setText("MA Type");
        this.type = new MATypeInput(content);
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        label = new Label(content, 0);
        label.setText("Upper Line Style");
        this.upperLineStyle = new RenderStyleInput(content);
        label = new Label(content, 0);
        label.setText("Middle Line Style");
        this.middleLineStyle = new RenderStyleInput(content);
        label = new Label(content, 0);
        label.setText("Lower Line Style");
        this.lowerLineStyle = new RenderStyleInput(content);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        BBANDS object = (BBANDS)this.getElement().getAdapter(BBANDS.class);
        this.input.setSelection(object.getField());
        this.period.setSelection(object.getPeriod());
        this.upperDeviation.setSelection((int)(object.getUpperDeviation() * 100.0));
        this.lowerDeviation.setSelection((int)(object.getLowerDeviation() * 100.0));
        this.type.setSelection(object.getMaType());
        this.upperLineStyle.setSelection(object.getUpperLineStyle());
        this.middleLineStyle.setSelection(object.getMiddleLineStyle());
        this.lowerLineStyle.setSelection(object.getLowerLineStyle());
        super.performDefaults();
    }

    public boolean performOk() {
        BBANDS object = (BBANDS)this.getElement().getAdapter(BBANDS.class);
        object.setField(this.input.getSelection());
        object.setPeriod(this.period.getSelection());
        object.setUpperDeviation((double)this.upperDeviation.getSelection() / 100.0);
        object.setLowerDeviation((double)this.lowerDeviation.getSelection() / 100.0);
        object.setMaType(this.type.getSelection());
        object.setUpperLineStyle(this.upperLineStyle.getSelection());
        object.setMiddleLineStyle(this.middleLineStyle.getSelection());
        object.setLowerLineStyle(this.lowerLineStyle.getSelection());
        return super.performOk();
    }
}

