/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.charts.indicators.AROON;

public class AROONGeneralPropertiesPage
extends PropertyPage {
    private Text text;
    private Button override;
    private ColorSelector upperLineColor;
    private ColorSelector lowerLineColor;

    public AROONGeneralPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle("General");
        Label label = new Label(content, 0);
        label.setText("Label");
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        this.text = new Text(content, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ((GridData)label.getLayoutData()).heightHint = this.convertVerticalDLUsToPixels(5);
        this.override = new Button(content, 32);
        this.override.setText("Override color theme");
        this.override.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AROONGeneralPropertiesPage.this.updateControlsEnablement();
            }
        });
        label = new Label(content, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(content, 0);
        label.setText("Upper Line Color");
        this.upperLineColor = new ColorSelector(content);
        this.upperLineColor.setColorValue(new RGB(0, 0, 255));
        this.upperLineColor.getButton().setData("label", (Object)label);
        label = new Label(content, 0);
        label.setText("Lower Line Color");
        this.lowerLineColor = new ColorSelector(content);
        this.lowerLineColor.setColorValue(new RGB(0, 0, 255));
        this.lowerLineColor.getButton().setData("label", (Object)label);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        AROON object = (AROON)this.getElement().getAdapter(AROON.class);
        this.text.setText(object.getName());
        this.override.setSelection(object.getUpperLineColor() != null || object.getMiddleLineColor() != null);
        if (object.getUpperLineColor() != null) {
            this.upperLineColor.setColorValue(object.getUpperLineColor());
        }
        if (object.getMiddleLineColor() != null) {
            this.lowerLineColor.setColorValue(object.getMiddleLineColor());
        }
        this.updateControlsEnablement();
        super.performDefaults();
    }

    public boolean performOk() {
        AROON object = (AROON)this.getElement().getAdapter(AROON.class);
        object.setName(this.text.getText());
        object.setUpperLineColor(this.override.getSelection() ? this.upperLineColor.getColorValue() : null);
        object.setMiddleLineColor(this.override.getSelection() ? this.lowerLineColor.getColorValue() : null);
        return super.performOk();
    }

    protected void updateControlsEnablement() {
        this.upperLineColor.setEnabled(this.override.getSelection());
        ((Label)this.upperLineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
        this.lowerLineColor.setEnabled(this.override.getSelection());
        ((Label)this.lowerLineColor.getButton().getData("label")).setEnabled(this.override.getSelection());
    }
}

