/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.patterns;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.ILineDecorator;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.internal.charts.PatternBox;
import org.eclipsetrader.ui.internal.charts.indicators.IGeneralPropertiesAdapter;

public class DoubleReversal
implements IChartObjectFactory,
IGeneralPropertiesAdapter,
ILineDecorator,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private RenderStyle renderStyle = RenderStyle.Line;
    private RGB color;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RenderStyle getRenderStyle() {
        return this.renderStyle;
    }

    @Override
    public void setRenderStyle(RenderStyle renderStyle) {
        this.renderStyle = renderStyle;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public IChartObject createObject(IDataSeries source) {
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < 6) {
            return null;
        }
        GroupChartObject object = new GroupChartObject();
        int i = values.length - 6;
        while (i >= 0) {
            IOHLC[] outBars = new IOHLC[]{(IOHLC)values[i].getAdapter(IOHLC.class), (IOHLC)values[i + 1].getAdapter(IOHLC.class), (IOHLC)values[i + 2].getAdapter(IOHLC.class), (IOHLC)values[i + 3].getAdapter(IOHLC.class), (IOHLC)values[i + 4].getAdapter(IOHLC.class), (IOHLC)values[i + 5].getAdapter(IOHLC.class)};
            int sentiment = this.getSentiment(outBars);
            if (sentiment > 0) {
                object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), "Bullish"));
                i -= outBars.length;
            } else if (sentiment < 0) {
                object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), "Bearish"));
                i -= outBars.length;
            }
            --i;
        }
        return object;
    }

    int getSentiment(IOHLC[] recs) {
        boolean[] reversals = new boolean[6];
        int[] complete = new int[2];
        int n = 0;
        while (n < recs.length - 1) {
            IOHLC rn = recs[n];
            IOHLC rn1 = recs[n + 1];
            double[] high = new double[]{rn.getHigh(), rn1.getHigh()};
            double[] low = new double[]{rn.getLow(), rn1.getLow()};
            double[] dArray = new double[]{rn.getClose(), rn1.getClose()};
            double[] close = dArray;
            if (close[1] >= high[1] - 0.05 && close[0] <= low[0] + 0.05) {
                reversals[0] = true;
                if (n + 1 > complete[0]) {
                    complete[0] = n + 1;
                }
            } else if (close[0] >= high[0] - 0.05 && close[1] <= low[0] + 0.05) {
                reversals[3] = true;
                if (n + 1 > complete[1]) {
                    complete[1] = n + 1;
                }
            }
            if (low[1] < low[0] && close[1] > close[0]) {
                reversals[1] = true;
                if (n + 1 > complete[0]) {
                    complete[0] = n + 1;
                }
            } else if (high[1] >= high[0] && close[1] <= close[0]) {
                reversals[4] = true;
                if (n + 1 > complete[1]) {
                    complete[1] = n + 1;
                }
            }
            if (high[0] < high[1] && low[0] > low[1]) {
                if (close[1] >= high[0]) {
                    reversals[2] = true;
                    if (n + 1 > complete[0]) {
                        complete[0] = n + 1;
                    }
                }
            } else if (high[0] < high[1] && low[0] > low[1] && close[1] <= low[0]) {
                reversals[5] = true;
                if (n + 1 > complete[1]) {
                    complete[1] = n + 1;
                }
            }
            ++n;
        }
        if (reversals[0] && (reversals[1] || reversals[2]) || reversals[1] && (reversals[0] || reversals[2]) || reversals[2] && (reversals[0] || reversals[1])) {
            return 1;
        }
        if (reversals[3] && (reversals[4] || reversals[5]) || reversals[4] && (reversals[3] || reversals[5]) || reversals[5] && (reversals[3] || reversals[4])) {
            return -1;
        }
        return 0;
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("style", this.renderStyle.getName());
        if (this.color != null) {
            parameters.setParameter("color", this.color);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.renderStyle = parameters.hasParameter("style") ? RenderStyle.getStyleFromName((String)parameters.getString("style")) : RenderStyle.Line;
        this.color = parameters.getColor("color");
    }
}

