/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.indicators;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumericDataSeries;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.HistogramAreaChart;
import org.eclipsetrader.ui.charts.HistogramBarChart;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.LineChart;
import org.eclipsetrader.ui.charts.MAType;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.internal.charts.Util;
import org.eclipsetrader.ui.internal.charts.indicators.Activator;

public class STOCHRSI
implements IChartObjectFactory,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private OHLCField field = OHLCField.Close;
    private int kFastPeriod = 7;
    private int kSlowPeriod = 21;
    private int dPeriod = 14;
    private MAType dMaType = MAType.EMA;
    private RenderStyle kLineStyle = RenderStyle.Line;
    private RGB kLineColor;
    private RenderStyle dLineStyle = RenderStyle.Dot;
    private RGB dLineColor;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OHLCField getField() {
        return this.field;
    }

    public void setField(OHLCField field) {
        this.field = field;
    }

    public int getKFastPeriod() {
        return this.kFastPeriod;
    }

    public void setKFastPeriod(int fastPeriod) {
        this.kFastPeriod = fastPeriod;
    }

    public int getKSlowPeriod() {
        return this.kSlowPeriod;
    }

    public void setKSlowPeriod(int slowPeriod) {
        this.kSlowPeriod = slowPeriod;
    }

    public int getDPeriod() {
        return this.dPeriod;
    }

    public void setDPeriod(int period) {
        this.dPeriod = period;
    }

    public MAType getDMaType() {
        return this.dMaType;
    }

    public void setDMaType(MAType maType) {
        this.dMaType = maType;
    }

    public RenderStyle getKLineStyle() {
        return this.kLineStyle;
    }

    public void setKLineStyle(RenderStyle lineStyle) {
        this.kLineStyle = lineStyle;
    }

    public RGB getKLineColor() {
        return this.kLineColor;
    }

    public void setKLineColor(RGB lineColor) {
        this.kLineColor = lineColor;
    }

    public RenderStyle getDLineStyle() {
        return this.dLineStyle;
    }

    public void setDLineStyle(RenderStyle lineStyle) {
        this.dLineStyle = lineStyle;
    }

    public RGB getDLineColor() {
        return this.dLineColor;
    }

    public void setDLineColor(RGB lineColor) {
        this.dLineColor = lineColor;
    }

    public IChartObject createObject(IDataSeries source) {
        Core core;
        int lookback;
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < (lookback = (core = Activator.getDefault() != null ? Activator.getDefault().getCore() : new Core()).stochRsiLookback(this.kFastPeriod, this.kSlowPeriod, this.dPeriod, MAType.getTALib_MAType(this.dMaType)))) {
            return null;
        }
        int startIdx = 0;
        int endIdx = values.length - 1;
        double[] inReal = Util.getValuesForField(values, this.field);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] outK = new double[values.length - lookback];
        double[] outD = new double[values.length - lookback];
        core.stochRsi(startIdx, endIdx, inReal, this.kFastPeriod, this.kSlowPeriod, this.dPeriod, MAType.getTALib_MAType(this.dMaType), outBegIdx, outNbElement, outK, outD);
        GroupChartObject object = new GroupChartObject();
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("STOCHRSI-K", outK, source), this.kLineStyle, this.kLineColor));
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("STOCHRSI-D", outD, source), this.dLineStyle, this.dLineColor));
        return object;
    }

    protected IChartObject createLineChartObject(IDataSeries result, RenderStyle renderStyle, RGB color) {
        LineChart.LineStyle lineStyle = LineChart.LineStyle.Solid;
        switch (renderStyle) {
            case Dash: {
                lineStyle = LineChart.LineStyle.Dash;
                break;
            }
            case Dot: {
                lineStyle = LineChart.LineStyle.Dot;
                break;
            }
            case HistogramBars: {
                return new HistogramBarChart(result);
            }
            case Histogram: {
                return new HistogramAreaChart(result, color);
            }
            case Invisible: {
                lineStyle = LineChart.LineStyle.Invisible;
            }
        }
        return new LineChart(result, lineStyle, color);
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("k-fast-period", (Number)this.kFastPeriod);
        parameters.setParameter("k-slow-period", (Number)this.kSlowPeriod);
        parameters.setParameter("d-period", (Number)this.dPeriod);
        parameters.setParameter("d-ma-type", this.dMaType.getName());
        parameters.setParameter("k-style", this.kLineStyle.getName());
        if (this.kLineColor != null) {
            parameters.setParameter("k-color", this.kLineColor);
        }
        parameters.setParameter("d-style", this.dLineStyle.getName());
        if (this.dLineColor != null) {
            parameters.setParameter("d-color", this.dLineColor);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.kFastPeriod = parameters.getInteger("k-fast-period");
        this.kSlowPeriod = parameters.getInteger("k-slow-period");
        this.dPeriod = parameters.getInteger("d-period");
        this.dMaType = MAType.getFromName(parameters.getString("d-ma-type"));
        this.kLineStyle = parameters.hasParameter("k-style") ? RenderStyle.getStyleFromName((String)parameters.getString("k-style")) : RenderStyle.Line;
        this.kLineColor = parameters.getColor("k-color");
        this.dLineStyle = parameters.hasParameter("d-style") ? RenderStyle.getStyleFromName((String)parameters.getString("d-style")) : RenderStyle.Dot;
        this.dLineColor = parameters.getColor("d-color");
    }
}

