/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.indicators;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumericDataSeries;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.HistogramAreaChart;
import org.eclipsetrader.ui.charts.HistogramBarChart;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.LineChart;
import org.eclipsetrader.ui.charts.MAType;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.internal.charts.Util;
import org.eclipsetrader.ui.internal.charts.indicators.Activator;

public class MACD
implements IChartObjectFactory,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private OHLCField field = OHLCField.Close;
    private int fastPeriod = 7;
    private MAType fastMaType = MAType.EMA;
    private int slowPeriod = 21;
    private MAType slowMaType = MAType.EMA;
    private int signalPeriod = 14;
    private MAType signalMaType = MAType.EMA;
    private RenderStyle macdLineStyle = RenderStyle.Line;
    private RGB macdLineColor;
    private RenderStyle signalLineStyle = RenderStyle.Dot;
    private RGB signalLineColor;
    private RenderStyle histLineStyle = RenderStyle.Invisible;
    private RGB histLineColor;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OHLCField getField() {
        return this.field;
    }

    public void setField(OHLCField field) {
        this.field = field;
    }

    public int getFastPeriod() {
        return this.fastPeriod;
    }

    public void setFastPeriod(int fastPeriod) {
        this.fastPeriod = fastPeriod;
    }

    public int getSlowPeriod() {
        return this.slowPeriod;
    }

    public void setSlowPeriod(int slowPeriod) {
        this.slowPeriod = slowPeriod;
    }

    public int getSignalPeriod() {
        return this.signalPeriod;
    }

    public void setSignalPeriod(int signalPeriod) {
        this.signalPeriod = signalPeriod;
    }

    public MAType getFastMaType() {
        return this.fastMaType;
    }

    public void setFastMaType(MAType fastMaType) {
        this.fastMaType = fastMaType;
    }

    public MAType getSlowMaType() {
        return this.slowMaType;
    }

    public void setSlowMaType(MAType slowMaType) {
        this.slowMaType = slowMaType;
    }

    public MAType getSignalMaType() {
        return this.signalMaType;
    }

    public void setSignalMaType(MAType signalMaType) {
        this.signalMaType = signalMaType;
    }

    public RenderStyle getMacdLineStyle() {
        return this.macdLineStyle;
    }

    public void setMacdLineStyle(RenderStyle macdLineStyle) {
        this.macdLineStyle = macdLineStyle;
    }

    public RGB getMacdLineColor() {
        return this.macdLineColor;
    }

    public void setMacdLineColor(RGB macdLineColor) {
        this.macdLineColor = macdLineColor;
    }

    public RenderStyle getSignalLineStyle() {
        return this.signalLineStyle;
    }

    public void setSignalLineStyle(RenderStyle signalLineStyle) {
        this.signalLineStyle = signalLineStyle;
    }

    public RGB getSignalLineColor() {
        return this.signalLineColor;
    }

    public void setSignalLineColor(RGB signalLineColor) {
        this.signalLineColor = signalLineColor;
    }

    public RenderStyle getHistLineStyle() {
        return this.histLineStyle;
    }

    public void setHistLineStyle(RenderStyle histLineStyle) {
        this.histLineStyle = histLineStyle;
    }

    public RGB getHistLineColor() {
        return this.histLineColor;
    }

    public void setHistLineColor(RGB histLineColor) {
        this.histLineColor = histLineColor;
    }

    public IChartObject createObject(IDataSeries source) {
        Core core;
        int lookback;
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < (lookback = (core = Activator.getDefault() != null ? Activator.getDefault().getCore() : new Core()).macdExtLookback(this.fastPeriod, MAType.getTALib_MAType(this.fastMaType), this.slowPeriod, MAType.getTALib_MAType(this.slowMaType), this.signalPeriod, MAType.getTALib_MAType(this.signalMaType)))) {
            return null;
        }
        int startIdx = 0;
        int endIdx = values.length - 1;
        double[] inReal = Util.getValuesForField(values, this.field);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] outMACD = new double[values.length - lookback];
        double[] outSignal = new double[values.length - lookback];
        double[] outMACDHist = new double[values.length - lookback];
        core.macdExt(startIdx, endIdx, inReal, this.fastPeriod, MAType.getTALib_MAType(this.fastMaType), this.slowPeriod, MAType.getTALib_MAType(this.slowMaType), this.signalPeriod, MAType.getTALib_MAType(this.signalMaType), outBegIdx, outNbElement, outMACD, outSignal, outMACDHist);
        GroupChartObject object = new GroupChartObject();
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("MACD", outMACD, source), this.macdLineStyle, this.macdLineColor));
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("MACD-S", outSignal, source), this.signalLineStyle, this.signalLineColor));
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("MACD-H", outMACDHist, source), this.histLineStyle, this.histLineColor));
        return object;
    }

    protected IChartObject createLineChartObject(IDataSeries result, RenderStyle renderStyle, RGB color) {
        LineChart.LineStyle lineStyle = LineChart.LineStyle.Solid;
        switch (renderStyle) {
            case Dash: {
                lineStyle = LineChart.LineStyle.Dash;
                break;
            }
            case Dot: {
                lineStyle = LineChart.LineStyle.Dot;
                break;
            }
            case HistogramBars: {
                return new HistogramBarChart(result);
            }
            case Histogram: {
                return new HistogramAreaChart(result, color);
            }
            case Invisible: {
                lineStyle = LineChart.LineStyle.Invisible;
            }
        }
        return new LineChart(result, lineStyle, color);
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("field", this.field.getName());
        parameters.setParameter("fast-period", (Number)this.fastPeriod);
        parameters.setParameter("fast-ma-type", this.fastMaType.getName());
        parameters.setParameter("slow-period", (Number)this.slowPeriod);
        parameters.setParameter("slow-ma-type", this.slowMaType.getName());
        parameters.setParameter("signal-period", (Number)this.signalPeriod);
        parameters.setParameter("signal-ma-type", this.signalMaType.getName());
        parameters.setParameter("macd-style", this.macdLineStyle.getName());
        if (this.macdLineColor != null) {
            parameters.setParameter("macd-color", this.macdLineColor);
        }
        parameters.setParameter("signal-style", this.signalLineStyle.getName());
        if (this.signalLineColor != null) {
            parameters.setParameter("signal-color", this.signalLineColor);
        }
        parameters.setParameter("hist-style", this.histLineStyle.getName());
        if (this.histLineColor != null) {
            parameters.setParameter("hist-color", this.histLineColor);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.field = parameters.hasParameter("field") ? OHLCField.getFromName((String)parameters.getString("field")) : OHLCField.Close;
        this.fastPeriod = parameters.getInteger("fast-period");
        this.fastMaType = MAType.getFromName(parameters.getString("fast-ma-type"));
        this.slowPeriod = parameters.getInteger("slow-period");
        this.slowMaType = MAType.getFromName(parameters.getString("slow-ma-type"));
        this.signalPeriod = parameters.getInteger("signal-period");
        this.signalMaType = MAType.getFromName(parameters.getString("signal-ma-type"));
        this.macdLineStyle = parameters.hasParameter("macd-style") ? RenderStyle.getStyleFromName((String)parameters.getString("macd-style")) : RenderStyle.Line;
        this.macdLineColor = parameters.getColor("macd-color");
        this.signalLineStyle = parameters.hasParameter("signal-style") ? RenderStyle.getStyleFromName((String)parameters.getString("signal-style")) : RenderStyle.Dot;
        this.signalLineColor = parameters.getColor("signal-color");
        this.histLineStyle = parameters.hasParameter("hist-style") ? RenderStyle.getStyleFromName((String)parameters.getString("hist-style")) : RenderStyle.Invisible;
        this.histLineColor = parameters.getColor("hist-color");
    }
}

