/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.indicators;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumericDataSeries;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.HistogramAreaChart;
import org.eclipsetrader.ui.charts.HistogramBarChart;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.LineChart;
import org.eclipsetrader.ui.charts.MAType;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.internal.charts.Util;
import org.eclipsetrader.ui.internal.charts.indicators.Activator;

public class BBANDS
implements IChartObjectFactory,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private OHLCField field = OHLCField.Close;
    private int period = 21;
    private double upperDeviation = 2.0;
    private double lowerDeviation = 2.0;
    private MAType maType = MAType.EMA;
    private RenderStyle upperLineStyle = RenderStyle.Line;
    private RGB upperLineColor;
    private RenderStyle middleLineStyle = RenderStyle.Invisible;
    private RGB middleLineColor;
    private RenderStyle lowerLineStyle = RenderStyle.Line;
    private RGB lowerLineColor;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.factoryName = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OHLCField getField() {
        return this.field;
    }

    public void setField(OHLCField field) {
        this.field = field;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public double getUpperDeviation() {
        return this.upperDeviation;
    }

    public void setUpperDeviation(double upperDeviation) {
        this.upperDeviation = upperDeviation;
    }

    public double getLowerDeviation() {
        return this.lowerDeviation;
    }

    public void setLowerDeviation(double lowerDeviation) {
        this.lowerDeviation = lowerDeviation;
    }

    public MAType getMaType() {
        return this.maType;
    }

    public void setMaType(MAType maType) {
        this.maType = maType;
    }

    public RenderStyle getUpperLineStyle() {
        return this.upperLineStyle;
    }

    public void setUpperLineStyle(RenderStyle upperLineStyle) {
        this.upperLineStyle = upperLineStyle;
    }

    public RGB getUpperLineColor() {
        return this.upperLineColor;
    }

    public void setUpperLineColor(RGB upperLineColor) {
        this.upperLineColor = upperLineColor;
    }

    public RenderStyle getMiddleLineStyle() {
        return this.middleLineStyle;
    }

    public void setMiddleLineStyle(RenderStyle middleLineStyle) {
        this.middleLineStyle = middleLineStyle;
    }

    public RGB getMiddleLineColor() {
        return this.middleLineColor;
    }

    public void setMiddleLineColor(RGB middleLineColor) {
        this.middleLineColor = middleLineColor;
    }

    public RenderStyle getLowerLineStyle() {
        return this.lowerLineStyle;
    }

    public void setLowerLineStyle(RenderStyle lowerLineStyle) {
        this.lowerLineStyle = lowerLineStyle;
    }

    public RGB getLowerLineColor() {
        return this.lowerLineColor;
    }

    public void setLowerLineColor(RGB lowerLineColor) {
        this.lowerLineColor = lowerLineColor;
    }

    public IChartObject createObject(IDataSeries source) {
        Core core;
        int lookback;
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < (lookback = (core = Activator.getDefault() != null ? Activator.getDefault().getCore() : new Core()).bbandsLookback(this.period, this.upperDeviation, this.lowerDeviation, MAType.getTALib_MAType(this.maType)))) {
            return null;
        }
        int startIdx = 0;
        int endIdx = values.length - 1;
        double[] inReal = Util.getValuesForField(values, this.field);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] outUpper = new double[values.length - lookback];
        double[] outMiddle = new double[values.length - lookback];
        double[] outLower = new double[values.length - lookback];
        core.bbands(startIdx, endIdx, inReal, this.period, this.upperDeviation, this.lowerDeviation, MAType.getTALib_MAType(this.maType), outBegIdx, outNbElement, outUpper, outMiddle, outLower);
        GroupChartObject object = new GroupChartObject();
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("BBU", outUpper, source), this.upperLineStyle, this.upperLineColor));
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("BBM", outMiddle, source), this.middleLineStyle, this.middleLineColor));
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("BBL", outLower, source), this.lowerLineStyle, this.lowerLineColor));
        return object;
    }

    protected IChartObject createLineChartObject(IDataSeries result, RenderStyle renderStyle, RGB color) {
        LineChart.LineStyle lineStyle = LineChart.LineStyle.Solid;
        switch (renderStyle) {
            case Dash: {
                lineStyle = LineChart.LineStyle.Dash;
                break;
            }
            case Dot: {
                lineStyle = LineChart.LineStyle.Dot;
                break;
            }
            case HistogramBars: {
                return new HistogramBarChart(result);
            }
            case Histogram: {
                return new HistogramAreaChart(result, color);
            }
            case Invisible: {
                lineStyle = LineChart.LineStyle.Invisible;
            }
        }
        return new LineChart(result, lineStyle, color);
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("field", this.field.getName());
        parameters.setParameter("period", (Number)this.period);
        parameters.setParameter("upper-deviation", (Number)this.upperDeviation);
        parameters.setParameter("lower-deviation", (Number)this.lowerDeviation);
        parameters.setParameter("ma-type", this.maType.getName());
        parameters.setParameter("upper-line-style", this.upperLineStyle.getName());
        if (this.upperLineColor != null) {
            parameters.setParameter("upper-line-color", this.upperLineColor);
        }
        parameters.setParameter("middle-line-style", this.middleLineStyle.getName());
        if (this.middleLineColor != null) {
            parameters.setParameter("middle-line-color", this.middleLineColor);
        }
        parameters.setParameter("lower-line-style", this.lowerLineStyle.getName());
        if (this.lowerLineColor != null) {
            parameters.setParameter("lower-line-color", this.lowerLineColor);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.field = parameters.hasParameter("field") ? OHLCField.getFromName((String)parameters.getString("field")) : OHLCField.Close;
        this.period = parameters.getInteger("period");
        this.upperDeviation = parameters.hasParameter("upper-deviation") ? parameters.getDouble("upper-deviation") : 2.0;
        this.lowerDeviation = parameters.hasParameter("lower-deviation") ? parameters.getDouble("lower-deviation") : 2.0;
        this.maType = MAType.getFromName(parameters.getString("ma-type"));
        this.upperLineStyle = parameters.hasParameter("upper-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("upper-line-style")) : RenderStyle.Line;
        this.upperLineColor = parameters.getColor("upper-line-color");
        this.middleLineStyle = parameters.hasParameter("middle-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("middle-line-style")) : RenderStyle.Dot;
        this.middleLineColor = parameters.getColor("middle-line-color");
        this.lowerLineStyle = parameters.hasParameter("lower-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("lower-line-style")) : RenderStyle.Line;
        this.lowerLineColor = parameters.getColor("lower-line-color");
    }
}

