/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ProgramsRequest;
import pk.com.softech.messages.UserRemarksData;
import pk.com.softech.messages.UserRemarksRequest;
import pk.com.softech.messages.UserRemarksResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;

public class UserRemarks
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.UserRemarks";
    public static final String PREFS_USERS_REMARKS_COLUMNS_SIZE = "PREFS_USERS_REMARKS_COLUMNS_SIZE";
    public static final String PREFS_SORT_COLUMN = "USER_REMARKS_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "USER_REMARKS_SORT_DIRECTION";
    private static final int LABEL_WIDTH = 100;
    private static final int LABEL_HEIGHT = 15;
    private static final int TEXT_WIDTH = 100;
    private static final int TEXT_HEIGHT = 15;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 22;
    private static String[] COLUMN_NAMES = new String[]{"User Id", "Date", "User Comments"};
    public static final int USERID = 0;
    public static final int DATE = 1;
    public static final int USERCOMMENTS = 2;
    private Composite parent;
    Composite content;
    private ClientFilter filter;
    private ClientComparator comparator;
    int sortColumn = 0;
    int sortDirection = 1;
    Table table_acc = null;
    private TableViewer viewer;
    Font font_bold;
    Vector<String> trader;
    private String[] lstProgram = null;
    Text txtFromDate;
    Text txtToDate;
    Date tDate;
    Date fDate;
    Button btnFetchComments;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = UserRemarks.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (UserRemarks.this.sortColumn == index) {
                UserRemarks.this.sortDirection = UserRemarks.this.sortDirection == 0 ? 1 : 0;
            } else {
                UserRemarks.this.sortColumn = index;
                UserRemarks.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(UserRemarks.PREFS_SORT_COLUMN, UserRemarks.this.sortColumn);
            prefs.setValue(UserRemarks.PREFS_SORT_DIRECTION, UserRemarks.this.sortDirection);
            UserRemarks.this.viewer.getTable().setSortColumn(UserRemarks.this.viewer.getTable().getColumn(UserRemarks.this.sortColumn));
            UserRemarks.this.viewer.getTable().setSortDirection(UserRemarks.this.sortDirection == 0 ? 128 : 1024);
            UserRemarks.this.comparator.setColumn(UserRemarks.this.sortColumn);
            UserRemarks.this.viewer.refresh();
        }
    };
    private FontMetrics fontMetrics;

    public UserRemarks() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.content);
        Group grpFilter = new Group(this.content, 0);
        grpFilter.setText("Filter Comments");
        grpFilter.setFont(this.font_bold);
        grpFilter.setLayoutData((Object)new GridData(768));
        grpFilter.setLayout((Layout)new GridLayout(8, true));
        this.createLabel((Composite)grpFilter, "From Date");
        this.txtFromDate = this.createText((Composite)grpFilter, 16384);
        this.txtFromDate.setText(Utility.getCurrentDate());
        this.createLabel((Composite)grpFilter, "To Date");
        this.txtToDate = this.createText((Composite)grpFilter, 16384);
        this.txtToDate.setText(Utility.getCurrentDate());
        this.btnFetchComments = this.createButton((Composite)grpFilter, "Fetch");
        this.btnFetchComments.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserRemarks.this.requestFetchComments();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer(this.content);
        this.comparator = new ClientComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.comparator.setColumn(this.sortColumn);
        this.filter = new ClientFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new ResizeColumnsAction(this.table_acc));
    }

    public void requestFetchComments() {
        this.tDate = Utility.getDate((String)this.txtToDate.getText());
        this.fDate = Utility.getDate((String)this.txtFromDate.getText());
        if (this.fDate == null) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid From Date");
            return;
        }
        if (this.tDate == null) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid To Date");
            return;
        }
        this.requestProgramsList();
        this.showScreen();
        String traderCodes = Utility.getClientExchanges(this.trader);
        System.out.println("Trader Code " + traderCodes);
        try {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                UserRemarksRequest request = new UserRemarksRequest(traderCodes, this.fDate, this.tDate);
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
        }
    }

    public void recieveCommentsResponse(final UserRemarksResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList<UserRemarksData> list = new ArrayList<UserRemarksData>();
                    if (resp.getRows() != null) {
                        int i = 0;
                        while (i < resp.getRows().length) {
                            UserRemarksData temp = resp.getRows()[i];
                            list.add(new UserRemarksData(temp.getUserId().toUpperCase(), temp.getDate(), temp.getComments()));
                            ++i;
                        }
                        UserRemarks.this.viewer.setInput(list);
                    }
                }
            });
        }
    }

    private void createViewer(Composite content2) {
        this.viewer = new TableViewer(content2, 68354);
        this.createColumns(content2, this.viewer);
        this.table_acc = this.viewer.getTable();
        this.table_acc.setHeaderVisible(true);
        this.table_acc.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData lblTblGridData = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)lblTblGridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0);
        this.createTableViewerColumn(1);
        this.createTableViewerColumn(2);
        viewer.getTable().getColumn(0).setWidth(70);
        viewer.getTable().getColumn(1).setWidth(130);
        viewer.getTable().getColumn(2).setWidth(300);
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 16384);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(((UserRemarksData)cell.getElement()).getUserId());
                        break;
                    }
                    case 1: {
                        cell.setText(((UserRemarksData)cell.getElement()).getDate().toString());
                        break;
                    }
                    case 2: {
                        cell.setText(((UserRemarksData)cell.getElement()).getComments());
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                UserRemarksData sec = (UserRemarksData)element;
                return sec.getUserId();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(true);
        return temp;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    public void setFocus() {
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof UserRemarksResponse) {
                        UserRemarksResponse rsp = (UserRemarksResponse)o;
                        UserRemarks.this.recieveCommentsResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public void showScreen() {
        if (Resources.progResponse == null || Resources.progResponse.length == 0) {
            return;
        }
        try {
            this.lstProgram = new String[Resources.progResponse.length];
            String[] traderCodes = new String[Resources.progResponse.length];
            String traderProgram = "";
            int i = 0;
            while (i < Resources.progResponse.length) {
                int loggedInTrader;
                int traderCode;
                this.lstProgram[i] = Resources.progResponse[i].getProgramName();
                traderCodes[i] = Resources.progResponse[i].getTraderCode();
                if (Resources.userType == 3 && (traderCode = Integer.parseInt(traderCodes[i])) == (loggedInTrader = Integer.parseInt(Resources.traderId))) {
                    traderProgram = this.lstProgram[i];
                    break;
                }
                ++i;
            }
            this.trader = new Vector();
            if (Resources.userType == 3) {
                this.trader.addElement(this.getTraderCode(traderProgram));
            } else if (Resources.userType == 0) {
                i = 0;
                while (i < this.lstProgram.length) {
                    this.trader.addElement(this.getTraderCode(this.lstProgram[i]));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void requestProgramsList() {
        try {
            String traderCode = Resources.traderId;
            String userId = Resources.userId;
            if (Resources.userType == 0 || Resources.userType == 3) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new ProgramsRequest(traderCode, userId));
                }
            } else {
                MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Only Administrators or Traders are allowed this operation.");
            }
        }
        catch (Exception e) {
            System.out.println("requestUserListing():" + e);
            e.printStackTrace();
        }
    }

    private String getTraderCode(String program) {
        String traderCode = "";
        int i = 0;
        while (i < Resources.progResponse.length) {
            String program1 = Resources.progResponse[i].getProgramName();
            if (program1.equals(program)) {
                traderCode = Resources.progResponse[i].getTraderCode();
                break;
            }
            ++i;
        }
        return traderCode;
    }

    class ClientComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            UserRemarksData p1 = (UserRemarksData)e1;
            UserRemarksData p2 = (UserRemarksData)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getUserId().compareTo(p2.getUserId());
                    break;
                }
                case 1: {
                    rc = p1.getDate().compareTo(p2.getDate());
                    break;
                }
                case 2: {
                    rc = p1.getComments().compareTo(p2.getComments());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class ClientFilter
    extends ViewerFilter {
        private String userId;
        private String userComments;

        ClientFilter() {
        }

        public void setSearchText(String s1, String s2) {
            this.userId = ".*" + s1 + ".*";
            this.userComments = ".*" + s2 + ".*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.userId == null || this.userId.length() == 0) {
                return true;
            }
            if (this.userComments == null || this.userComments.length() == 0) {
                return true;
            }
            UserRemarksData p = (UserRemarksData)element;
            try {
                if (p.getUserId().matches(this.userId) && p.getComments().matches(this.userComments)) {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }
    }
}

