/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.UserChangeRequest;
import pk.com.softech.messages.UserChangeResponse;
import pk.com.softech.messages.UserListingData;
import pk.com.softech.messages.UserListingRequest;
import pk.com.softech.messages.UserListingResponse;
import pk.com.softech.tradingterminal.admin.Activator;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.InterestVerifyListener;
import pk.com.softech.util.Utility;

public class UserManagementView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.UserManagementView";
    public static final String PREFS_USERS_LISTING_VIEW_COLUMNS_SIZE = "PREFS_USERS_LISTING_VIEW_COLUMNS_SIZE";
    public static final String PREFS_SORT_COLUMN = "USER_LISTING_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "USER_LISTING_SORT_DIRECTION";
    private static final int LABEL_WIDTH = 100;
    private static final int LABEL_HEIGHT = 15;
    private static final int TEXT_WIDTH = 100;
    private static final int TEXT_HEIGHT = 15;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 22;
    private String[] userStatus = new String[]{"Active", "Blocked"};
    private static String[] COLUMN_NAMES = new String[]{"User Id", "User Name", "User Status", "Cash Deposite", "Add / Reduce Deposite", "Reduce Cash", "DC", "Cash Margin", "Custody Margin", "Forward Margin (Blocked Cash %)", "Interest Rate %"};
    public static final int USERID = 0;
    public static final int USERNAME = 1;
    public static final int USERSTATUS = 2;
    public static final int CASHDEPOSITE = 3;
    public static final int ADDREDUCEDEPOSITE = 4;
    public static final int REDUCECASH = 5;
    public static final int DC = 6;
    public static final int CASHMARGIN = 7;
    public static final int CUSTODYMARGIN = 8;
    public static final int FORWARDMARGINBLOCKEDCASH = 9;
    public static final int INTERESTRATE = 10;
    private Composite parent;
    Composite content;
    private ClientComparator comparator;
    private String userId;
    private String userName;
    private String password;
    private String userStatus1;
    private double cashDeposit;
    private double addReduceDeposit;
    boolean reduceCash;
    private String dc;
    private double cash;
    private double custody;
    private double forward;
    private double interestRate;
    private Hashtable<String, String> passwordStore = new Hashtable();
    UserListingData userData;
    Text txtTraderCode;
    Text txtUserId;
    Text txtUserName;
    Text txtPassword;
    Text txtCashDeposit;
    Text txtDc;
    Text txtAddReduceDeposit;
    Text txtCashMargin;
    Text txtCustodyMargin;
    Text txtForwardMargin;
    Text txtsearchUserId;
    Text txtsearchUserName;
    Text txtInterestRate;
    Button btnFetchUsers;
    Button btnUpdate;
    Button btnEditSelRow;
    Button cbxReduceCash;
    int sortColumn = 0;
    int sortDirection = 1;
    Combo cmbUserStatus;
    private ClientFilter filter;
    Table table_acc = null;
    private TableViewer viewer;
    Font font_bold;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    NumberFormat pf = CorePlugin.getPriceFormatter();
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < UserManagementView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(UserManagementView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            Activator.getDefault().getPreferenceStore().setValue(UserManagementView.PREFS_USERS_LISTING_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = UserManagementView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (UserManagementView.this.sortColumn == index) {
                UserManagementView.this.sortDirection = UserManagementView.this.sortDirection == 0 ? 1 : 0;
            } else {
                UserManagementView.this.sortColumn = index;
                UserManagementView.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(UserManagementView.PREFS_SORT_COLUMN, UserManagementView.this.sortColumn);
            prefs.setValue(UserManagementView.PREFS_SORT_DIRECTION, UserManagementView.this.sortDirection);
            UserManagementView.this.viewer.getTable().setSortColumn(UserManagementView.this.viewer.getTable().getColumn(UserManagementView.this.sortColumn));
            UserManagementView.this.viewer.getTable().setSortDirection(UserManagementView.this.sortDirection == 0 ? 128 : 1024);
            UserManagementView.this.comparator.setColumn(UserManagementView.this.sortColumn);
            UserManagementView.this.viewer.refresh();
        }
    };
    private FontMetrics fontMetrics;

    public UserManagementView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.content);
        Composite grp1 = new Composite(this.content, 0);
        grp1.setLayout((Layout)new GridLayout(3, true));
        grp1.setFont(this.font_bold);
        this.createLabel(grp1, "Trader Code");
        this.txtTraderCode = this.createText(grp1, 16384);
        this.txtTraderCode.setText(Resources.traderId);
        this.txtTraderCode.setEnabled(false);
        this.txtTraderCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        if (Resources.userType == 0) {
            this.txtTraderCode.setEnabled(true);
            this.txtTraderCode.setText("");
        } else {
            this.txtTraderCode.setText(Resources.traderId);
        }
        this.btnFetchUsers = this.createButton(grp1, "Fetch Users");
        this.btnFetchUsers.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserManagementView.this.requestUserListing();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group grpFilter = new Group(this.content, 0);
        grpFilter.setText("Filter User");
        grpFilter.setFont(this.font_bold);
        grpFilter.setLayoutData((Object)new GridData(768));
        grpFilter.setLayout((Layout)new GridLayout(4, true));
        this.createLabel((Composite)grpFilter, "User Id ");
        this.txtsearchUserId = this.createText((Composite)grpFilter, 16384);
        this.txtsearchUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtsearchUserId.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                UserManagementView.this.filter.setSearchText(UserManagementView.this.txtsearchUserId.getText(), UserManagementView.this.txtsearchUserName.getText());
                UserManagementView.this.viewer.refresh();
            }
        });
        this.createLabel((Composite)grpFilter, "User Name ");
        this.txtsearchUserName = this.createText((Composite)grpFilter, 16384);
        this.txtsearchUserName.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtsearchUserName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                UserManagementView.this.filter.setSearchText(UserManagementView.this.txtsearchUserId.getText(), UserManagementView.this.txtsearchUserName.getText());
                UserManagementView.this.viewer.refresh();
            }
        });
        Group grp2 = new Group(this.content, 0);
        grp2.setLayoutData((Object)new GridData(768));
        grp2.setLayout((Layout)new GridLayout(6, true));
        grp2.setText("Edit User");
        grp2.setFont(this.font_bold);
        this.createLabel((Composite)grp2, "User Id");
        this.txtUserId = this.createText((Composite)grp2, 16384);
        this.txtUserId.setEnabled(false);
        this.createLabel((Composite)grp2, "User Name");
        this.txtUserName = this.createText((Composite)grp2, 16384);
        this.txtUserName.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.createLabel((Composite)grp2, "Password");
        this.txtPassword = this.createText((Composite)grp2, 16384);
        this.txtPassword.setEchoChar('*');
        this.createLabel((Composite)grp2, "User Status");
        this.cmbUserStatus = this.createCombo((Composite)grp2, this.userStatus);
        this.cmbUserStatus.select(0);
        this.createLabel((Composite)grp2, "Cash Deposit");
        this.txtCashDeposit = this.createText((Composite)grp2, 131072);
        this.txtCashDeposit.setEnabled(false);
        this.createLabel((Composite)grp2, "DC");
        this.txtDc = this.createText((Composite)grp2, 16384);
        this.createLabel((Composite)grp2, "Reduce Cash");
        this.cbxReduceCash = this.createCheckBox((Composite)grp2);
        this.createLabel((Composite)grp2, "Add Reduce Deposit");
        this.txtAddReduceDeposit = this.createText((Composite)grp2, 131072);
        this.txtAddReduceDeposit.setEnabled(false);
        this.createLabel((Composite)grp2, "Cash Margin %");
        this.txtCashMargin = this.createText((Composite)grp2, 131072);
        this.txtCashMargin.setEnabled(false);
        Composite com = new Composite(this.content, 0);
        com.setLayoutData((Object)new GridData(768));
        com.setLayout((Layout)new GridLayout(8, true));
        this.createLabel(com, "Custody Margin %");
        this.txtCustodyMargin = this.createText(com, 131072);
        this.createLabel(com, "Forward Margin %");
        this.txtForwardMargin = this.createText(com, 131072);
        this.createLabel(com, "Interest Rate %");
        this.txtInterestRate = this.createText(com, 131072);
        this.txtInterestRate.addVerifyListener((VerifyListener)new InterestVerifyListener());
        this.btnUpdate = this.createButton(com, "Update");
        this.btnUpdate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserManagementView.this.setSelectedRow();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnEditSelRow = this.createButton(com, "Edit Selected Row");
        this.btnEditSelRow.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserManagementView.this.getSelectedRow();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer(this.content);
        this.comparator = new ClientComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.comparator.setColumn(this.sortColumn);
        this.filter = new ClientFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        if (Resources.loginStatus && Resources.refDataComplete) {
            this.requestUserListing();
        }
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new ResizeColumnsAction(this.table_acc));
    }

    private void createViewer(Composite content2) {
        this.viewer = new TableViewer(content2, 68354);
        this.createColumns(content2, this.viewer);
        this.table_acc = this.viewer.getTable();
        this.table_acc.setHeaderVisible(true);
        this.table_acc.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData lblTblGridData = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)lblTblGridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0);
        this.createTableViewerColumn(1);
        this.createTableViewerColumn(2);
        this.createTableViewerColumn(3);
        this.createTableViewerColumn(4);
        this.createTableViewerColumn(5);
        this.createTableViewerColumn(6);
        this.createTableViewerColumn(7);
        this.createTableViewerColumn(8);
        this.createTableViewerColumn(9);
        this.createTableViewerColumn(10);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_USERS_LISTING_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 131072);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(((UserListingData)cell.getElement()).getUserId());
                        break;
                    }
                    case 1: {
                        cell.setText(((UserListingData)cell.getElement()).getUserName());
                        break;
                    }
                    case 2: {
                        cell.setText(((UserListingData)cell.getElement()).getUserStatus());
                        break;
                    }
                    case 3: {
                        cell.setText(String.valueOf(((UserListingData)cell.getElement()).getCashDeposit()));
                        break;
                    }
                    case 4: {
                        cell.setText(String.valueOf(((UserListingData)cell.getElement()).getAddReduceDeposit()));
                        break;
                    }
                    case 5: {
                        cell.setText(String.valueOf(((UserListingData)cell.getElement()).getReduceCash()));
                        break;
                    }
                    case 6: {
                        cell.setText(((UserListingData)cell.getElement()).getDc());
                        break;
                    }
                    case 7: {
                        cell.setText(String.valueOf(((UserListingData)cell.getElement()).getCashMargin()));
                        break;
                    }
                    case 8: {
                        cell.setText(String.valueOf(((UserListingData)cell.getElement()).getCustodyMargin()));
                        break;
                    }
                    case 9: {
                        cell.setText(String.valueOf(((UserListingData)cell.getElement()).getForwardMargin()));
                        break;
                    }
                    case 10: {
                        cell.setText(String.valueOf(((UserListingData)cell.getElement()).getInterestRate()));
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                UserListingData sec = (UserListingData)element;
                return sec.getUserName();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(true);
        return temp;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    private Combo createCombo(Composite parent, String[] arrCombo) {
        Combo cmbUserType = new Combo(parent, 2048);
        int i = 0;
        while (i < arrCombo.length) {
            cmbUserType.add(arrCombo[i]);
            ++i;
        }
        cmbUserType.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        return cmbUserType;
    }

    private Button createCheckBox(Composite parent) {
        Button cbxBtn = new Button(parent, 32);
        return cbxBtn;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof UserListingResponse) {
                        UserListingResponse rsp = (UserListingResponse)o;
                        UserManagementView.this.recieveUserListingResponse(rsp);
                    } else if (o instanceof UserChangeResponse) {
                        UserChangeResponse r = (UserChangeResponse)o;
                        if (r.isDataInserted()) {
                            UserManagementView.this.updateTable(UserManagementView.this.userData);
                            UserManagementView.this.clearFields();
                            MessageDialog.openInformation(null, (String)"Details Updated", (String)"User details updated");
                        } else {
                            MessageDialog.openInformation(null, (String)"Details Not Updated", (String)("User details not updated. " + r.getErrorMessage()));
                        }
                    } else if (o instanceof LoginConfirmation) {
                        if (Resources.userType == 0) {
                            UserManagementView.this.txtTraderCode.setEnabled(true);
                            UserManagementView.this.txtTraderCode.setText("");
                        } else if (Resources.traderId != null) {
                            UserManagementView.this.txtTraderCode.setText(Resources.traderId);
                        }
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void recieveUserListingResponse(final UserListingResponse resp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ArrayList<UserListingData> list = new ArrayList<UserListingData>();
                if (resp.getRows() != null) {
                    int i = 0;
                    while (i < resp.getRows().length) {
                        UserListingData temp = resp.getRows()[i];
                        list.add(new UserListingData(temp.getUserId().toUpperCase(), temp.getUserName().toUpperCase(), temp.getPassword(), temp.getUserStatus().toUpperCase(), temp.getCashDeposit(), temp.getAddReduceDeposit(), temp.getReduceCash(), temp.getDc().toUpperCase(), temp.getCashMargin(), temp.getCustodyMargin(), temp.getForwardMargin(), temp.getInterestRate()));
                        UserManagementView.this.passwordStore.put(temp.getUserId().toUpperCase(), temp.getPassword().toUpperCase());
                        ++i;
                    }
                    UserManagementView.this.viewer.setInput(list);
                }
            }
        });
    }

    public void setFocus() {
    }

    public void requestUserListing() {
        try {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                String traderCode = "";
                String userType = "";
                boolean isAdmin = false;
                if (Resources.userType == 0) {
                    if (this.txtTraderCode.getText().trim().equals("")) {
                        traderCode = "%";
                        userType = "%";
                    } else {
                        traderCode = this.txtTraderCode.getText().trim();
                        userType = "CL";
                    }
                    isAdmin = true;
                } else {
                    traderCode = Resources.traderId;
                    userType = "CL";
                }
                UserListingRequest request = new UserListingRequest(Resources.clientId, traderCode, "", userType, isAdmin);
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
        }
    }

    private void getSelectedRow() {
        try {
            TableItem[] item = this.table_acc.getSelection();
            this.userId = item[0].getText(0);
            this.userName = item[0].getText(1);
            System.out.println("Password: " + this.passwordStore.get(this.userId));
            this.password = this.passwordStore.get(this.userId);
            this.userStatus1 = item[0].getText(2);
            this.cashDeposit = Utility.parseDouble((String)item[0].getText(3), (double)0.0);
            this.addReduceDeposit = Utility.parseDouble((String)item[0].getText(4), (double)0.0);
            String reduceCash0 = item[0].getText(5);
            this.reduceCash = reduceCash0.equals("Yes");
            this.dc = item[0].getText(6);
            this.cash = Utility.parseDouble((String)item[0].getText(7), (double)0.0);
            this.custody = Utility.parseDouble((String)item[0].getText(8), (double)0.0);
            this.forward = Utility.parseDouble((String)item[0].getText(9), (double)0.0);
            this.interestRate = Utility.parseDouble((String)item[0].getText(10), (double)0.0);
            this.txtUserId.setText(this.userId);
            this.txtUserName.setText(this.userName);
            this.txtPassword.setText(this.password);
            if (this.userStatus1.equals("ACT")) {
                this.cmbUserStatus.select(0);
            } else {
                this.cmbUserStatus.select(1);
            }
            this.txtCashDeposit.setText(this.pf.format(this.cashDeposit));
            this.txtDc.setText(this.dc);
            this.cbxReduceCash.setSelection(this.reduceCash);
            this.txtAddReduceDeposit.setText(this.pf.format(this.addReduceDeposit));
            this.txtCashMargin.setText(String.valueOf(this.cash));
            this.txtCustodyMargin.setText(String.valueOf(this.custody));
            this.txtForwardMargin.setText(String.valueOf(this.forward));
            this.txtInterestRate.setText(String.valueOf(this.interestRate));
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)"Invalid Selection", (String)("Select a row first." + e.getMessage()));
            e.printStackTrace();
            System.out.println("Exception" + e.getMessage());
        }
    }

    private void setSelectedRow() {
        try {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                String userId = this.txtUserId.getText();
                String userName = this.txtUserName.getText();
                String password = this.txtPassword.getText().trim();
                String userStatus = "";
                userStatus = this.cmbUserStatus.getSelectionIndex() == 0 ? "ACT" : "BLK";
                String cashDeposit = this.txtCashDeposit.getText();
                String dc = this.txtDc.getText();
                boolean reduceCash = this.cbxReduceCash.getSelection();
                String addReduceDeposit = this.txtAddReduceDeposit.getText();
                String cashMargin = this.txtCashMargin.getText();
                String custodyMargin = this.txtCustodyMargin.getText();
                String forwardMargin = this.txtForwardMargin.getText();
                String interestRate = this.txtInterestRate.getText();
                this.userData = new UserListingData(userId, userName, password, userStatus, Utility.parseDouble((String)cashDeposit, (double)0.0), Utility.parseDouble((String)addReduceDeposit, (double)0.0), reduceCash, dc, Utility.parseDouble((String)cashMargin, (double)0.0), Utility.parseDouble((String)custodyMargin, (double)0.0), Utility.parseDouble((String)forwardMargin, (double)0.0), Utility.parseDouble((String)interestRate, (double)0.0));
                String userChanged = "N";
                String cashChanged = "N";
                String marginChanged = "N";
                if (!userName.equals(this.userName)) {
                    userChanged = "Y";
                }
                if (!password.equals(this.password)) {
                    userChanged = "Y";
                }
                if (!userStatus.equals(this.userStatus1)) {
                    userChanged = "Y";
                }
                if (Double.parseDouble(addReduceDeposit) != this.addReduceDeposit) {
                    cashChanged = "Y";
                }
                if (reduceCash != this.reduceCash) {
                    cashChanged = "Y";
                }
                if (Double.parseDouble(cashMargin) != this.cash) {
                    marginChanged = "Y";
                }
                if (Double.parseDouble(custodyMargin) != this.custody) {
                    marginChanged = "Y";
                }
                if (Double.parseDouble(forwardMargin) != this.forward) {
                    marginChanged = "Y";
                }
                if (Double.parseDouble(interestRate) != this.interestRate) {
                    marginChanged = "Y";
                }
                String[] flags = new String[]{userChanged, cashChanged, marginChanged};
                String traderCode = Resources.traderId;
                UserChangeRequest request = new UserChangeRequest(this.userData, flags, traderCode, "", "CL");
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError(null, (String)"Invalid Parameters", (String)("Invalid Parameters Specified." + e.getMessage()));
        }
    }

    private void updateTable(UserListingData userData) {
        int index = this.table_acc.getSelectionIndex();
        TableItem item = this.table_acc.getItem(index);
        item.setText(0, userData.getUserId());
        item.setText(1, userData.getUserName());
        item.setText(2, userData.getUserStatus());
        item.setText(3, this.pf.format(userData.getCashDeposit()));
        item.setText(4, this.pf.format(userData.getAddReduceDeposit()));
        if (userData.getReduceCash()) {
            item.setText(5, "Yes");
        } else {
            item.setText(5, "No");
        }
        item.setText(6, userData.getDc());
        item.setText(7, String.valueOf(userData.getCashMargin()));
        item.setText(8, String.valueOf(userData.getCustodyMargin()));
        item.setText(9, String.valueOf(userData.getForwardMargin()));
        item.setText(10, String.valueOf(userData.getInterestRate()));
    }

    private void clearFields() {
        this.txtUserId.setText("");
        this.txtUserName.setText("");
        this.txtPassword.setText("");
        this.txtCashDeposit.setText("");
        this.txtDc.setText("");
        this.txtAddReduceDeposit.setText("");
        this.txtCashMargin.setText("");
        this.txtCustodyMargin.setText("");
        this.txtForwardMargin.setText("");
        this.txtInterestRate.setText("");
        this.cbxReduceCash.setSelection(false);
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    class ClientComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            UserListingData p1 = (UserListingData)e1;
            UserListingData p2 = (UserListingData)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getUserId().compareTo(p2.getUserId());
                    break;
                }
                case 1: {
                    rc = p1.getUserName().compareTo(p2.getUserName());
                    break;
                }
                case 2: {
                    rc = p1.getUserStatus().compareTo(p2.getUserStatus());
                    break;
                }
                case 3: {
                    rc = String.valueOf(p1.getCashDeposit()).compareTo(String.valueOf(p2.getCashDeposit()));
                    break;
                }
                case 4: {
                    rc = ("" + p1.getAddReduceDeposit()).compareTo(String.valueOf(p2.getAddReduceDeposit()));
                    break;
                }
                case 5: {
                    rc = ("" + p1.getReduceCash()).compareTo(String.valueOf(p2.getReduceCash()));
                    break;
                }
                case 6: {
                    rc = p1.getDc().compareTo(p2.getDc());
                    break;
                }
                case 7: {
                    rc = String.valueOf(p1.getCashMargin()).compareTo(String.valueOf(p2.getCashMargin()));
                    break;
                }
                case 8: {
                    rc = String.valueOf(p1.getCustodyMargin()).compareTo(String.valueOf(p2.getCustodyMargin()));
                    break;
                }
                case 9: {
                    rc = String.valueOf(p1.getForwardMargin()).compareTo(String.valueOf(p2.getForwardMargin()));
                    break;
                }
                case 10: {
                    rc = String.valueOf(p1.getInterestRate()).compareTo(String.valueOf(p2.getInterestRate()));
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class ClientFilter
    extends ViewerFilter {
        private String userId;
        private String userName;

        ClientFilter() {
        }

        public void setSearchText(String s1, String s2) {
            this.userId = ".*" + s1 + ".*";
            this.userName = ".*" + s2 + ".*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.userId == null || this.userId.length() == 0) {
                return true;
            }
            if (this.userName == null || this.userName.length() == 0) {
                return true;
            }
            UserListingData p = (UserListingData)element;
            try {
                if (p.getUserId().matches(this.userId) && p.getUserName().matches(this.userName)) {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }
    }
}

