/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ClientDlgInfo;
import pk.com.softech.messages.TextMessage;
import pk.com.softech.tradingterminal.admin.dialog.ClientSearchingViewDialog;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.link.TCPLink;

public class SMSMessageBroadcastView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.SMSMessageBroadcastView";
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final int VIEW_WIDTH = 650;
    private static final int VIEW_HIGHT = 300;
    Composite parent;
    private Group grpRecipients;
    private Group grpMessage;
    private List recipientsList;
    private Text message;
    Button btnSend;
    Composite content;

    public SMSMessageBroadcastView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        GridData txtGridDataFourCol = new GridData(4, 4, true, true, 4, 1);
        Composite composite = new Composite((Composite)sc, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(5, false));
        Composite cmpNumberAdd = new Composite(composite, 0);
        cmpNumberAdd.setLayout((Layout)new GridLayout(2, false));
        Button btnSearchRecipient = this.createButton(cmpNumberAdd);
        btnSearchRecipient.setText("Add Recipient");
        btnSearchRecipient.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    ClientSearchingViewDialog dlg = new ClientSearchingViewDialog(null, SMSMessageBroadcastView.VIEW_ID, 2);
                    dlg.open();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        this.grpRecipients = new Group(composite, 16);
        this.grpRecipients.setText("Recipients");
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)this.grpRecipients);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, 100).hint(90, -1).applyTo((Control)this.grpRecipients);
        this.recipientsList = new List((Composite)this.grpRecipients, 2562);
        GridDataFactory.fillDefaults().grab(false, true).minSize(160, 140).hint(160, -1).applyTo((Control)this.recipientsList);
        this.grpMessage = new Group(composite, 16);
        this.grpMessage.setLayoutData((Object)txtGridDataFourCol);
        this.grpMessage.setText("Message");
        GridLayoutFactory.swtDefaults().numColumns(4).equalWidth(true).applyTo((Composite)this.grpMessage);
        this.message = this.createText((Composite)this.grpMessage, 16448);
        this.message.setLayoutData((Object)txtGridDataFourCol);
        this.message.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SMSMessageBroadcastView.this.characterCounter();
            }
        });
        Composite cmpButton = new Composite(composite, 0);
        cmpButton.setLayout((Layout)new GridLayout(2, false));
        Button btnDelRecipient = this.createButton(cmpButton);
        btnDelRecipient.setText("Delete");
        btnDelRecipient.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SMSMessageBroadcastView.this.deleteSelectedRecipient();
                SMSMessageBroadcastView.this.grpRecipients.setText("Recipients (" + SMSMessageBroadcastView.this.recipientsList.getItemCount() + ")");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnDelAllRecipients = this.createButton(cmpButton);
        btnDelAllRecipients.setText("Delete All");
        btnDelAllRecipients.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SMSMessageBroadcastView.this.deleteAllRecipient();
                SMSMessageBroadcastView.this.grpRecipients.setText("Recipients (" + SMSMessageBroadcastView.this.recipientsList.getItemCount() + ")");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        Composite cmpbtnClearSend = new Composite(composite, 0);
        cmpbtnClearSend.setLayout((Layout)new GridLayout(2, true));
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 1).applyTo((Control)cmpbtnClearSend);
        Button btnClear = this.createButton(cmpbtnClearSend);
        btnClear.setText("Clear");
        GridDataFactory.fillDefaults().align(131072, 1).hint(100, -1).grab(false, false).applyTo((Control)btnClear);
        btnClear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SMSMessageBroadcastView.this.message.setText("");
                SMSMessageBroadcastView.this.characterCounter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnSend = this.createButton(cmpbtnClearSend);
        this.btnSend.setText("Send");
        GridDataFactory.fillDefaults().align(131072, 1).hint(100, -1).grab(false, false).applyTo((Control)this.btnSend);
        this.btnSend.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SMSMessageBroadcastView.this.sendMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (Resources.trnCode.contains("OD13") && (Resources.userType == 3 || Resources.userType == 0)) {
            this.btnSend.setEnabled(true);
        } else {
            this.btnSend.setEnabled(false);
        }
        sc.setContent((Control)composite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(650, 300);
    }

    protected void characterCounter() {
        this.grpMessage.setText("Message (Total Characters :" + this.message.getText().length() + ")");
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setEnabled(true);
        return temp;
    }

    private Button createButton(Composite parent) {
        Button temp = new Button(parent, 8);
        return temp;
    }

    private void sendMessage() {
        if (this.message.getText().length() > 0) {
            String[] no = this.recipientsList.getItems();
            if (no.length > 0) {
                System.out.println("Length " + no.length);
                boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"SMS Message Broadcast", (String)"This message will be sent to selected recipients, Are you sure to continue?");
                if (confirm) {
                    String[] clientCodes = new String[no.length];
                    int i = 0;
                    while (i < this.recipientsList.getItemCount()) {
                        clientCodes[i] = (String)this.recipientsList.getData(no[i]);
                        ++i;
                    }
                    String message0 = this.formateMessage(this.message.getText(), no, clientCodes);
                    try {
                        TextMessage txtMsg = new TextMessage(message0);
                        TCPLink serverLink = Resources.getServerLink((String)"", (boolean)false, (boolean)true);
                        serverLink.writeData((Object)txtMsg);
                    }
                    catch (Exception exc) {
                        System.err.println("Unable to send SMS Message " + exc.getStackTrace());
                    }
                    this.deleteAllRecipient();
                    this.grpRecipients.setText("Recipients (" + this.recipientsList.getItemCount() + ")");
                    this.clearFields();
                }
            } else {
                MessageDialog.openError(null, (String)"Invalid Information", (String)"Please select recipients");
            }
        } else {
            MessageDialog.openError(null, (String)"Invalid Information", (String)"Please enter message");
        }
    }

    public void addRecipients(ArrayList clientDlgInfo) {
        for (ClientDlgInfo value : clientDlgInfo) {
            if (value.getMobileNo() == null || value.getMobileNo().equals("") || this.contains(value.getMobileNo())) continue;
            this.recipientsList.add(value.getMobileNo());
            this.recipientsList.setData(value.getMobileNo(), (Object)value.getClientCode());
        }
        this.grpRecipients.setText("Recipients (" + this.recipientsList.getItemCount() + ")");
    }

    private boolean contains(String mobileNo) {
        boolean exists = false;
        String[] list = this.recipientsList.getItems();
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(mobileNo)) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    private void deleteSelectedRecipient() {
        String[] selRecipient = this.recipientsList.getSelection();
        int i = 0;
        while (i < selRecipient.length) {
            this.recipientsList.remove(selRecipient[i]);
            ++i;
        }
    }

    private void deleteAllRecipient() {
        this.recipientsList.removeAll();
    }

    private void clearFields() {
        this.message.setText("");
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof TextMessage) {
                        TextMessage cfr_ignored_0 = (TextMessage)o;
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public String formateMessage(String msg, String[] phoneNo, String[] clientCodes) {
        String SMSMessage = "SMSMESSAGE;";
        int i = 0;
        while (i < phoneNo.length) {
            SMSMessage = String.valueOf(SMSMessage) + phoneNo[i] + ":" + clientCodes[i];
            if (i != phoneNo.length - 1) {
                SMSMessage = String.valueOf(SMSMessage) + ",";
            }
            ++i;
        }
        SMSMessage = String.valueOf(SMSMessage) + ";";
        SMSMessage = String.valueOf(SMSMessage) + msg;
        this.logger.debug((Object)SMSMessage);
        return SMSMessage;
    }
}

