/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.SMSChatData;
import pk.com.softech.messages.SMSChatRequest;
import pk.com.softech.messages.SMSChatResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class SMSChatView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.SMSChat";
    public static final String PREFS_SMS_CHAT_COLUMNS_SIZE = "PREFS_SMS_CHAT_COLUMNS_SIZE";
    public static final String PREFS_SORT_COLUMN = "SMS_CHAT_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "SMS_CHAT_SORT_DIRECTION";
    private static String[] COLUMN_NAMES = new String[]{"Client Code", "Mobile No", "Date", "Status", "Message"};
    public static final int CLIENT_CODE = 0;
    public static final int PHONE_NO = 1;
    public static final int DATE = 2;
    public static final int MESSAGE = 4;
    public static final int STATUS = 3;
    private static final int LABEL_WIDTH = 75;
    private static final int LABEL_HEIGHT = 19;
    private static final int BUTTON_WIDTH = 75;
    private static final int BUTTON_HEIGHT = 22;
    private static final int TEXT_WIDTH = 75;
    private static final int TEXT_HEIGHT = 15;
    private Composite parent;
    Composite content;
    private SecurityFilter filter;
    private ClientComparator comparator;
    int sortColumn = 2;
    int sortDirection = 1;
    Table table_acc = null;
    private TableViewer viewer;
    Font font_bold;
    private Text txtClientCode;
    private Text txtMobileNo;
    private SecurityFilter sfilter;
    public static SMSThread thread = null;
    public static boolean running = false;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private FontMetrics fontMetrics;
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = SMSChatView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (SMSChatView.this.sortColumn == index) {
                SMSChatView.this.sortDirection = SMSChatView.this.sortDirection == 0 ? 1 : 0;
            } else {
                SMSChatView.this.sortColumn = index;
                SMSChatView.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(SMSChatView.PREFS_SORT_COLUMN, SMSChatView.this.sortColumn);
            prefs.setValue(SMSChatView.PREFS_SORT_DIRECTION, SMSChatView.this.sortDirection);
            SMSChatView.this.viewer.getTable().setSortColumn(SMSChatView.this.viewer.getTable().getColumn(SMSChatView.this.sortColumn));
            SMSChatView.this.viewer.getTable().setSortDirection(SMSChatView.this.sortDirection == 0 ? 128 : 1024);
            SMSChatView.this.comparator.setColumn(SMSChatView.this.sortColumn);
            SMSChatView.this.viewer.refresh();
        }
    };

    public SMSChatView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(7, true));
        this.createLabel(composite, "Client Code");
        this.txtClientCode = this.createText(composite, 16384);
        this.txtClientCode.setEnabled(true);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SMSChatView.this.filter.setSearchText(SMSChatView.this.txtClientCode.getText(), SMSChatView.this.txtMobileNo.getText());
                SMSChatView.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Mobile No");
        this.txtMobileNo = this.createText(composite, 16384);
        this.txtMobileNo.setEnabled(true);
        this.txtMobileNo.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtMobileNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SMSChatView.this.filter.setSearchText(SMSChatView.this.txtClientCode.getText(), SMSChatView.this.txtMobileNo.getText());
                SMSChatView.this.viewer.refresh();
            }
        });
        Button btnRefresh = new Button(composite, 0x1000000);
        btnRefresh.setText("Refresh");
        btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SMSChatView.this.clearFields();
                SMSChatView.this.requestRecievedMessages();
                SMSChatView.this.filter.setSearchText(SMSChatView.this.txtClientCode.getText(), SMSChatView.this.txtMobileNo.getText());
                SMSChatView.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer(this.content);
        this.comparator = new ClientComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.comparator.setColumn(this.sortColumn);
        this.filter = new SecurityFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new ResizeColumnsAction(this.table_acc));
        this.getSite().getPage().addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPartName().equals("SMS Chat") && thread != null) {
                    running = false;
                    thread.interrupt();
                    thread = null;
                    SMSChatView.this.logger.info((Object)"SMS Thread successfully stopped.");
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getPartName().equals("SMS Chat") && thread != null) {
                    running = false;
                    thread.interrupt();
                    thread = null;
                    SMSChatView.this.logger.info((Object)"SMS Thread successfully stopped.");
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPartName().equals("SMS Chat") && thread == null) {
                    SMSChatView.this.logger.info((Object)"SMS Chat Activated");
                    running = true;
                    thread = new SMSThread();
                    thread.start();
                }
            }
        });
    }

    private void clearFields() {
        this.txtClientCode.setText("");
        this.txtMobileNo.setText("");
    }

    private void createViewer(Composite content2) {
        this.viewer = new TableViewer(content2, 68354);
        this.createColumns(content2, this.viewer);
        this.table_acc = this.viewer.getTable();
        this.table_acc.setHeaderVisible(true);
        this.table_acc.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData lblTblGridData = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)lblTblGridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0);
        this.createTableViewerColumn(1);
        this.createTableViewerColumn(2);
        this.createTableViewerColumn(3);
        this.createTableViewerColumn(4);
        viewer.getTable().getColumn(0).setWidth(100);
        viewer.getTable().getColumn(1).setWidth(130);
        viewer.getTable().getColumn(2).setWidth(130);
        viewer.getTable().getColumn(3).setWidth(100);
        viewer.getTable().getColumn(4).setWidth(230);
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 16384);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(((SMSChatData)cell.getElement()).getClientCode());
                        break;
                    }
                    case 1: {
                        cell.setText(((SMSChatData)cell.getElement()).getPhoneNo());
                        break;
                    }
                    case 2: {
                        Date dd = ((SMSChatData)cell.getElement()).getDate();
                        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss a");
                        String date = format.format(dd);
                        cell.setText(date);
                        break;
                    }
                    case 4: {
                        cell.setText(((SMSChatData)cell.getElement()).getMessage());
                        break;
                    }
                    case 3: {
                        String status = ((SMSChatData)cell.getElement()).getStatus();
                        if (status.equals("R")) {
                            cell.setText("Recieved");
                            break;
                        }
                        cell.setText("Sent");
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                SMSChatData sec = (SMSChatData)element;
                return sec.getClientCode();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 2176);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(false);
        return temp;
    }

    public void setFocus() {
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof SMSChatResponse) {
                        SMSChatResponse rsp = (SMSChatResponse)o;
                        SMSChatView.this.recieveMessageResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public void requestRecievedMessages() {
        Date currentDate = new Date();
        System.out.println(currentDate.toString());
        try {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                SMSChatRequest request = new SMSChatRequest(currentDate);
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
        }
    }

    public void recieveMessageResponse(final SMSChatResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ArrayList<SMSChatData> list = new ArrayList<SMSChatData>();
                    if (resp.getRows() != null) {
                        int i = 0;
                        while (i < resp.getRows().length) {
                            SMSChatData temp = resp.getRows()[i];
                            list.add(new SMSChatData(temp.getClientCode().toUpperCase(), temp.getPhoneNo(), temp.getDate(), temp.getMessage(), temp.getStatus()));
                            ++i;
                        }
                        SMSChatView.this.viewer.setInput(list);
                        SMSChatView.this.viewer.refresh();
                    }
                }
            });
        }
    }

    class ClientComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            SMSChatData p1 = (SMSChatData)e1;
            SMSChatData p2 = (SMSChatData)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getClientCode().compareTo(p2.getClientCode());
                    break;
                }
                case 1: {
                    rc = p1.getPhoneNo().compareTo(p2.getPhoneNo());
                    break;
                }
                case 2: {
                    rc = p1.getDate().compareTo(p2.getDate());
                    break;
                }
                case 4: {
                    rc = p1.getMessage().compareTo(p2.getMessage());
                    break;
                }
                case 3: {
                    rc = p1.getStatus().compareTo(p2.getStatus());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class SMSThread
    extends Thread {
        private SMSThread() {
        }

        @Override
        public void run() {
            while (running) {
                try {
                    SMSChatView.this.logger.info((Object)"SMS Thread Called");
                    SMSChatView.this.requestRecievedMessages();
                    SMSChatView.this.logger.info((Object)"********Interval Start ***********");
                    Thread.sleep(60000L);
                    SMSChatView.this.logger.info((Object)"********Interval Stop ***********");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    running = false;
                }
            }
        }
    }

    class SecurityFilter
    extends ViewerFilter {
        private String clientCode;
        private String mobileNo;

        SecurityFilter() {
        }

        public void setSearchText(String s1, String s2) {
            this.clientCode = ".*" + s1 + ".*";
            this.mobileNo = ".*" + s2 + ".*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.clientCode == null || this.clientCode.length() == 0) {
                return true;
            }
            if (this.mobileNo == null || this.mobileNo.length() == 0) {
                return true;
            }
            SMSChatData p = (SMSChatData)element;
            if (p.clientCode == null) {
                p.clientCode = "";
            }
            if (p.phoneNo == null) {
                p.phoneNo = "";
            }
            return p.getClientCode().matches(this.clientCode) && p.getPhoneNo().matches(this.mobileNo);
        }
    }
}

