/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.RiskWatchData;
import pk.com.softech.messages.RiskWatchRequest;
import pk.com.softech.messages.RiskWatchResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class RiskWatchView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.RiskWatchView";
    public static final String PREFS_RISK_WATCH_VIEW_COLUMNS_SIZE = "PREFS_RISK_WATCH_VIEW_COLUMNS_SIZE";
    private static final int REFRESH_DELAY = 180000;
    RefreshThread thread;
    private static final int CLIENT = 0;
    private static final int EXCHANGE = 1;
    private static final int EXPOSURE_UTILIZED = 2;
    private static final int ALLOWED_MARGIN = 3;
    private static final int REQUIRED_MARGIN = 4;
    private static final int FREE_CASH = 5;
    private static final int MARGIN_PERC = 6;
    private static final int FREE_MARGIN = 7;
    private static final String[] COLUMN_NAMES = new String[]{"Client", "Exchange", "Exposure Utilized", "Allow Margin", "Required Margin", "Free Cash", "Margin %", "Free Margin"};
    private Composite parent;
    Composite content;
    Label lblClientCode;
    Text txtClientCode;
    Button btnRefresh;
    Label lblRefreshTime;
    TableViewer viewer;
    int sortColumn = 6;
    int sortDirection = 0;
    private DataComparator comparator;
    private DataFilter filter;
    Set<RiskWatchData> s = new HashSet<RiskWatchData>();
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    private DateFormat tf = CorePlugin.getTimeFormat();
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < RiskWatchView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(RiskWatchView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(RiskWatchView.PREFS_RISK_WATCH_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = RiskWatchView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (RiskWatchView.this.sortColumn == index) {
                RiskWatchView.this.sortDirection = RiskWatchView.this.sortDirection == 0 ? 1 : 0;
            } else {
                RiskWatchView.this.sortColumn = index;
                RiskWatchView.this.sortDirection = 0;
            }
            RiskWatchView.this.viewer.getTable().setSortColumn(RiskWatchView.this.viewer.getTable().getColumn(RiskWatchView.this.sortColumn));
            RiskWatchView.this.viewer.getTable().setSortDirection(RiskWatchView.this.sortDirection == 0 ? 128 : 1024);
            RiskWatchView.this.comparator.setColumn(RiskWatchView.this.sortColumn);
            RiskWatchView.this.viewer.refresh();
        }
    };

    public RiskWatchView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.lblClientCode = new Label(composite, 0);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                RiskWatchView.this.filter.setSearchText(RiskWatchView.this.txtClientCode.getText());
                RiskWatchView.this.viewer.refresh();
            }
        });
        this.btnRefresh = new Button(composite, 0);
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    RiskWatchView.this.sendRequest();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblRefreshTime = new Label(composite, 0);
        this.lblRefreshTime.setText("Last Refresh = 00:00:00 ");
        this.createViewer(composite);
        this.comparator = new DataComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DataLabelProvider());
        this.comparator.setColumn(this.sortColumn);
        this.filter = new DataFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new ResizeColumnsAction(this.viewer.getTable()));
        if (Resources.tcpLink && Resources.refDataComplete) {
            this.startRefreshThread();
        }
    }

    private void startRefreshThread() {
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0, 16384);
        this.createTableViewerColumn(1, 16384);
        this.createTableViewerColumn(2, 131072);
        this.createTableViewerColumn(3, 131072);
        this.createTableViewerColumn(4, 131072);
        this.createTableViewerColumn(5, 131072);
        this.createTableViewerColumn(6, 131072);
        this.createTableViewerColumn(7, 131072);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_RISK_WATCH_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(int colNumber, int alignment) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setAlignment(alignment);
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        return viewerColumn;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof RiskWatchResponse) {
                        RiskWatchResponse rsp = (RiskWatchResponse)o;
                        RiskWatchView.this.recieveResponse(rsp);
                    } else if (o instanceof LoginConfirmation && Resources.refDataComplete) {
                        RiskWatchView.this.startRefreshThread();
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void sendRequest() {
        if (Resources.getServerLink((String)"", (boolean)false, (boolean)true) != null && Resources.sendToAllMS((Message)new RiskWatchRequest())) {
            this.viewer.getTable().removeAll();
            this.s.clear();
            this.lblRefreshTime.setText("Last Refresh = " + this.tf.format(new Date()));
            this.btnRefresh.setEnabled(false);
        }
    }

    public void recieveResponse(final RiskWatchResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        RiskWatchView.this.s.addAll(Arrays.asList(resp.getrows()));
                        RiskWatchView.this.viewer.setInput(Arrays.asList(RiskWatchView.this.s.toArray()));
                        RiskWatchView.this.btnRefresh.setEnabled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        RiskWatchView.this.logger.error((Object)"", (Throwable)e);
                    }
                }
            });
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
        catch (Exception exception) {}
        super.dispose();
    }

    class DataComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int direction = 0;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            RiskWatchData p1 = (RiskWatchData)e1;
            RiskWatchData p2 = (RiskWatchData)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getClientCode().compareTo(p2.getClientCode());
                    break;
                }
                case 1: {
                    rc = p1.getExchange().compareTo(p2.getExchange());
                    break;
                }
                case 2: {
                    rc = Double.valueOf(p1.getExposureUtilized()).compareTo(p2.getExposureUtilized());
                    break;
                }
                case 3: {
                    rc = Double.valueOf(p1.getAllowedMargin()).compareTo(p2.getAllowedMargin());
                    break;
                }
                case 4: {
                    rc = Double.valueOf(p1.getReqMargin()).compareTo(p2.getReqMargin());
                    break;
                }
                case 5: {
                    rc = Double.valueOf(p1.getFreeCash()).compareTo(p2.getFreeCash());
                    break;
                }
                case 6: {
                    rc = Double.valueOf(p1.getMarginPerc()).compareTo(p2.getMarginPerc());
                    break;
                }
                case 7: {
                    rc = Double.valueOf(p1.getFreeMargin()).compareTo(p2.getFreeMargin());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class DataFilter
    extends ViewerFilter {
        private String client = "";

        DataFilter() {
        }

        public void setSearchText(String s1) {
            this.client = ".*" + s1 + ".*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.client == null || this.client.length() == 0) {
                return true;
            }
            RiskWatchData p = (RiskWatchData)element;
            try {
                if (p.getClientCode().matches(this.client)) {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }
    }

    class DataLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        DataLabelProvider() {
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            RiskWatchData data = (RiskWatchData)element;
            if (data.getFreeCash() < 0.0 || data.getFreeMargin() < 0.0) {
                return WidgetFactory.color_registry.get("COLOR_RED_LIGHT");
            }
            if (data.getMarginPerc() < 25.0) {
                return WidgetFactory.color_registry.get("COLOR_RED_LIGHT");
            }
            if (data.getMarginPerc() < 50.0) {
                return WidgetFactory.color_registry.get("COLOR_YELLO");
            }
            return WidgetFactory.color_registry.get("COLOR_GREEN_LIGHT");
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int colNumber) {
            RiskWatchData data = (RiskWatchData)element;
            switch (colNumber) {
                case 0: {
                    return data.getClientCode();
                }
                case 1: {
                    return data.getExchange();
                }
                case 2: {
                    return RiskWatchView.this.pf.format(data.getExposureUtilized());
                }
                case 3: {
                    return RiskWatchView.this.pf.format(data.getAllowedMargin());
                }
                case 4: {
                    return RiskWatchView.this.pf.format(data.getReqMargin());
                }
                case 5: {
                    return RiskWatchView.this.pf.format(data.getFreeCash());
                }
                case 6: {
                    return RiskWatchView.this.pf.format(data.getMarginPerc());
                }
                case 7: {
                    return RiskWatchView.this.pf.format(data.getFreeMargin());
                }
            }
            return "";
        }
    }

    private class RefreshThread
    extends Thread {
        private RefreshThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (RiskWatchView.this.parent != null && !RiskWatchView.this.parent.isDisposed()) {
                    RiskWatchView.this.parent.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            RiskWatchView.this.sendRequest();
                        }
                    });
                }
                try {
                    Thread.sleep(180000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

