/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.TextMessage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;

public class MessageBroadcastView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.MessageBroadcastView";
    Composite parent;
    private Group grpRecipients;
    private Group grpMessage;
    private List recipientsList;
    private Text message;
    private Button cbxPopup;
    private Button btnAddRecipient;
    Composite content;
    private String[] userTypes = new String[]{"ALL", "ADMIN", "CLIENT", "SUBSCRIBER", "TRADER", "MEMBER", "SUPPORT"};
    private Combo jcbUserType;

    public MessageBroadcastView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridData txtGridDataFourCol = new GridData(4, 4, true, true, 4, 1);
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(5, true));
        this.btnAddRecipient = this.createButton(composite);
        this.btnAddRecipient.setText("Add Recipient");
        this.btnAddRecipient.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.admin.views.ConnectedUsersView");
                }
                catch (PartInitException exc) {
                    exc.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createLabel(composite, "User Type: ");
        this.jcbUserType = this.createCombo(composite, this.userTypes);
        this.jcbUserType.select(0);
        this.createLabel(composite, "Popup: ");
        this.cbxPopup = this.createCheckBox(composite);
        this.grpRecipients = new Group(composite, 16);
        this.grpRecipients.setText("Recipients");
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)this.grpRecipients);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, 100).hint(75, -1).applyTo((Control)this.grpRecipients);
        this.recipientsList = new List((Composite)this.grpRecipients, 2562);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, 115).hint(90, -1).applyTo((Control)this.recipientsList);
        this.grpMessage = new Group(composite, 16);
        this.grpMessage.setLayoutData((Object)txtGridDataFourCol);
        this.grpMessage.setText("Message");
        GridLayoutFactory.swtDefaults().numColumns(4).equalWidth(true).applyTo((Composite)this.grpMessage);
        this.message = this.createText((Composite)this.grpMessage, 16448);
        this.message.setLayoutData((Object)txtGridDataFourCol);
        Button btnDelRecipient = this.createButton(composite);
        btnDelRecipient.setText("Delete");
        btnDelRecipient.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MessageBroadcastView.this.deleteSelectedRecipient();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createLabel(composite, "");
        this.createLabel(composite, "");
        Button btnClear = this.createButton(composite);
        btnClear.setText("Clear");
        btnClear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MessageBroadcastView.this.message.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnSend = this.createButton(composite);
        btnSend.setText("Send");
        btnSend.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MessageBroadcastView.this.sendMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (Resources.userType == 3 || Resources.userType == 0) {
            btnSend.setEnabled(true);
        } else {
            btnSend.setEnabled(false);
        }
        Button btnDelAllRecipients = this.createButton(composite);
        btnDelAllRecipients.setText("Delete All");
        btnDelAllRecipients.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MessageBroadcastView.this.deleteAllRecipient();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setEnabled(true);
        return temp;
    }

    private Combo createCombo(Composite parent, String[] arrCombo) {
        Combo cmbUserType = new Combo(parent, 2056);
        int i = 0;
        while (i < arrCombo.length) {
            cmbUserType.add(arrCombo[i]);
            ++i;
        }
        return cmbUserType;
    }

    private Button createCheckBox(Composite parent) {
        Button temp = new Button(parent, 32);
        return temp;
    }

    private Button createButton(Composite parent) {
        Button temp = new Button(parent, 8);
        return temp;
    }

    private void sendMessage() {
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            if (this.message.getText().length() > 0) {
                boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Message Broadcast", (String)"This Message Will Be Sent To All (Or Selected) Connected Users Are U Sure U Want To Continue");
                if (confirm) {
                    String[] recipients = this.recipientsList.getItems();
                    TextMessage textmessage = null;
                    textmessage = recipients.length > 0 ? new TextMessage(this.message.getText(), this.cbxPopup.getSelection(), recipients, this.jcbUserType.getText()) : new TextMessage(this.message.getText(), this.cbxPopup.getSelection(), null, this.jcbUserType.getText());
                    Resources.sendToAllMS((Message)textmessage);
                    this.clearFields();
                }
            } else {
                MessageDialog.openError(null, (String)"Invalid parameters", (String)"Please enter message");
            }
        }
    }

    public void addRecipients(ArrayList UserId) {
        for (String value : UserId) {
            if (value == null || value.equals("") || this.contains(value)) continue;
            this.recipientsList.add(value);
        }
    }

    private boolean contains(String clientCode) {
        boolean exists = false;
        String[] list = this.recipientsList.getItems();
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(clientCode)) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    private void deleteSelectedRecipient() {
        String[] selRecipient = this.recipientsList.getSelection();
        int i = 0;
        while (i < selRecipient.length) {
            this.recipientsList.remove(selRecipient[i]);
            ++i;
        }
    }

    private void deleteAllRecipient() {
        this.recipientsList.removeAll();
    }

    private void clearFields() {
        this.message.setText("");
        this.cbxPopup.setSelection(false);
        this.jcbUserType.select(0);
        this.recipientsList.removeAll();
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof TextMessage) {
                        TextMessage cfr_ignored_0 = (TextMessage)o;
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }
}

