/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ConnectedUsersData;
import pk.com.softech.messages.ConnectedUsersRequest;
import pk.com.softech.messages.ConnectedUsersResponse;
import pk.com.softech.messages.DisconnectUser;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.Message;
import pk.com.softech.tradingterminal.admin.Activator;
import pk.com.softech.tradingterminal.admin.views.MessageBroadcastView;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class ConnectedUsersView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.ConnectedUsersView";
    public static final String PREFS_CONNECTED_USERS_VIEW_COLUMNS_SIZE = "PREFS_CONNECTED_USERS_VIEW_COLUMNS_SIZE";
    private static final int USER_TYPE = 0;
    private static final int USER_ID = 1;
    private static final int CLIENT = 2;
    private static final int TRADER = 3;
    private static final int APP_TYPE = 4;
    private static final int TERMINAL_IP = 5;
    private static final int TERMINAL_NAME = 6;
    private static final int TERMINAL_VERSION = 7;
    private static final int SERVER_NAME = 8;
    private static final String[] COLUMN_NAMES = new String[]{"User Type", "User Id", "Client", "Trader", "App Type", "Terminal IP", "Terminal Name", "Terminal Version", "Server Name"};
    private Composite parent;
    Composite content;
    Text txtDate = null;
    Text txtUserId = null;
    Text txtClientCode = null;
    Button btnRefresh = null;
    private Combo cmbUserType = null;
    private Combo cmbAppType = null;
    private List<ConnectedUsersData> userList = new ArrayList<ConnectedUsersData>();
    Label lblAdminValue = null;
    Label lblClientValue = null;
    Label lblSubscriberValue = null;
    Label lblTraderValue = null;
    Label lblMemberValue = null;
    Label lblSupportValue = null;
    Label lblTotalTerminals = null;
    Label lblTerminalValue = null;
    Label lblEclipseValue = null;
    Label lblMobileValue = null;
    Label lblOthersValue = null;
    TableViewer viewer;
    int sortColumn = 1;
    int sortDirection = 0;
    private DataComparator comparator;
    private DataFilter filter;
    Action sendMessageAction;
    Action disconnectUserAction;
    Action refreshAction;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ConnectedUsersView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ConnectedUsersView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            Activator.getDefault().getPreferenceStore().setValue(ConnectedUsersView.PREFS_CONNECTED_USERS_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = ConnectedUsersView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (ConnectedUsersView.this.sortColumn == index) {
                ConnectedUsersView.this.sortDirection = ConnectedUsersView.this.sortDirection == 0 ? 1 : 0;
            } else {
                ConnectedUsersView.this.sortColumn = index;
                ConnectedUsersView.this.sortDirection = 0;
            }
            ConnectedUsersView.this.viewer.getTable().setSortColumn(ConnectedUsersView.this.viewer.getTable().getColumn(ConnectedUsersView.this.sortColumn));
            ConnectedUsersView.this.viewer.getTable().setSortDirection(ConnectedUsersView.this.sortDirection == 0 ? 128 : 1024);
            ConnectedUsersView.this.comparator.setColumn(ConnectedUsersView.this.sortColumn);
            ConnectedUsersView.this.viewer.refresh();
        }
    };

    public ConnectedUsersView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void init(IViewSite site) throws PartInitException {
        this.sendMessageAction = new Action(){

            public void run() {
                TableItem[] item = ConnectedUsersView.this.viewer.getTable().getSelection();
                ArrayList<String> clients = new ArrayList<String>();
                int i = 0;
                while (i < item.length) {
                    clients.add(item[i].getText(1));
                    ++i;
                }
                try {
                    IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.admin.views.MessageBroadcastView");
                    if (viewPart != null) {
                        MessageBroadcastView view = (MessageBroadcastView)viewPart;
                        System.out.println("Clients : " + clients);
                        view.addRecipients(clients);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.sendMessageAction.setText("Send Message");
        this.sendMessageAction.setToolTipText("Send Message");
        this.disconnectUserAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)ConnectedUsersView.this.viewer.getSelection();
                ConnectedUsersData selection = (ConnectedUsersData)sel.getFirstElement();
                if (selection != null) {
                    if (selection.getUserType() == 3) {
                        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true) && MessageDialog.openQuestion((Shell)ConnectedUsersView.this.getViewSite().getShell(), (String)"Disconnect User", (String)"Are you sure to disconnect the selected user(s).\nDo you want to continue with the option?")) {
                            if (selection.getUserId().equals(Resources.userId)) {
                                return;
                            }
                            DisconnectUser request = new DisconnectUser(selection.getUserId());
                            Resources.sendToAllMS((Message)request);
                        }
                    } else if (selection.getClient() != null && selection.getClient().length() > 0 && Resources.isServerConnected((String)selection.getClient(), (boolean)true, (boolean)false) && MessageDialog.openQuestion((Shell)ConnectedUsersView.this.getViewSite().getShell(), (String)"Disconnect User", (String)"Are you sure to disconnect the selected user(s).\nDo you want to continue with the option?")) {
                        DisconnectUser request = new DisconnectUser(selection.getUserId());
                        Resources.getServerLink((String)selection.getClient(), (boolean)true, (boolean)false).writeData((Object)request);
                    }
                } else {
                    MessageDialog.openInformation((Shell)ConnectedUsersView.this.getViewSite().getShell(), (String)"Disconnect", (String)"No user selected to disconnect.");
                }
            }
        };
        this.disconnectUserAction.setText("Disconnect User");
        this.disconnectUserAction.setToolTipText("Disconnect User");
        this.refreshAction = new Action(){

            public void run() {
                ConnectedUsersView.this.sendConnectedUsersRequest();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(Activator.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
        super.init(site);
    }

    private String pad(String str) {
        return String.valueOf(str) + " :  ";
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayoutData((Object)new GridData(1, 1, true, true, 1, 1));
        this.content.setLayout((Layout)new GridLayout(5, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        composite.setLayout((Layout)new GridLayout(6, true));
        Composite cmp = new Composite(composite, 0);
        cmp.setLayoutData((Object)new GridData(4, -1, true, false, 6, 1));
        cmp.setLayout((Layout)new GridLayout(9, false));
        new Label(cmp, 0).setText("User ID");
        this.txtUserId = new Text(cmp, 2048);
        this.txtUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtUserId.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ConnectedUsersView.this.filter();
            }
        });
        new Label(cmp, 0).setText("Client Code");
        this.txtClientCode = new Text(cmp, 2048);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ConnectedUsersView.this.filter();
            }
        });
        new Label(cmp, 0).setText("User Type");
        this.cmbUserType = new Combo(cmp, 8);
        this.cmbUserType.add("ALL");
        int i = 0;
        while (i < LoginConfirmation.userTypes.length) {
            this.cmbUserType.add(LoginConfirmation.userTypes[i]);
            ++i;
        }
        this.cmbUserType.select(0);
        this.cmbUserType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectedUsersView.this.filter();
            }
        });
        new Label(cmp, 0).setText("Application Type");
        this.cmbAppType = new Combo(cmp, 8);
        this.cmbAppType.add("ALL");
        i = 0;
        while (i < LoginConfirmation.appTypes.length) {
            this.cmbAppType.add(LoginConfirmation.appTypes[i]);
            ++i;
        }
        this.cmbAppType.select(0);
        this.cmbAppType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectedUsersView.this.filter();
            }
        });
        this.btnRefresh = new Button(cmp, 0);
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConnectedUsersView.this.sendConnectedUsersRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblTotalTerminals = this.createLable(composite, this.pad("Total"));
        this.lblTerminalValue = this.createLable(composite, this.pad("Terminal"));
        this.lblEclipseValue = this.createLable(composite, this.pad("Eclipse"));
        this.lblMobileValue = this.createLable(composite, this.pad("Mobile"));
        this.lblOthersValue = this.createLable(composite, this.pad("Others"));
        this.createLable(composite, "");
        this.lblAdminValue = this.createLable(composite, this.pad("Admin"));
        this.lblClientValue = this.createLable(composite, this.pad("Client"));
        this.lblTraderValue = this.createLable(composite, this.pad("Trader"));
        this.lblSubscriberValue = this.createLable(composite, this.pad("Subscriber"));
        this.lblMemberValue = this.createLable(composite, this.pad("Member"));
        this.lblSupportValue = this.createLable(composite, this.pad("Support"));
        this.createViewer(composite);
        this.comparator = new DataComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DataLabelProvider());
        this.comparator.setColumn(this.sortColumn);
        this.filter = new DataFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("top"));
                menuManager.add((IAction)ConnectedUsersView.this.sendMessageAction);
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IAction)ConnectedUsersView.this.disconnectUserAction);
                menuManager.add((IContributionItem)new Separator("bottom"));
            }
        });
        this.viewer.getTable().setMenu(menuMgr.createContextMenu((Control)this.viewer.getTable()));
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        if (Resources.loginStatus && Resources.refDataComplete) {
            this.sendConnectedUsersRequest();
        }
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.add((IAction)new ResizeColumnsAction(this.viewer.getTable()));
        menuManager.appendToGroup("top", (IAction)this.sendMessageAction);
        menuManager.appendToGroup("top", (IAction)this.disconnectUserAction);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
        toolBarManager.appendToGroup("top", (IAction)this.refreshAction);
    }

    private void filter() {
        this.filter.setSearchText(this.txtUserId.getText(), this.txtClientCode.getText(), this.cmbUserType.getSelectionIndex() - 1, this.cmbAppType.getSelectionIndex() - 1);
        this.viewer.refresh();
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectedUsersView.this.lblTotalTerminals.setText(String.valueOf(ConnectedUsersView.this.pad("Total")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.terminal + ((ConnectedUsersView)ConnectedUsersView.this).filter.eclipseTerminal + ((ConnectedUsersView)ConnectedUsersView.this).filter.mobile + ((ConnectedUsersView)ConnectedUsersView.this).filter.others));
                ConnectedUsersView.this.lblTerminalValue.setText(String.valueOf(ConnectedUsersView.this.pad("Terminal")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.terminal));
                ConnectedUsersView.this.lblEclipseValue.setText(String.valueOf(ConnectedUsersView.this.pad("Eclipse")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.eclipseTerminal));
                ConnectedUsersView.this.lblMobileValue.setText(String.valueOf(ConnectedUsersView.this.pad("Mobile")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.mobile));
                ConnectedUsersView.this.lblOthersValue.setText(String.valueOf(ConnectedUsersView.this.pad("Others")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.others));
                ConnectedUsersView.this.lblAdminValue.setText(String.valueOf(ConnectedUsersView.this.pad("Admin")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.admin));
                ConnectedUsersView.this.lblClientValue.setText(String.valueOf(ConnectedUsersView.this.pad("Client")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.client));
                ConnectedUsersView.this.lblSubscriberValue.setText(String.valueOf(ConnectedUsersView.this.pad("Subscriber")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.subscriber));
                ConnectedUsersView.this.lblTraderValue.setText(String.valueOf(ConnectedUsersView.this.pad("Trader")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.trader));
                ConnectedUsersView.this.lblMemberValue.setText(String.valueOf(ConnectedUsersView.this.pad("Member")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.member));
                ConnectedUsersView.this.lblSupportValue.setText(String.valueOf(ConnectedUsersView.this.pad("Support")) + String.valueOf(((ConnectedUsersView)ConnectedUsersView.this).filter.support));
            }
        });
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData lblTblGridData = new GridData(4, 4, true, true, 6, 1);
        this.viewer.getControl().setLayoutData((Object)lblTblGridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0, 16384);
        this.createTableViewerColumn(1, 16384);
        this.createTableViewerColumn(2, 16384);
        this.createTableViewerColumn(3, 16384);
        this.createTableViewerColumn(4, 16384);
        this.createTableViewerColumn(5, 16384);
        this.createTableViewerColumn(6, 16384);
        this.createTableViewerColumn(7, 16384);
        this.createTableViewerColumn(8, 16384);
        String[] sizes = Activator.getDefault().getPreferenceStore().getString(PREFS_CONNECTED_USERS_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(int colNumber, int alignment) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setAlignment(alignment);
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        return viewerColumn;
    }

    private Label createLable(Composite parent, String lable) {
        Label lbl = new Label(parent, 0);
        lbl.setText(lable);
        lbl.setAlignment(131072);
        lbl.setLayoutData((Object)new GridData(768));
        return lbl;
    }

    private void sendConnectedUsersRequest() {
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            ConnectedUsersRequest request = new ConnectedUsersRequest();
            this.txtUserId.setText("");
            this.txtClientCode.setText("");
            this.cmbUserType.select(0);
            this.cmbAppType.select(0);
            if (Resources.sendToAllMS((Message)request)) {
                this.btnRefresh.setEnabled(false);
                this.refreshAction.setEnabled(false);
                this.userList.clear();
            }
        }
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ConnectedUsersResponse) {
                        ConnectedUsersResponse rsp = (ConnectedUsersResponse)o;
                        ConnectedUsersView.this.recieveConnectedUsersResponse(rsp);
                        ConnectedUsersView.this.btnRefresh.setEnabled(true);
                        ConnectedUsersView.this.refreshAction.setEnabled(true);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void recieveConnectedUsersResponse(final ConnectedUsersResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectedUsersData[] tempData = resp.getrows();
                        int i = 0;
                        while (i < tempData.length) {
                            if (!ConnectedUsersView.this.userList.contains(tempData[i])) {
                                ConnectedUsersView.this.userList.add(tempData[i]);
                            }
                            ++i;
                        }
                        ConnectedUsersView.this.viewer.setInput((Object)ConnectedUsersView.this.userList);
                        ConnectedUsersView.this.filter();
                    }
                    catch (Exception exception) {
                        System.out.println("Exception in adding rows in Spot Symbol");
                    }
                }
            });
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    class DataComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int direction = 0;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ConnectedUsersData p1 = (ConnectedUsersData)e1;
            ConnectedUsersData p2 = (ConnectedUsersData)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = LoginConfirmation.userTypes[p1.getUserType()].compareTo(LoginConfirmation.userTypes[p2.getUserType()]);
                    break;
                }
                case 1: {
                    rc = p1.getUserId().compareTo(p2.getUserId());
                    break;
                }
                case 2: {
                    rc = p1.getClient().compareTo(p2.getClient());
                    break;
                }
                case 3: {
                    rc = p1.getTrader().compareTo(p2.getTrader());
                    break;
                }
                case 4: {
                    rc = LoginConfirmation.appTypes[p1.getApplicationType()].compareTo(LoginConfirmation.appTypes[p2.getApplicationType()]);
                    break;
                }
                case 5: {
                    rc = p1.getTerminalIP().compareTo(p2.getTerminalIP());
                    break;
                }
                case 6: {
                    rc = p1.getTerminalName().compareTo(p2.getTerminalName());
                    break;
                }
                case 7: {
                    if (p1.getApplicationType() != LoginConfirmation.ECLIPSE_TERMINAL && p2.getApplicationType() != LoginConfirmation.ECLIPSE_TERMINAL || p1.getTerminalVersion() == null || p2.getTerminalVersion() == null) break;
                    rc = p1.getTerminalVersion().compareTo(p2.getTerminalVersion());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class DataFilter
    extends ViewerFilter {
        private String userID = "";
        private String clientCode = "";
        private int userType = -1;
        private int appType = -1;
        int admin = 0;
        int client = 0;
        int subscriber = 0;
        int trader = 0;
        int member = 0;
        int support = 0;
        int terminal = 0;
        int eclipseTerminal = 0;
        int mobile = 0;
        int others = 0;

        DataFilter() {
        }

        public void setSearchText(String userId, String clientCode, int userType, int appType) {
            this.userID = ".*" + userId + ".*";
            this.clientCode = ".*" + clientCode + ".*";
            this.userType = userType;
            this.appType = appType;
            this.admin = 0;
            this.client = 0;
            this.subscriber = 0;
            this.trader = 0;
            this.member = 0;
            this.support = 0;
            this.terminal = 0;
            this.eclipseTerminal = 0;
            this.mobile = 0;
            this.others = 0;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ConnectedUsersData p = (ConnectedUsersData)element;
            try {
                if (!(this.userID != null && !p.getUserId().matches(this.userID) || this.clientCode != null && !p.getClient().matches(this.clientCode) || this.userType != -1 && this.userType != p.getUserType() || this.appType != -1 && this.appType != p.getApplicationType())) {
                    int userType = p.getUserType();
                    if (userType == 0) {
                        ++this.admin;
                    } else if (userType == 1) {
                        ++this.client;
                    } else if (userType == 2) {
                        ++this.subscriber;
                    } else if (userType == 3) {
                        ++this.trader;
                    } else if (userType == 5) {
                        ++this.member;
                    } else if (userType == 6) {
                        ++this.support;
                    }
                    int appType = p.getApplicationType();
                    if (appType == LoginConfirmation.OLD_TERMINAL) {
                        ++this.terminal;
                    } else if (appType == LoginConfirmation.MOBILE) {
                        ++this.mobile;
                    } else if (appType == LoginConfirmation.ECLIPSE_TERMINAL) {
                        ++this.eclipseTerminal;
                    } else if (appType == LoginConfirmation.OTHERS) {
                        ++this.others;
                    }
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }
    }

    class DataLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DataLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int colNumber) {
            ConnectedUsersData data = (ConnectedUsersData)element;
            switch (colNumber) {
                case 0: {
                    return LoginConfirmation.userTypes[data.getUserType()];
                }
                case 1: {
                    return data.getUserId();
                }
                case 2: {
                    return data.getClient();
                }
                case 3: {
                    return data.getTrader();
                }
                case 4: {
                    return LoginConfirmation.appTypes[data.getApplicationType()];
                }
                case 5: {
                    return data.getTerminalIP();
                }
                case 6: {
                    return data.getTerminalName();
                }
                case 7: {
                    return data.getTerminalVersion();
                }
                case 8: {
                    return data.getServerName();
                }
            }
            return "";
        }
    }
}

