/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ClientDlgInfo;
import pk.com.softech.messages.ClientDlgRequest;
import pk.com.softech.messages.ClientDlgResponse;
import pk.com.softech.tradingterminal.admin.views.SMSMessageBroadcastView;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class ClientsSearchingView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.ClientsSearchingView";
    public static final String PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE = "PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE";
    private static final int LABEL_WIDTH = 75;
    private static final int LABEL_HEIGHT = 19;
    private static final int BUTTON_WIDTH = 75;
    private static final int BUTTON_HEIGHT = 22;
    private static final int TEXT_WIDTH = 75;
    private static final int TEXT_HEIGHT = 15;
    int sortColumn = 0;
    int sortDirection = 1;
    Color colorYellow;
    Color gray;
    private Text txtClientCode;
    private Text txtClientName;
    private Text txtLotCode;
    private Text txtMobileNo;
    private Text txtAddress;
    private Text txtIdCardNo;
    public static final int CLIENTNAME = 0;
    public static final int CLIENTCODE = 1;
    public static final int LOTCODE = 2;
    public static final int TRADERCODE = 3;
    public static final int MOBILENO = 4;
    public static final int MAIDENNAME = 5;
    public static final int PINCODE = 6;
    public static final int ADDRESS = 7;
    public static final int IDCARDNO = 8;
    public static final int EMAIL = 9;
    private static String[] COLUMN_NAMES = new String[]{"Client Name", "Client Code", "Lot Code", "Trader Code", "Mobile Number", "Mother Maiden Name", "Pin Code", "Address", "ID Card", "Email"};
    private SecurityFilter filter;
    private Composite parent;
    Composite content;
    public static final String PREFS_SORT_COLUMN = "CLIENTLISTING_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "CLIENTLISTING_SORT_DIRECTION";
    Table table_acc = null;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TableViewer viewer;
    private ClientComparator comparator;
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ClientsSearchingView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientsSearchingView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(ClientsSearchingView.PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = ClientsSearchingView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (ClientsSearchingView.this.sortColumn == index) {
                ClientsSearchingView.this.sortDirection = ClientsSearchingView.this.sortDirection == 0 ? 1 : 0;
            } else {
                ClientsSearchingView.this.sortColumn = index;
                ClientsSearchingView.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(ClientsSearchingView.PREFS_SORT_COLUMN, ClientsSearchingView.this.sortColumn);
            prefs.setValue(ClientsSearchingView.PREFS_SORT_DIRECTION, ClientsSearchingView.this.sortDirection);
            ClientsSearchingView.this.viewer.getTable().setSortColumn(ClientsSearchingView.this.viewer.getTable().getColumn(ClientsSearchingView.this.sortColumn));
            ClientsSearchingView.this.viewer.getTable().setSortDirection(ClientsSearchingView.this.sortDirection == 0 ? 128 : 1024);
            ClientsSearchingView.this.comparator.setColumn(ClientsSearchingView.this.sortColumn);
            ClientsSearchingView.this.viewer.refresh();
        }
    };

    public ClientsSearchingView() {
        CorePlugin.getRepository().allClientList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        int size;
        this.parent = parent;
        GridData lblGridData = new GridData(75, 19);
        GridData txtGridData = new GridData(75, 15);
        GridData btnGridData = new GridData(75, 22);
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(7, true));
        this.createLabel(composite, "Client Name", lblGridData);
        this.txtClientName = this.createText(composite, 16384, txtGridData);
        this.txtClientName.setEnabled(true);
        this.txtClientName.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientsSearchingView.this.filter.setSearchText(ClientsSearchingView.this.txtClientCode.getText(), ClientsSearchingView.this.txtClientName.getText(), ClientsSearchingView.this.txtLotCode.getText(), ClientsSearchingView.this.txtMobileNo.getText(), ClientsSearchingView.this.txtAddress.getText(), ClientsSearchingView.this.txtIdCardNo.getText());
                ClientsSearchingView.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Client Code", lblGridData);
        this.txtClientCode = this.createText(composite, 16384, txtGridData);
        this.txtClientCode.setEnabled(true);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientsSearchingView.this.filter.setSearchText(ClientsSearchingView.this.txtClientCode.getText(), ClientsSearchingView.this.txtClientName.getText(), ClientsSearchingView.this.txtLotCode.getText(), ClientsSearchingView.this.txtMobileNo.getText(), ClientsSearchingView.this.txtAddress.getText(), ClientsSearchingView.this.txtIdCardNo.getText());
                ClientsSearchingView.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Lot Code", lblGridData);
        this.txtLotCode = this.createText(composite, 16384, txtGridData);
        this.txtLotCode.setEnabled(true);
        this.txtLotCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtLotCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientsSearchingView.this.filter.setSearchText(ClientsSearchingView.this.txtClientCode.getText(), ClientsSearchingView.this.txtClientName.getText(), ClientsSearchingView.this.txtLotCode.getText(), ClientsSearchingView.this.txtMobileNo.getText(), ClientsSearchingView.this.txtAddress.getText(), ClientsSearchingView.this.txtIdCardNo.getText());
                ClientsSearchingView.this.viewer.refresh();
            }
        });
        Button btnRefresh = new Button(composite, 0x1000000);
        btnRefresh.setLayoutData((Object)btnGridData);
        btnRefresh.setText("Refresh");
        btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClientsSearchingView.this.sendClientListingRequest();
                ClientsSearchingView.this.filter.setSearchText(ClientsSearchingView.this.txtClientCode.getText(), ClientsSearchingView.this.txtClientName.getText(), ClientsSearchingView.this.txtLotCode.getText(), ClientsSearchingView.this.txtMobileNo.getText(), ClientsSearchingView.this.txtAddress.getText(), ClientsSearchingView.this.txtIdCardNo.getText());
                ClientsSearchingView.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createLabel(composite, "Mobile No", lblGridData);
        this.txtMobileNo = this.createText(composite, 16384, txtGridData);
        this.txtMobileNo.setEnabled(true);
        this.txtMobileNo.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtMobileNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientsSearchingView.this.filter.setSearchText(ClientsSearchingView.this.txtClientCode.getText(), ClientsSearchingView.this.txtClientName.getText(), ClientsSearchingView.this.txtLotCode.getText(), ClientsSearchingView.this.txtMobileNo.getText(), ClientsSearchingView.this.txtAddress.getText(), ClientsSearchingView.this.txtIdCardNo.getText());
                ClientsSearchingView.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Address", lblGridData);
        this.txtAddress = this.createText(composite, 16384, txtGridData);
        this.txtAddress.setEnabled(true);
        this.txtAddress.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtAddress.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientsSearchingView.this.filter.setSearchText(ClientsSearchingView.this.txtClientCode.getText(), ClientsSearchingView.this.txtClientName.getText(), ClientsSearchingView.this.txtLotCode.getText(), ClientsSearchingView.this.txtMobileNo.getText(), ClientsSearchingView.this.txtAddress.getText(), ClientsSearchingView.this.txtIdCardNo.getText());
                ClientsSearchingView.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "ID Card", lblGridData);
        this.txtIdCardNo = this.createText(composite, 16384, txtGridData);
        this.txtIdCardNo.setEnabled(true);
        this.txtIdCardNo.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtIdCardNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientsSearchingView.this.filter.setSearchText(ClientsSearchingView.this.txtClientCode.getText(), ClientsSearchingView.this.txtClientName.getText(), ClientsSearchingView.this.txtLotCode.getText(), ClientsSearchingView.this.txtMobileNo.getText(), ClientsSearchingView.this.txtAddress.getText(), ClientsSearchingView.this.txtIdCardNo.getText());
                ClientsSearchingView.this.viewer.refresh();
            }
        });
        Button btnSendSms = new Button(composite, 0x1000000);
        btnSendSms.setLayoutData((Object)btnGridData);
        btnSendSms.setText("Send SMS");
        btnSendSms.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ClientsSearchingView.this.viewer.getSelection();
                ArrayList<ClientDlgInfo> lst = new ArrayList<ClientDlgInfo>();
                int i = 0;
                while (i < selection.size()) {
                    lst.add((ClientDlgInfo)selection.getFirstElement());
                    ++i;
                }
                try {
                    IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.admin.views.SMSMessageBroadcastView");
                    if (viewPart != null) {
                        SMSMessageBroadcastView view = (SMSMessageBroadcastView)viewPart;
                        view.addRecipients(lst);
                    }
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (Resources.trnCode.contains("OD13")) {
            btnSendSms.setEnabled(true);
        } else {
            btnSendSms.setEnabled(false);
        }
        this.createViewer(this.content);
        this.comparator = new ClientComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.comparator.setColumn(this.sortColumn);
        this.filter = new SecurityFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        if (Resources.userType != -1 && Resources.userType != 1 && Resources.loginStatus && Resources.refDataComplete && (size = CorePlugin.getRepository().allClientList().size()) <= 0) {
            this.sendClientListingRequest();
        }
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new ResizeColumnsAction(this.viewer.getTable()));
    }

    private void clearFields() {
        this.txtClientCode.setText("");
        this.txtClientName.setText("");
        this.txtLotCode.setText("");
        this.txtMobileNo.setText("");
        this.txtAddress.setText("");
        this.txtIdCardNo.setText("");
    }

    private void sendClientListingRequest() {
        int size = CorePlugin.getRepository().allClientList().size();
        if (size <= 0) {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                ClientDlgRequest request = new ClientDlgRequest();
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            }
        } else {
            ObservableList allClients = CorePlugin.getRepository().allClientList();
            this.logger.info((Object)("Available Client List Size: " + allClients.size()));
            this.viewer.setInput((Object)allClients);
            this.viewer.refresh();
        }
    }

    private Label createLabel(Composite parent, String label, GridData gridData) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        temp.setLayoutData((Object)gridData);
        return temp;
    }

    private Text createText(Composite parent, int allignment, GridData gridData) {
        Text temp = new Text(parent, 2176);
        temp.setLayoutData((Object)gridData);
        temp.setEnabled(false);
        return temp;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ClientDlgInfo obj;
                    if (o instanceof ClientDlgInfo && (obj = (ClientDlgInfo)o) != null) {
                        ClientsSearchingView.this.viewer.add((Object)obj);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void recieveClientDlgResponse(final ClientDlgResponse resp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (resp.getRows() != null) {
                    ClientDlgInfo[] rows = resp.getRows();
                    ClientsSearchingView.this.logger.info((Object)("Receive Client List Size: " + rows.length));
                    ClientsSearchingView.this.viewer.setInput(Arrays.asList(resp.getRows()));
                }
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().allClientList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            this.createTableViewerColumn(i);
            ++i;
        }
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE).split(";");
        int i2 = 0;
        while (i2 < viewer.getTable().getColumnCount()) {
            if (i2 < sizes.length && sizes[i2].length() != 0) {
                viewer.getTable().getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
            } else {
                viewer.getTable().getColumn(i2).pack();
                if (viewer.getTable().getColumn(i2).getWidth() == 0) {
                    viewer.getTable().getColumn(i2).setWidth(100);
                }
            }
            ++i2;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getClientName().toUpperCase());
                        break;
                    }
                    case 1: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getClientCode().toUpperCase());
                        break;
                    }
                    case 2: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getClientLot().toUpperCase());
                        break;
                    }
                    case 3: {
                        if (((ClientDlgInfo)cell.getElement()).getTraderCode() == null) break;
                        cell.setText(((ClientDlgInfo)cell.getElement()).getTraderCode().toUpperCase());
                        break;
                    }
                    case 4: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getMobileNo());
                        break;
                    }
                    case 5: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getMaidenName());
                        break;
                    }
                    case 6: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getPinCode());
                        break;
                    }
                    case 7: {
                        String address = ((ClientDlgInfo)cell.getElement()).getAddress();
                        if (address == null) {
                            address = "";
                        }
                        cell.setText(address.toUpperCase());
                        break;
                    }
                    case 8: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getIdCardNo());
                        break;
                    }
                    case 9: {
                        cell.setText(((ClientDlgInfo)cell.getElement()).getEmail());
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                ClientDlgInfo sec = (ClientDlgInfo)element;
                return sec.getClientName();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    class ClientComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ClientDlgInfo p1 = (ClientDlgInfo)e1;
            ClientDlgInfo p2 = (ClientDlgInfo)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getClientName().compareTo(p2.getClientName());
                    break;
                }
                case 1: {
                    rc = p1.getClientCode().compareTo(p2.getClientCode());
                    break;
                }
                case 2: {
                    rc = p1.getClientLot().compareTo(p2.getClientLot());
                    break;
                }
                case 3: {
                    rc = p1.getClientLot().compareTo(p2.getTraderCode());
                    break;
                }
                case 4: {
                    rc = p1.getMobileNo().compareTo(p2.getMobileNo());
                    break;
                }
                case 5: {
                    rc = p1.getMobileNo().compareTo(p2.getMaidenName());
                    break;
                }
                case 6: {
                    rc = p1.getMobileNo().compareTo(p2.getPinCode());
                    break;
                }
                case 7: {
                    rc = p1.getAddress().compareTo(p2.getAddress());
                    break;
                }
                case 8: {
                    rc = p1.getIdCardNo().compareTo(p2.getIdCardNo());
                    break;
                }
                case 9: {
                    rc = p1.getEmail().compareTo(p2.getEmail());
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    class SecurityFilter
    extends ViewerFilter {
        private String clientCode;
        private String clientName;
        private String lotCode;
        private String mobileNo;
        private String address;
        private String idCardNo;

        SecurityFilter() {
        }

        public void setSearchText(String s1, String s2, String s3, String s4, String s5, String s6) {
            this.clientCode = ".*" + s1 + ".*";
            this.clientName = ".*" + s2 + ".*";
            this.lotCode = ".*" + s3 + ".*";
            this.mobileNo = ".*" + s4 + ".*";
            this.address = ".*" + s5 + ".*";
            this.idCardNo = ".*" + s6 + ".*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.clientName == null || this.clientName.length() == 0) {
                return true;
            }
            if (this.clientCode == null || this.clientCode.length() == 0) {
                return true;
            }
            if (this.lotCode == null || this.lotCode.length() == 0) {
                return true;
            }
            if (this.mobileNo == null || this.mobileNo.length() == 0) {
                return true;
            }
            if (this.address == null || this.address.length() == 0) {
                return true;
            }
            if (this.idCardNo == null || this.idCardNo.length() == 0) {
                return true;
            }
            ClientDlgInfo p = (ClientDlgInfo)element;
            if (p.clientName == null) {
                p.clientName = "";
            }
            if (p.clientCode == null) {
                p.clientCode = "";
            }
            if (p.clientLot == null) {
                p.clientLot = "";
            }
            if (p.mobileNo == null) {
                p.mobileNo = "";
            }
            if (p.maidenName == null) {
                p.maidenName = "";
            }
            if (p.address == null) {
                p.address = "";
            }
            if (p.idCardNo == null) {
                p.idCardNo = "";
            }
            return p.getClientName().matches(this.clientName) && p.getClientCode().matches(this.clientCode) && p.getClientLot().matches(this.lotCode) && p.getMobileNo().matches(this.mobileNo) && p.getAddress().matches(this.address) && p.getIdCardNo().matches(this.idCardNo);
        }
    }
}

