/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ClientProfileRequest;
import pk.com.softech.messages.ClientProfileResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class ClientProfileView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.ClientProfile";
    CTabFolder tabFolder;
    private Composite parent;
    Composite content;
    ScrolledComposite profileSC;
    ScrolledComposite commissionSC;
    Font font_bold;
    Color blue;
    Color red;
    Text txtClientCode = null;
    Text cname;
    Text clientCode;
    Text nic;
    Text email;
    Text address;
    Text city;
    Text cMobile;
    Text smsService;
    Text onlineClient;
    Text tradingAcc;
    Text cdcAcc;
    Text participantId;
    Text fundingType;
    Text zakatStatus;
    Text openDate;
    Text expiryDate;
    Text branchCode;
    Text traderCode;
    Text tname;
    Text traderMobile;
    Text traderEmail;
    Text bankName;
    Text accountTitle;
    Text accountNo;
    Text branch;
    Text cityCode;
    Combo nominee;
    Combo jointHolders;
    Label error;
    Button btnFetch = null;
    private FontMetrics fontMetrics;

    public ClientProfileView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ClientProfileResponse) {
                        ClientProfileView.this.clearFields();
                        ClientProfileView.this.recieveClientProfileResponse((ClientProfileResponse)o);
                        ClientProfileView.this.btnFetch.setEnabled(true);
                    }
                    if (o instanceof LoginConfirmation) {
                        ClientProfileView.this.txtClientCode.setText(Resources.clientId);
                        ClientProfileView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        ClientProfileView.this.sendClientProfileRequest();
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Display display = Display.getCurrent();
        this.blue = display.getSystemColor(9);
        this.red = display.getSystemColor(3);
        Composite content1 = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content1.setLayout((Layout)gridLayout);
        content1.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder = new CTabFolder(content1, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.setForeground(this.blue);
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText("Client Profile");
        this.createProfileView((Composite)this.tabFolder);
        tabItem.setControl((Control)this.profileSC);
        this.tabFolder.setSelection(0);
        if (Resources.loginStatus) {
            this.sendClientProfileRequest();
        }
    }

    public void setFocus() {
    }

    public void createProfileView(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        this.profileSC = new ScrolledComposite(parent, 2816);
        this.profileSC.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)this.profileSC, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.content);
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createLabel(composite, "Client Code", this.font_bold);
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)25), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    if (ClientProfileView.this.txtClientCode.getText().length() > 0) {
                        ClientProfileView.this.sendClientProfileRequest();
                    } else {
                        ClientProfileView.this.clearFields();
                        MessageDialog.openError(null, (String)"Inavlid Parameters", (String)"Please Enter Client Code");
                    }
                }
            }
        });
        this.btnFetch = new Button(composite, 0);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientProfileView.this.txtClientCode.getText().length() > 0) {
                    ClientProfileView.this.sendClientProfileRequest();
                } else {
                    ClientProfileView.this.clearFields();
                    MessageDialog.openError(null, (String)"Inavlid Parameters", (String)"Please Enter Client Code");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group grp1 = new Group(this.content, 0);
        grp1.setLayoutData((Object)new GridData());
        grp1.setLayout((Layout)new GridLayout(6, false));
        grp1.setText("Client Info");
        grp1.setFont(this.font_bold);
        this.createLabel((Composite)grp1, "Account Title");
        this.cname = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "Client Code");
        this.clientCode = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "Mobile No");
        this.cMobile = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "NIC No");
        this.nic = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "NIC Expiry Date");
        this.expiryDate = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "Email");
        this.email = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "Online Client");
        this.onlineClient = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "SMS Service");
        this.smsService = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "City");
        this.city = this.createText((Composite)grp1, 16384);
        this.createLabel((Composite)grp1, "Address");
        this.address = this.createText((Composite)grp1, 16384);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)this.address);
        Group grp = new Group(this.content, 0);
        grp.setLayoutData((Object)new GridData());
        grp.setLayout((Layout)new GridLayout(6, false));
        grp.setText("Accounts Detail");
        grp.setFont(this.font_bold);
        this.createLabel((Composite)grp, "Trading Account No.");
        this.tradingAcc = this.createText((Composite)grp, 16384);
        this.createLabel((Composite)grp, "CDC Sub Account No.");
        this.cdcAcc = this.createText((Composite)grp, 16384);
        this.createLabel((Composite)grp, "Participant Id");
        this.participantId = this.createText((Composite)grp, 16384);
        this.createLabel((Composite)grp, "Zakat Deduction ");
        this.zakatStatus = this.createText((Composite)grp, 16384);
        this.createLabel((Composite)grp, "Account Open Date");
        this.openDate = this.createText((Composite)grp, 16384);
        this.createLabel((Composite)grp, "Branch Name");
        this.branchCode = this.createText((Composite)grp, 16384);
        this.createLabel((Composite)grp, "Funding Type");
        this.fundingType = this.createText((Composite)grp, 16384);
        this.createLabel((Composite)grp, " Nominee/Successor");
        this.nominee = new Combo((Composite)grp, 8);
        this.nominee.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.createLabel((Composite)grp, "Joint account holder(s)");
        this.jointHolders = new Combo((Composite)grp, 8);
        this.jointHolders.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        Group grp2 = new Group(this.content, 0);
        grp2.setLayoutData((Object)new GridData());
        grp2.setLayout((Layout)new GridLayout(6, false));
        grp2.setText("Trader Info");
        grp2.setFont(this.font_bold);
        this.createLabel((Composite)grp2, "Trader Code ");
        this.traderCode = this.createText((Composite)grp2, 16384);
        this.createLabel((Composite)grp2, "Trader Name");
        this.tname = this.createText((Composite)grp2, 16384);
        this.createLabel((Composite)grp2, "Direct Number");
        this.traderMobile = this.createText((Composite)grp2, 16384);
        this.createLabel((Composite)grp2, "Trader Email");
        this.traderEmail = this.createText((Composite)grp2, 16384);
        this.error = new Label(this.content, 0);
        this.error.setText("***No information available for Dividend Mandate");
        this.error.setForeground(this.red);
        this.error.setFont(this.font_bold);
        Group grp3 = new Group(this.content, 0);
        grp3.setLayoutData((Object)new GridData());
        grp3.setLayout((Layout)new GridLayout(6, false));
        grp3.setText("Dividend Mandate");
        grp3.setFont(this.font_bold);
        this.createLabel((Composite)grp3, "Bank Name ");
        this.bankName = this.createText((Composite)grp3, 16384);
        this.createLabel((Composite)grp3, "Account Title");
        this.accountTitle = this.createText((Composite)grp3, 16384);
        this.createLabel((Composite)grp3, "Account Number");
        this.accountNo = this.createText((Composite)grp3, 16384);
        this.createLabel((Composite)grp3, "Branch");
        this.branch = this.createText((Composite)grp3, 16384);
        this.createLabel((Composite)grp3, "City");
        this.cityCode = this.createText((Composite)grp3, 16384);
        this.profileSC.setContent((Control)this.content);
        this.profileSC.setExpandHorizontal(true);
        this.profileSC.setExpandVertical(true);
        this.profileSC.setMinSize(this.content.computeSize(-1, -1));
    }

    private void sendClientProfileRequest() {
        block5: {
            if (this.txtClientCode.getText().length() > 0) {
                try {
                    if (!this.btnFetch.isEnabled()) break block5;
                    if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                        System.out.println("Client Id : " + this.txtClientCode.getText() + " , Trader Id : " + Resources.traderId);
                        ClientProfileRequest request = new ClientProfileRequest(this.txtClientCode.getText().trim(), Resources.traderId.trim());
                        Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
                        this.btnFetch.setEnabled(false);
                        break block5;
                    }
                    this.clearFields();
                }
                catch (Exception e) {
                    CorePlugin.logException((Exception)e);
                }
            } else {
                this.clearFields();
            }
        }
    }

    public void recieveClientProfileResponse(final ClientProfileResponse rsp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SimpleDateFormat formater = new SimpleDateFormat("dd/MM/yyyy");
                try {
                    if (rsp.getAction() == 2) {
                        MessageDialog.openError(null, (String)"ERROR", (String)rsp.getRemarks());
                    } else {
                        int i;
                        if (rsp.getClientName() != null) {
                            ClientProfileView.this.cname.setText(rsp.getClientName());
                        }
                        if (rsp.getClientCode() != null) {
                            ClientProfileView.this.clientCode.setText(rsp.getClientCode());
                        }
                        if (rsp.getNIC() != null) {
                            ClientProfileView.this.nic.setText(rsp.getNIC());
                        }
                        if (rsp.getClientMobile() != null) {
                            ClientProfileView.this.cMobile.setText(rsp.getClientMobile());
                        }
                        if (rsp.getEmail() != null) {
                            ClientProfileView.this.email.setText(rsp.getEmail());
                        }
                        if (rsp.getCity() != null) {
                            ClientProfileView.this.city.setText(rsp.getCity());
                        }
                        if (rsp.getAddress() != null) {
                            ClientProfileView.this.address.setText(rsp.getAddress());
                        }
                        if (rsp.getSmsService() == 0) {
                            ClientProfileView.this.smsService.setText("N/A");
                        } else if (rsp.getSmsService() == 1) {
                            ClientProfileView.this.smsService.setText("Partial");
                        } else if (rsp.getSmsService() == 2) {
                            ClientProfileView.this.smsService.setText("Full");
                        }
                        if (rsp.getOnlineClient() == 1) {
                            ClientProfileView.this.onlineClient.setText("Yes");
                        } else if (rsp.getOnlineClient() == 0) {
                            ClientProfileView.this.onlineClient.setText("No");
                        }
                        if (rsp.getTradingAccountNo() != null) {
                            ClientProfileView.this.tradingAcc.setText(rsp.getTradingAccountNo());
                        }
                        if (rsp.getCdcAccountNo() != null) {
                            ClientProfileView.this.cdcAcc.setText(rsp.getCdcAccountNo());
                        }
                        if (rsp.getParticipantId() != null) {
                            ClientProfileView.this.participantId.setText(rsp.getParticipantId());
                        }
                        if (rsp.getZakatStatus() == 1) {
                            ClientProfileView.this.zakatStatus.setText("Yes");
                        } else if (rsp.getZakatStatus() == 0) {
                            ClientProfileView.this.zakatStatus.setText("No");
                        }
                        if (rsp.getOpenDate() != null) {
                            ClientProfileView.this.openDate.setText(formater.format(rsp.getOpenDate()));
                        }
                        if (rsp.getExpiryDate() != null) {
                            ClientProfileView.this.expiryDate.setText(formater.format(rsp.getExpiryDate()));
                        }
                        if (rsp.getTraderName() != null) {
                            ClientProfileView.this.tname.setText(rsp.getTraderName());
                        }
                        if (rsp.getTraderCode() != null) {
                            ClientProfileView.this.traderCode.setText(rsp.getTraderCode());
                        }
                        if (rsp.getBranchCode() != null) {
                            ClientProfileView.this.branchCode.setText(rsp.getBranchCode());
                        }
                        if (rsp.getTraderMobile() != null) {
                            ClientProfileView.this.traderMobile.setText(rsp.getTraderMobile());
                        }
                        if (rsp.getTraderEmail() != null) {
                            ClientProfileView.this.traderEmail.setText(rsp.getTraderEmail());
                        }
                        if (rsp.getNominee() != null) {
                            List nom = rsp.getNominee();
                            i = 0;
                            while (i < nom.size()) {
                                ClientProfileView.this.nominee.add((String)nom.get(i));
                                ++i;
                            }
                            ClientProfileView.this.nominee.select(0);
                        }
                        if (rsp.getJointHolder() != null) {
                            List hol = rsp.getJointHolder();
                            i = 0;
                            while (i < hol.size()) {
                                ClientProfileView.this.jointHolders.add((String)hol.get(i));
                                ++i;
                            }
                            ClientProfileView.this.jointHolders.select(0);
                        }
                        if (rsp.getFundingType() != null) {
                            ClientProfileView.this.fundingType.setText(rsp.getFundingType());
                        }
                        if (rsp.getDividend() != null && rsp.getDividend().equals("Yes")) {
                            ClientProfileView.this.error.setVisible(false);
                            if (rsp.getBankName() != null) {
                                ClientProfileView.this.bankName.setText(rsp.getBankName());
                            }
                            if (rsp.getAccountTitle() != null) {
                                ClientProfileView.this.accountTitle.setText(rsp.getAccountTitle());
                            }
                            if (rsp.getAccountNo() != null) {
                                ClientProfileView.this.accountNo.setText(rsp.getAccountNo());
                            }
                            if (rsp.getBranch() != null) {
                                ClientProfileView.this.branch.setText(rsp.getBranch());
                            }
                            if (rsp.getCityCode() != null) {
                                ClientProfileView.this.cityCode.setText(rsp.getCityCode());
                            }
                        } else {
                            ClientProfileView.this.error.setVisible(true);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Exception in recieveClientProfileResponse : " + e);
                }
            }
        });
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        temp.setForeground(this.blue);
        return temp;
    }

    private Label createLabel(Composite parent, String label, Font font) {
        Label temp = new Label(parent, 0);
        temp.setFont(font);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)25), -1));
        temp.setEnabled(true);
        temp.setEditable(false);
        return temp;
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public void clearFields() {
        if (this.txtClientCode.isEnabled()) {
            this.txtClientCode.setText("");
        }
        this.cname.setText("");
        this.clientCode.setText("");
        this.city.setText("");
        this.cMobile.setText("");
        this.email.setText("");
        this.nic.setText("");
        this.smsService.setText("");
        this.onlineClient.setText("");
        this.address.setText("");
        this.tradingAcc.setText("");
        this.cdcAcc.setText("");
        this.participantId.setText("");
        this.zakatStatus.setText("");
        this.openDate.setText("");
        this.expiryDate.setText("");
        this.branchCode.setText("");
        this.fundingType.setText("");
        this.traderCode.setText("");
        this.tname.setText("");
        this.traderEmail.setText("");
        this.traderMobile.setText("");
        this.nominee.removeAll();
        this.jointHolders.removeAll();
        this.bankName.setText("");
        this.accountNo.setText("");
        this.accountTitle.setText("");
        this.branch.setText("");
        this.cityCode.setText("");
        this.error.setVisible(false);
    }
}

