/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.views;

import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.CancelOrderData;
import pk.com.softech.messages.CancelOrderRequest;
import pk.com.softech.messages.CancelOrderResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.PopupEvent;
import pk.com.softech.tradingterminal.core.link.TCPLink;

public class CancelOrderFormView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.admin.views.CancelOrderFormView";
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Composite parent;
    Table table;
    Button btnSelectAll;
    Button btnFetch;
    Button btnCancel;
    Combo cmbServers;
    String[] column_names = new String[]{"Order Number", "Client Code", "Symbol", "Volume", "Price", "Side", "Date/Time"};

    public CancelOrderFormView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(5, 5).spacing(5, 5).applyTo(parent);
        Composite north = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(5, 5).spacing(10, 5).applyTo(north);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 4).grab(true, false).applyTo((Control)north);
        Composite a1 = new Composite(north, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).spacing(5, 5).applyTo(a1);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 4).grab(false, false).applyTo((Control)a1);
        Label lbl = new Label(a1, 0);
        lbl.setText("Server");
        this.cmbServers = new Combo(a1, 8);
        if (Resources.loginStatus && Resources.msLinks != null) {
            this.cmbServers.removeAll();
            for (TCPLink link : Resources.msLinks.values()) {
                if (link == null) continue;
                this.cmbServers.add(link.getName());
                this.cmbServers.setData(link.getName(), (Object)link);
            }
            this.cmbServers.select(0);
        }
        Composite a2 = new Composite(north, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).spacing(5, 5).applyTo(a2);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 4).grab(false, false).applyTo((Control)a2);
        this.btnFetch = new Button(a2, 8);
        this.btnFetch.setText("Fetch Orders");
        this.btnFetch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CancelOrderRequest req = new CancelOrderRequest(true);
                CancelOrderFormView.this.sendRequest(req);
                CancelOrderFormView.this.btnFetch.setEnabled(false);
            }
        });
        this.btnSelectAll = new Button(a2, 32);
        this.btnSelectAll.setText("Select All");
        this.btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < CancelOrderFormView.this.table.getItemCount()) {
                    TableItem item = CancelOrderFormView.this.table.getItem(i);
                    item.setChecked(CancelOrderFormView.this.btnSelectAll.getSelection());
                    ++i;
                }
            }
        });
        Composite a3 = new Composite(north, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(5, 5).spacing(5, 5).applyTo(a3);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 4).grab(false, false).applyTo((Control)a3);
        this.btnCancel = new Button(a3, 8);
        this.btnCancel.setText("Cancel Orders");
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<CancelOrderData> list = new ArrayList<CancelOrderData>();
                int i = 0;
                while (i < CancelOrderFormView.this.table.getItemCount()) {
                    TableItem item = CancelOrderFormView.this.table.getItem(i);
                    if (item.getChecked()) {
                        list.add((CancelOrderData)item.getData());
                    }
                    ++i;
                }
                if (list.size() > 0) {
                    boolean result = MessageDialog.openConfirm(null, (String)"Cancel Order(s)", (String)("Do you want to cancel selected  (" + list.size() + ") orders"));
                    if (result) {
                        CancelOrderRequest req = new CancelOrderRequest(list.toArray(new CancelOrderData[0]));
                        CancelOrderFormView.this.sendRequest(req);
                        CancelOrderFormView.this.btnCancel.setEnabled(false);
                    }
                } else {
                    MessageDialog.openInformation(null, (String)"Cancel Orders", (String)"No order selected for cancellation.");
                }
            }
        });
        this.table = new Table(parent, 2848);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridDataFactory.fillDefaults().span(1, 1).align(4, 4).grab(true, true).applyTo((Control)this.table);
        int loopIndex = 0;
        while (loopIndex < this.column_names.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(this.column_names[loopIndex]);
            ++loopIndex;
        }
        loopIndex = 0;
        while (loopIndex < this.column_names.length) {
            this.table.getColumn(loopIndex).pack();
            ++loopIndex;
        }
    }

    protected void sendRequest(CancelOrderRequest req) {
        TCPLink link = (TCPLink)this.cmbServers.getData(this.cmbServers.getText());
        System.out.println("Selected link : " + link);
        if (link == null) {
            MessageDialog.openError(null, (String)"Link Error", (String)"Please select a valid server link");
        } else if (!link.isConnected()) {
            MessageDialog.openError(null, (String)"Connection Error", (String)"You seem to be disconnected from the server. \n Please re-connect again from the file menu.");
        } else {
            link.writeData((Object)req);
            this.logger.info((Object)("CancelOrderStatus req sent on server : " + this.cmbServers.getText()));
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof CancelOrderResponse) {
                        CancelOrderResponse resp = (CancelOrderResponse)o;
                        CancelOrderFormView.this.recieveResponse(resp);
                        if (resp.isFetchOrders()) {
                            CancelOrderFormView.this.btnFetch.setEnabled(true);
                        } else {
                            CancelOrderFormView.this.table.removeAll();
                            CancelOrderFormView.this.btnCancel.setEnabled(true);
                            PopupEvent event = new PopupEvent();
                            event.setDate(new Date());
                            event.setMessage("Multiple Orders Cancel");
                            event.setLongMessage(resp.getRemarks());
                            event.setMessage_Type(12);
                            CorePlugin.getRepository().save((PersistentObject)event);
                        }
                    } else if (o instanceof LoginConfirmation && Resources.loginStatus && Resources.msLinks != null) {
                        CancelOrderFormView.this.cmbServers.removeAll();
                        for (TCPLink link : Resources.msLinks.values()) {
                            if (link == null) continue;
                            CancelOrderFormView.this.cmbServers.add(link.getName());
                            CancelOrderFormView.this.cmbServers.setData(link.getName(), (Object)link);
                        }
                        CancelOrderFormView.this.cmbServers.select(0);
                    }
                }
            });
        }
    }

    protected void recieveResponse(CancelOrderResponse resp) {
        int loopIndex;
        CancelOrderData[] rows = resp.getRows();
        this.btnSelectAll.setSelection(false);
        this.table.removeAll();
        if (rows != null) {
            this.logger.info((Object)("CancelOrderData rows : " + rows.length));
            loopIndex = 0;
            while (loopIndex < rows.length) {
                CancelOrderData data = rows[loopIndex];
                TableItem item = new TableItem(this.table, 0);
                item.setData((Object)data);
                item.setText(0, "" + data.getOrderNumber());
                item.setText(1, data.getClientCode());
                item.setText(2, data.getSymbol());
                item.setText(3, "" + data.getVolume());
                item.setText(4, "" + data.getPrice());
                item.setText(5, data.getSide());
                if (data.getDate() != null) {
                    item.setText(6, CorePlugin.getDateTimeFormatLong().format(data.getDate()));
                }
                ++loopIndex;
            }
        } else {
            this.logger.info((Object)"Null rows in CancelOrderData");
        }
        loopIndex = 0;
        while (loopIndex < this.column_names.length) {
            this.table.getColumn(loopIndex).pack();
            ++loopIndex;
        }
    }

    public void itemRemoved(Object o) {
    }
}

