/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.ImportUserData;
import pk.com.softech.messages.ImportUserRequest;
import pk.com.softech.messages.ImportUserResponse;
import pk.com.softech.messages.ProgramsRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.InterestVerifyListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;

public class UploadUsersDialog
extends Dialog
implements ICollectionObserver {
    Font font_bold;
    Combo cmbProgm;
    Text txtFile;
    Text txtOpening;
    Text txtUserExpiry;
    Text txtInterestRate;
    Text txtPostFix;
    public Date expiryDate;
    private String[] lstProgram = null;

    public UploadUsersDialog() {
        super(Display.getDefault().getActiveShell());
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
    }

    private void clear() {
        this.txtFile.setText("");
        this.txtOpening.setText("");
        this.cmbProgm.select(0);
        this.txtUserExpiry.setText("");
        this.txtInterestRate.setText("");
        this.txtPostFix.setText("");
    }

    protected Control createDialogArea(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        GridLayout grid = new GridLayout();
        grid.marginTop = 10;
        mainComposite.setLayout((Layout)grid);
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblProgm = new Label(composite, 0);
        lblProgm.setText("Program");
        this.cmbProgm = new Combo(composite, 8);
        this.cmbProgm.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        Label lblOpening = new Label(composite, 0);
        lblOpening.setText("Opening Cash Deposit");
        this.txtOpening = new Text(composite, 2048);
        this.txtOpening.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtOpening.addVerifyListener((VerifyListener)new PriceVerifyListener());
        Label lblInterestRate = new Label(composite, 0);
        lblInterestRate.setText("Interest Rate %");
        this.txtInterestRate = new Text(composite, 2048);
        this.txtInterestRate.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtInterestRate.addVerifyListener((VerifyListener)new InterestVerifyListener());
        Label lblPostFix = new Label(composite, 0);
        lblPostFix.setText("User Post Fix");
        this.txtPostFix = new Text(composite, 2048);
        this.txtPostFix.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtPostFix.addVerifyListener((VerifyListener)new CapitalTextListener());
        Composite dateComposite = new Composite(mainComposite, 0);
        dateComposite.setLayout((Layout)new GridLayout(3, false));
        new GridData(60, 20);
        Label lblUserExpiry = new Label(dateComposite, 0);
        lblUserExpiry.setText("User Expiry");
        this.txtUserExpiry = new Text(dateComposite, 2048);
        this.txtUserExpiry.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtUserExpiry.setEnabled(false);
        Button setDate = new Button(dateComposite, 8);
        setDate.setText("Set Date");
        setDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = UploadUsersDialog.this.covertStringToDate(currentDate);
                        Date sDate = UploadUsersDialog.this.covertStringToDate(dateString);
                        if (sDate.compareTo(cDate) == 1 || sDate.compareTo(cDate) == 0) {
                            (this).UploadUsersDialog.this.txtUserExpiry.setText(dateString);
                            (this).UploadUsersDialog.this.expiryDate = sDate;
                            dialog.close();
                        } else {
                            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid Date");
                            (this).UploadUsersDialog.this.txtUserExpiry.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        Label lblFile = new Label(dateComposite, 0);
        lblFile.setText("File Name");
        this.txtFile = new Text(dateComposite, 2048);
        this.txtFile.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        Button uploadFile = new Button(dateComposite, 8);
        uploadFile.setText("---");
        uploadFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell dialog = new Shell(Display.getDefault().getActiveShell());
                FileDialog fd = new FileDialog(dialog, 4096);
                fd.setText("Open");
                fd.setFilterPath("C:/");
                String selected = fd.open();
                if (selected != null) {
                    UploadUsersDialog.this.txtFile.setText(selected);
                }
            }
        });
        Composite labelComposite = new Composite(mainComposite, 0);
        labelComposite.setLayout((Layout)new GridLayout(1, false));
        Label caption = new Label(labelComposite, 0);
        caption.setText("* File should be in the Format [USER_ID,USER_NAME]\n* Supported files are '.txt' and '.csv' files\n* User post fix size must be 4");
        Color clr = new Color((Device)parent.getDisplay(), 255, 0, 0);
        caption.setForeground(clr);
        Composite buttonComposite = new Composite(mainComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        GridData btnData = new GridData(90, 25);
        Button btnGenerate = new Button(buttonComposite, 8);
        btnGenerate.setText("Generate");
        btnGenerate.setFont(this.font_bold);
        this.setButtonLayoutData(btnGenerate);
        btnGenerate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UploadUsersDialog.this.requestImportUser();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnClear = new Button(buttonComposite, 8);
        btnClear.setText("Clear");
        btnClear.setLayoutData((Object)btnData);
        btnClear.setFont(this.font_bold);
        this.setButtonLayoutData(btnClear);
        btnClear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UploadUsersDialog.this.clear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(buttonComposite, 1, "Cancel", false).setFont(this.font_bold);
        this.requestProgramsList();
        this.showScreen();
        return super.createDialogArea(parent);
    }

    public boolean fieldValidation() {
        if (this.txtOpening.getText() == null || this.txtOpening.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Opening cash deposit cannot be zero");
            return false;
        }
        if (this.txtInterestRate.getText() == null || this.txtInterestRate.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Interest Rate cannot be blank");
            return false;
        }
        if (this.txtPostFix.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Post Fix cannot be blank");
            return false;
        }
        if (this.txtPostFix.getText().length() < 4 || this.txtPostFix.getText().length() > 4) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Post Fix must be of 4 characters");
            return false;
        }
        if (this.txtFile.getText() == null || this.txtFile.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Please select a File");
            return false;
        }
        if (this.txtUserExpiry == null || this.txtUserExpiry.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Please Enter User Expiry Date");
            return false;
        }
        return true;
    }

    public void showScreen() {
        if (Resources.progResponse == null || Resources.progResponse.length == 0) {
            return;
        }
        try {
            this.lstProgram = new String[Resources.progResponse.length];
            String[] traderCodes = new String[Resources.progResponse.length];
            String traderProgram = "";
            int i = 0;
            while (i < Resources.progResponse.length) {
                int loggedInTrader;
                int traderCode;
                this.lstProgram[i] = Resources.progResponse[i].getProgramName();
                traderCodes[i] = Resources.progResponse[i].getTraderCode();
                if (Resources.userType == 3 && (traderCode = Integer.parseInt(traderCodes[i])) == (loggedInTrader = Integer.parseInt(Resources.traderId))) {
                    traderProgram = this.lstProgram[i];
                    break;
                }
                ++i;
            }
            this.cmbProgm.removeAll();
            if (Resources.userType == 3) {
                this.cmbProgm.add(traderProgram);
            } else if (Resources.userType == 0) {
                i = 0;
                while (i < this.lstProgram.length) {
                    this.cmbProgm.add(this.lstProgram[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cmbProgm.select(0);
    }

    public void requestProgramsList() {
        try {
            String traderCode = Resources.traderId;
            String userId = Resources.userId;
            if (Resources.userType == 0 || Resources.userType == 3) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new ProgramsRequest(traderCode, userId));
                }
            } else {
                MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Only Administrators or Traders are allowed this operation.");
            }
        }
        catch (Exception e) {
            System.out.println("requestUserListing():" + e);
            e.printStackTrace();
        }
    }

    private String getTraderCode(String program) {
        String traderCode = "";
        int i = 0;
        while (i < Resources.progResponse.length) {
            String program1 = Resources.progResponse[i].getProgramName();
            if (program1.equals(program)) {
                traderCode = Resources.progResponse[i].getTraderCode();
                break;
            }
            ++i;
        }
        return traderCode;
    }

    public void requestImportUser() {
        if (this.fieldValidation()) {
            String programName = this.cmbProgm.getText();
            if (programName == null || programName.length() == 0) {
                MessageDialog.openError(null, (String)"Invalid Program", (String)"Please select program");
                return;
            }
            String traderCode = this.getTraderCode(programName);
            double cashDeposit = 0.0;
            cashDeposit = Double.parseDouble(this.txtOpening.getText());
            String userPostFix = this.txtPostFix.getText();
            if (cashDeposit <= 0.0) {
                MessageDialog.openError(null, (String)"Invalid Amount", (String)"Please enter some valid amount");
                return;
            }
            double interestRate = Double.parseDouble(this.txtInterestRate.getText());
            if (this.expiryDate == null) {
                MessageDialog.openError(null, (String)"Invalid Date", (String)"Please enter valid Expiry Date");
                return;
            }
            ArrayList<ImportUserData> UList = this.getUsers();
            if (UList == null) {
                return;
            }
            if (Resources.userType == 0 || Resources.userType == 3) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new ImportUserRequest(UList, traderCode, cashDeposit, interestRate, this.expiryDate, userPostFix));
                }
            } else {
                MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Only Administrators or Traders are allowed this operation.");
            }
            this.clear();
        }
    }

    protected void cancelPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.cancelPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Upload Users");
    }

    public boolean close() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        return super.close();
    }

    public void itemAdded(final Object o) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (o instanceof ImportUserResponse) {
                    ImportUserResponse response = (ImportUserResponse)o;
                    if (response.isUserImported()) {
                        MessageDialog.openInformation(null, (String)"User Creation", (String)"New User has been created Successfully");
                    } else {
                        MessageDialog.openInformation(null, (String)"User Creation", (String)("User could not be created. " + response.getError()));
                    }
                }
            }
        });
    }

    public void itemRemoved(Object o) {
    }

    public Date covertStringToDate(String str) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date date = df.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<ImportUserData> getUsers() {
        ArrayList<ImportUserData> usersList = new ArrayList<ImportUserData>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.txtFile.getText()));
            String contents = br.readLine();
            while (contents != null) {
                String[] token = contents.split(",");
                if (token.length > 0 && token.length < 3) {
                    ImportUserData user = new ImportUserData(token[0], token[1]);
                    usersList.add(user);
                }
                contents = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return usersList;
    }
}

