/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.TransferCustodyRequest;
import pk.com.softech.messages.TransferCustodyResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.NumberVerifyListener;

public class TransferCustodyDialog
extends Dialog
implements ICollectionObserver {
    Font font_bold;
    private Text txtClientCode;
    private Text txtSymbol;
    private Text txtVolume;
    private Text txtCdcAccount;

    public TransferCustodyDialog() {
        super(Display.getDefault().getActiveShell());
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
    }

    protected Control createDialogArea(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        GridLayout grid = new GridLayout();
        grid.marginTop = 2;
        mainComposite.setLayout((Layout)grid);
        Group composite = new Group(mainComposite, 0);
        composite.setFont(this.font_bold);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblClientCode = new Label((Composite)composite, 0);
        lblClientCode.setText("Client Code");
        lblClientCode.setFont(this.font_bold);
        this.txtClientCode = new Text((Composite)composite, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(60), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        new Label((Composite)composite, 0);
        new Label((Composite)composite, 0);
        Label lblSymbol = new Label((Composite)composite, 0);
        lblSymbol.setText("Symbol");
        lblSymbol.setFont(this.font_bold);
        this.txtSymbol = new Text((Composite)composite, 2048);
        this.txtSymbol.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(60), -1));
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        new Label((Composite)composite, 0);
        new Label((Composite)composite, 0);
        Label lblVolume = new Label((Composite)composite, 0);
        lblVolume.setText("Volume");
        lblVolume.setFont(this.font_bold);
        this.txtVolume = new Text((Composite)composite, 2048);
        this.txtVolume.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(60), -1));
        this.txtVolume.addVerifyListener((VerifyListener)new NumberVerifyListener());
        new Label((Composite)composite, 0);
        new Label((Composite)composite, 0);
        Label lblCdcAccount = new Label((Composite)composite, 0);
        lblCdcAccount.setText("CDC Investor Act");
        lblCdcAccount.setFont(this.font_bold);
        this.txtCdcAccount = new Text((Composite)composite, 2048);
        this.txtCdcAccount.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(60), -1));
        this.txtCdcAccount.addVerifyListener((VerifyListener)new CapitalTextListener());
        new Label(mainComposite, 0);
        Composite buttonComposite = new Composite(mainComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.createButton(buttonComposite, 0, "Submit", false).setFont(this.font_bold);
        this.createButton(buttonComposite, 1, "Cancel", false).setFont(this.font_bold);
        return super.createDialogArea(parent);
    }

    public void clear() {
        if (this.txtClientCode.isEnabled()) {
            this.txtClientCode.setText("");
        }
        this.txtSymbol.setText("");
        this.txtVolume.setText("");
        this.txtCdcAccount.setText("");
    }

    public boolean fieldValidation() {
        if (this.txtClientCode.isEnabled() && (this.txtClientCode.getText() == null || this.txtClientCode.getText().equals(""))) {
            MessageDialog.openInformation(null, (String)"Tranfer Custody", (String)"Invalid Request: Please enter client code.");
            return false;
        }
        if (this.txtSymbol.getText() == null || this.txtSymbol.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Tranfer Custody", (String)"Invalid Request: Please enter symbol.");
            return false;
        }
        if (this.txtVolume == null || this.txtVolume.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Tranfer Custody", (String)"Invalid Request: Please enter volume.");
            return false;
        }
        if (this.txtCdcAccount == null || this.txtCdcAccount.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Tranfer Custody", (String)"Invalid Request: Please enter CDC Investor Account No.");
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (this.fieldValidation()) {
            int volume = Integer.parseInt(this.txtVolume.getText());
            if (volume == 0) {
                MessageDialog.openError(null, (String)"Tranfer Custody", (String)"Invalid Request: Invalid volume.");
                return;
            }
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new TransferCustodyRequest(this.txtClientCode.getText(), this.txtSymbol.getText(), volume, this.txtCdcAccount.getText()));
            }
            this.clear();
        }
    }

    protected void cancelPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.cancelPressed();
    }

    public boolean close() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Transfer Custody");
    }

    protected Point getInitialSize() {
        return new Point(385, 295);
    }

    public void itemAdded(final Object o) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (o instanceof TransferCustodyResponse) {
                    TransferCustodyResponse response = (TransferCustodyResponse)o;
                    try {
                        int action = response.getAction();
                        if (action == 1) {
                            MessageDialog.openInformation(null, (String)"Tranfer Custody", (String)response.getRemarks());
                        } else if (action == 2) {
                            MessageDialog.openError(null, (String)"Tranfer Custody", (String)response.getRemarks());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void itemRemoved(Object o) {
    }
}

