/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import pk.com.softech.messages.NotificationRequest;
import pk.com.softech.messages.NotificationResponse;
import pk.com.softech.tradingterminal.admin.dialog.TradeConfirmPage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;

public class TradeConfirmWizard
extends Wizard
implements ICollectionObserver {
    private TradeConfirmPage page;
    private NotificationResponse response;
    private boolean finish = false;

    public TradeConfirmWizard() {
        this.setWindowTitle("Sent Trade Confirmations");
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void addPages() {
        this.page = new TradeConfirmPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performCancel() {
        return true;
    }

    public void dispose() {
        super.dispose();
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
    }

    public void itemAdded(Object obj) {
        if (obj instanceof NotificationResponse) {
            this.response = (NotificationResponse)obj;
        }
    }

    public void itemRemoved(Object o) {
    }

    public boolean performFinish() {
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            String clientCode = this.page.getClientCode();
            Date date = Utility.getDate((String)this.page.getDate());
            if (date != null) {
                NotificationRequest req = new NotificationRequest(clientCode, date);
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)req);
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (TradeConfirmWizard.this.response == null) {
                            System.out.println("NotificationResponse is null in TradeConfirmationWizard");
                        } else {
                            if (TradeConfirmWizard.this.response.getAction() == 1) {
                                MessageDialog.openInformation(null, (String)"Trade Confirmation Response", (String)TradeConfirmWizard.this.response.getRemarks());
                                TradeConfirmWizard.this.finish = true;
                            } else {
                                MessageDialog.openError(null, (String)"Trade Confirmation Response", (String)TradeConfirmWizard.this.response.getRemarks());
                                TradeConfirmWizard.this.page.resedValues();
                            }
                            TradeConfirmWizard.this.response = null;
                        }
                    }
                });
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Parameters", (String)("Invalid date pattern. Expected : " + CorePlugin.getDateParse().toPattern()));
            }
        }
        return this.finish;
    }
}

