/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.ReloadMessagesCommand;
import pk.com.softech.tradingterminal.core.Resources;

public class ReloadMessagesDialog
extends Dialog {
    private static final int BUTTON_WIDTH = 75;
    private static final int BUTTON_HEIGHT = 22;
    private int interval = 180000;
    private Group grpExecute;
    Composite parent;
    Button btnExecute;
    Composite content;

    public ReloadMessagesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Reload Messages");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        GridData btnGridData = new GridData(75, 22);
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        this.grpExecute = new Group(this.content, 16);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)this.grpExecute);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, 50).hint(100, -1).applyTo((Control)this.grpExecute);
        this.btnExecute = this.createButton((Composite)this.grpExecute, btnGridData);
        this.btnExecute.setText("  Execute  ");
        this.btnExecute.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReloadMessagesDialog.this.reloadMessages();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return this.content;
    }

    private Button createButton(Composite parent, GridData gridData) {
        Button temp = new Button(parent, 8);
        temp.setLayoutData((Object)gridData);
        return temp;
    }

    private void reloadMessages() {
        boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Reload Messages", (String)"This option reloads order/trade messages, ignores already received confirmations\nand sends missing ones to the client. Do you want to continue with the option?");
        if (confirm) {
            try {
                this.btnExecute.setEnabled(false);
                Cursor cursorWait = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 1);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorWait);
                this.parent.getDisplay().timerExec(this.interval, new Runnable(){

                    @Override
                    public void run() {
                        if (!ReloadMessagesDialog.this.parent.isDisposed()) {
                            Cursor cursorDefault = new Cursor((Device)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), 0);
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(cursorDefault);
                            ReloadMessagesDialog.this.btnExecute.setEnabled(true);
                        }
                    }
                });
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new ReloadMessagesCommand(0));
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }
}

