/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import java.util.Date;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.MarginNotificationsData;
import pk.com.softech.messages.MarginNotificationsResponse;
import pk.com.softech.messages.NetOffMarginResponse;
import pk.com.softech.tradingterminal.admin.Activator;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.ProductNames;

public class MarginNetOffNotificationDialog
extends Dialog {
    private static final int LABEL_WIDTH = 60;
    private static final int LABEL_HEIGHT = 22;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 22;
    private static final int TEXT_WIDTH = 80;
    private static final int TEXT_HEIGHT = 15;
    public static final String PREFS_NOTIFICATION_DIALOG_COLUMNS_SIZE = "PREFS_NOTIFICATION_DIALOG_COLUMNS_SIZE";
    private EnumFiterType actFilter = EnumFiterType.CLIENT;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    Composite parent;
    Table table_acc = null;
    Composite content;
    Text txtFilterItem;
    private boolean sendNotification;
    Button cbxSelectAll;
    MarginNotificationsData[] data;
    Button btnCalulateMargin;
    Button btnSendNotification;
    private MarginNotificationsResponse notificationsResponse;
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < MarginNetOffNotificationDialog.this.table_acc.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(MarginNetOffNotificationDialog.this.table_acc.getColumn(i).getWidth())) + ";");
                ++i;
            }
            Activator.getDefault().getPreferenceStore().setValue(MarginNetOffNotificationDialog.PREFS_NOTIFICATION_DIALOG_COLUMNS_SIZE, sizes.toString());
        }
    };
    private Button btnResizeColumn;
    FontMetrics fontMetrics;

    protected boolean isResizable() {
        return true;
    }

    public MarginNetOffNotificationDialog(Shell parentShell, MarginNotificationsData[] data) {
        super(parentShell);
        this.data = data;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Margin Net Off");
        super.configureShell(newShell);
        newShell.setSize(800, 500);
    }

    public boolean close() {
        Shell shell = Display.getCurrent().getActiveShell();
        shell.getParent().dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData btnGridData = new GridData(16384, 1024, true, false);
        btnGridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15);
        GridData txtGridData = new GridData(4, 1024, true, false);
        txtGridData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)20);
        this.content = new Composite(parent, 0);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.content.setLayout((Layout)new GridLayout(1, false));
        Composite compositeHead = new Composite(this.content, 0);
        compositeHead.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        compositeHead.setLayout((Layout)new GridLayout(3, false));
        Composite compositeSubHead = new Composite(this.content, 0);
        compositeSubHead.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        compositeSubHead.setLayout((Layout)new GridLayout(5, false));
        Composite compositeBody = new Composite(this.content, 0);
        compositeBody.setLayoutData((Object)new GridData(4, 4, true, true));
        compositeBody.setLayout((Layout)new GridLayout(1, true));
        Label lblPrompt = new Label(compositeHead, 0);
        lblPrompt.setText("Do you want to continue with these notifications?");
        Button btnContinue = new Button(compositeHead, 8);
        btnContinue.setText("Continue");
        btnContinue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarginNetOffNotificationDialog.this.sendRequest(true);
                Display.getCurrent().getActiveShell().dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnAbort = new Button(compositeHead, 8);
        btnAbort.setText("Abort");
        btnAbort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                shell.getParent().dispose();
                shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnRadioClientCode = new Button(compositeSubHead, 16);
        btnRadioClientCode.setText(EnumFiterType.CLIENT.toString());
        this.setSearchActiveFilter(btnRadioClientCode);
        btnRadioClientCode.setSelection(true);
        Button btnRadioBranch = new Button(compositeSubHead, 16);
        btnRadioBranch.setText(EnumFiterType.BRANCH.toString());
        this.setSearchActiveFilter(btnRadioBranch);
        Button btnRadioTrader = new Button(compositeSubHead, 16);
        btnRadioTrader.setText(EnumFiterType.TRADER.toString());
        this.setSearchActiveFilter(btnRadioTrader);
        this.txtFilterItem = new Text(compositeSubHead, 2048);
        this.txtFilterItem.setEnabled(true);
        this.txtFilterItem.setLayoutData((Object)txtGridData);
        this.txtFilterItem.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtFilterItem.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    MarginNetOffNotificationDialog.this.searchByActiveFilter();
                }
            }
        });
        Button btnSearch = new Button(compositeSubHead, 8);
        btnSearch.setText("Search");
        btnSearch.setLayoutData((Object)btnGridData);
        btnSearch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarginNetOffNotificationDialog.this.searchByActiveFilter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cbxSelectAll = new Button(compositeSubHead, 32);
        this.cbxSelectAll.setText("Select All");
        this.cbxSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarginNetOffNotificationDialog.this.selectAllCheckboxes();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnResizeColumn = new Button(compositeSubHead, 8);
        this.btnResizeColumn.setText("Reset Table");
        this.btnResizeColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarginNetOffNotificationDialog.this.resizeTableColumn();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table_acc = new Table(compositeBody, 68386);
        this.table_acc.setHeaderVisible(true);
        this.table_acc.setLinesVisible(true);
        this.table_acc.setLayoutData((Object)new GridData(1808));
        TableColumn column = new TableColumn(this.table_acc, 0);
        column.setText("Send");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Client Code");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Client Name");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Branch");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Trader");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Email");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("CC");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Margin Req");
        column = new TableColumn(this.table_acc, 0);
        column.setText("Margin %");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Cash Call");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Margin Call");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("cash Reg");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Last Call Time");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Calls Sent");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table_acc, 0);
        column.setText("Exchange");
        column.addControlListener(this.columnControlListener);
        String[] sizes = Activator.getDefault().getPreferenceStore().getString(PREFS_NOTIFICATION_DIALOG_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < this.table_acc.getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                this.table_acc.getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                this.table_acc.getColumn(i).setWidth(100);
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            this.table_acc.getColumn(this.table_acc.getColumnCount() - 1).pack();
        }
        this.setDataValues(this.data);
        return parent;
    }

    private void setSearchActiveFilter(Button btn) {
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    String btnPressText = source.getText();
                    if (btnPressText.equalsIgnoreCase(EnumFiterType.CLIENT.toString())) {
                        MarginNetOffNotificationDialog.this.actFilter = EnumFiterType.CLIENT;
                    } else if (btnPressText.equalsIgnoreCase(EnumFiterType.TRADER.toString())) {
                        MarginNetOffNotificationDialog.this.actFilter = EnumFiterType.TRADER;
                    } else if (btnPressText.equalsIgnoreCase(EnumFiterType.BRANCH.toString())) {
                        MarginNetOffNotificationDialog.this.actFilter = EnumFiterType.BRANCH;
                    }
                    MarginNetOffNotificationDialog.this.logger.info((Object)("Radio Press:" + (Object)((Object)MarginNetOffNotificationDialog.this.actFilter)));
                }
            }
        });
    }

    private void searchByActiveFilter() {
        if (this.actFilter == EnumFiterType.CLIENT) {
            this.searchClients();
        } else if (this.actFilter == EnumFiterType.TRADER) {
            this.searchTrader();
        } else if (this.actFilter == EnumFiterType.BRANCH) {
            this.searchBranch();
        }
    }

    protected void sendRequest(boolean option) {
        this.sendNotification = option;
        Vector<MarginNotificationsData> dataVector = new Vector<MarginNotificationsData>();
        if (this.sendNotification) {
            TableItem[] item = this.table_acc.getItems();
            int i = 0;
            while (i < item.length) {
                boolean sendNotify = item[i].getChecked();
                if (sendNotify) {
                    String currentMargin;
                    String email2;
                    String email;
                    String clientTrader;
                    String clientBranch;
                    String clientName;
                    String clientCode = item[i].getText(1);
                    if (clientCode == null) {
                        clientCode = "";
                    }
                    if ((clientName = item[i].getText(2)) == null) {
                        clientName = "";
                    }
                    if ((clientBranch = item[i].getText(3)) == null) {
                        clientBranch = "";
                    }
                    if ((clientTrader = item[i].getText(4)) == null) {
                        clientTrader = "";
                    }
                    if ((email = item[i].getText(5)) == null) {
                        email = "";
                    }
                    if ((email2 = item[i].getText(6)) == null) {
                        email2 = "";
                    }
                    float currentMargin0 = (currentMargin = item[i].getText(7)) == null || currentMargin.equals("") ? 0.0f : Float.parseFloat(currentMargin);
                    String currentMarginPerc = item[i].getText(8);
                    float currentMarginPerc0 = currentMarginPerc == null || currentMarginPerc.equals("") ? 0.0f : Float.parseFloat(currentMarginPerc);
                    String shortAmount = item[i].getText(9);
                    float shortAmount0 = shortAmount == null || shortAmount.equals("") ? 0.0f : Float.parseFloat(shortAmount);
                    String lastMargin = item[i].getText(10);
                    float lastMargin0 = lastMargin == null || lastMargin.equals("") ? 0.0f : Float.parseFloat(lastMargin);
                    String lastCash = item[i].getText(11);
                    float lastCash0 = lastCash == null || lastCash.equals("") ? 0.0f : Float.parseFloat(lastCash);
                    String callsSent = item[i].getText(13);
                    int callsSent0 = callsSent == null || callsSent.equals("") ? 0 : Integer.parseInt(callsSent);
                    String stExCode = item[i].getText(14);
                    if (stExCode == null) {
                        stExCode = "";
                    }
                    dataVector.add(new MarginNotificationsData(clientCode, clientName, email, currentMargin0, lastMargin0, lastCash0, null, callsSent0, shortAmount0, email2, stExCode, currentMarginPerc0, clientBranch, clientTrader));
                }
                ++i;
            }
            if (dataVector.size() > 0) {
                MarginNotificationsData[] data = new MarginNotificationsData[dataVector.size()];
                int j = 0;
                while (j < dataVector.size()) {
                    data[j] = (MarginNotificationsData)dataVector.get(j);
                    ++j;
                }
                this.notificationsResponse = new MarginNotificationsResponse(data, "");
                if (this.getSendNotifications() && this.getNotificationsResponse() != null) {
                    if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                        if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT) {
                            if (Resources.getServerLink((String)data[0].getClient(), (boolean)true, (boolean)false) != null && Resources.getServerLink((String)data[0].getClient(), (boolean)true, (boolean)false).writeData((Object)this.getNotificationsResponse())) {
                                this.logger.info((Object)("Sending Email Notifications request for Client = " + this.txtFilterItem.getText()));
                            }
                        } else {
                            Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)this.getNotificationsResponse());
                        }
                    } else {
                        Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)this.getNotificationsResponse());
                    }
                }
            }
        }
    }

    public boolean getSendNotifications() {
        return this.sendNotification;
    }

    public MarginNotificationsResponse getNotificationsResponse() {
        return this.notificationsResponse;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof NetOffMarginResponse) {
                        NetOffMarginResponse rsp = (NetOffMarginResponse)o;
                        MarginNetOffNotificationDialog.this.recieveMarginNetOffResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void selectAllCheckboxes() {
        if (this.cbxSelectAll.getSelection()) {
            TableItem[] item = this.table_acc.getItems();
            int i = 0;
            while (i < item.length) {
                item[i].setChecked(true);
                ++i;
            }
        } else {
            TableItem[] item = this.table_acc.getItems();
            int i = 0;
            while (i < item.length) {
                item[i].setChecked(false);
                ++i;
            }
        }
    }

    public void setDataValues(MarginNotificationsData[] data) {
        this.table_acc.removeAll();
        MarginNotificationsData[] tempData = data;
        this.cbxSelectAll.setSelection(true);
        if (tempData != null) {
            int i = 0;
            while (i < tempData.length) {
                String searchForItem = this.txtFilterItem.getText().trim();
                String searchIn = "";
                switch (this.actFilter) {
                    case CLIENT: {
                        if (tempData[i].getClient() == null) break;
                        searchIn = tempData[i].getClient().trim();
                        break;
                    }
                    case BRANCH: {
                        if (tempData[i].getClientBranch() == null) break;
                        searchIn = tempData[i].getClientBranch().trim();
                        break;
                    }
                    case TRADER: {
                        if (tempData[i].getTraderName() == null) break;
                        searchIn = tempData[i].getTraderName().trim();
                        break;
                    }
                    default: {
                        searchIn = tempData[i].getClient().trim();
                    }
                }
                if (searchForItem.equals("") || searchIn.lastIndexOf(searchForItem) != -1) {
                    TableItem item = new TableItem(this.table_acc, 0);
                    item.setChecked(true);
                    item.setText(0, "");
                    if (tempData[i].getClient() != null) {
                        item.setText(1, tempData[i].getClient().toUpperCase());
                    } else {
                        item.setText(1, "");
                    }
                    if (tempData[i].getClientName() != null) {
                        item.setText(2, tempData[i].getClientName().toUpperCase());
                    } else {
                        item.setText(2, "");
                    }
                    if (tempData[i].getClientBranch() != null) {
                        item.setText(3, tempData[i].getClientBranch().toUpperCase());
                    } else {
                        item.setText(3, "");
                    }
                    if (tempData[i].getTraderName() != null) {
                        item.setText(4, tempData[i].getTraderName().toUpperCase());
                    } else {
                        item.setText(4, "");
                    }
                    if (tempData[i].getClientEmail() != null) {
                        item.setText(5, tempData[i].getClientEmail());
                    } else {
                        item.setText(5, "");
                    }
                    if (tempData[i].getClientEmail2() != null) {
                        item.setText(6, tempData[i].getClientEmail2());
                    } else {
                        item.setText(6, "");
                    }
                    if ((double)tempData[i].getCurrentMargin() != 0.0) {
                        item.setText(7, String.valueOf(tempData[i].getCurrentMargin()));
                    } else {
                        item.setText(7, "");
                    }
                    if ((double)tempData[i].getMarginPercentage() != 0.0) {
                        item.setText(8, String.valueOf(tempData[i].getMarginPercentage()));
                    } else {
                        item.setText(8, "");
                    }
                    if ((double)tempData[i].getShortAmt() != 0.0) {
                        item.setText(9, String.valueOf(tempData[i].getShortAmt()));
                    } else {
                        item.setText(9, "");
                    }
                    if ((double)tempData[i].getLastCallMargin() != 0.0) {
                        item.setText(10, String.valueOf(tempData[i].getLastCallMargin()));
                    } else {
                        item.setText(10, "");
                    }
                    if ((double)tempData[i].getLastCallCash() != 0.0) {
                        item.setText(11, String.valueOf(tempData[i].getLastCallCash()));
                    } else {
                        item.setText(11, "");
                    }
                    if (tempData[i].getLastCallTime() != null) {
                        item.setText(12, Utility.getTimeString((Date)tempData[i].getLastCallTime()));
                    } else {
                        item.setText(12, "");
                    }
                    if ((double)tempData[i].getCallsSent() != 0.0) {
                        item.setText(13, String.valueOf(tempData[i].getCallsSent()));
                    } else {
                        item.setText(13, "");
                    }
                    if (tempData[i].getStExCode() != null) {
                        item.setText(14, tempData[i].getStExCode());
                    } else {
                        item.setText(14, "");
                    }
                }
                ++i;
            }
        }
    }

    private void searchClients() {
        this.setDataValues(this.data);
        TableItem[] item = this.table_acc.getItems();
        int i = 0;
        while (i < item.length) {
            String searchForItem = this.txtFilterItem.getText().trim();
            String searchIn = item[i].getText(1).trim();
            if (!searchForItem.equals("") && searchIn.lastIndexOf(searchForItem) == -1) {
                item[i].dispose();
            }
            ++i;
        }
    }

    private void searchBranch() {
        this.setDataValues(this.data);
        TableItem[] item = this.table_acc.getItems();
        int i = 0;
        while (i < item.length) {
            String searchForItem = this.txtFilterItem.getText().trim();
            String searchIn = item[i].getText(3).trim();
            if (!searchForItem.equals("") && searchIn.lastIndexOf(searchForItem) == -1) {
                item[i].dispose();
            }
            ++i;
        }
    }

    private void searchTrader() {
        this.setDataValues(this.data);
        TableItem[] item = this.table_acc.getItems();
        int i = 0;
        while (i < item.length) {
            String searchForItem = this.txtFilterItem.getText().trim();
            String searchIn = item[i].getText(4).trim();
            if (!searchForItem.equals("") && searchIn.lastIndexOf(searchForItem) == -1) {
                item[i].dispose();
            }
            ++i;
        }
    }

    protected void resizeTableColumn() {
        Integer i = 0;
        while (i < this.table_acc.getColumnCount()) {
            Integer width = this.table_acc.getColumn(i.intValue()).getWidth();
            if (!(i != 0 && i != 7 && i != 8 && i != 9 && i != 10 && i != 11 && i != 14 && i != 15 || width >= 50 && width <= 50)) {
                this.table_acc.getColumn(i.intValue()).setWidth(50);
            } else if (width < 75) {
                this.table_acc.getColumn(i.intValue()).setWidth(75);
            }
            i = i + 1;
        }
    }

    public void recieveMarginNetOffResponse(final NetOffMarginResponse resp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int action = resp.getAction();
                if (action == 1) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Margin Net Off", (String)resp.getRemarks());
                } else if (action == 2) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Margin Net Off", (String)resp.getRemarks());
                }
            }
        });
    }

    private static enum EnumFiterType {
        CLIENT("Client"),
        TRADER("Trader"),
        BRANCH("Branch");

        private final String text;

        private EnumFiterType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

