/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.MarginNotificationsData;
import pk.com.softech.messages.MarginNotificationsRequest;
import pk.com.softech.messages.MarginNotificationsResponse;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.NetOffMarginRequest;
import pk.com.softech.messages.NetOffMarginResponse;
import pk.com.softech.tradingterminal.admin.dialog.MarginNetOffNotificationDialog;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.util.ProductNames;

public class MarginNetOffDialog
extends Dialog
implements ICollectionObserver {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    Composite parent;
    Composite content;
    Button btnCalulateMargin;
    Button btnSendNotification;
    private FontMetrics fontMetrics = null;

    public MarginNetOffDialog(Shell parentShell) {
        super(parentShell);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Margin Net Off");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData btnGridData = new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1);
        GridData btnGridDataTwoCol = new GridData(4, 4, true, true, 2, 1);
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, true));
        this.btnCalulateMargin = new Button(composite, 16);
        this.btnCalulateMargin.setText("Calculate client margin positions");
        this.btnCalulateMargin.setLayoutData((Object)btnGridDataTwoCol);
        this.btnSendNotification = new Button(composite, 16);
        this.btnSendNotification.setText("Send email notifications to clients");
        this.btnSendNotification.setLayoutData((Object)btnGridDataTwoCol);
        Button btnExecute = new Button(composite, 8);
        btnExecute.setText("Execute");
        btnExecute.setLayoutData((Object)btnGridData);
        btnExecute.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarginNetOffDialog.this.sendRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnCancel = new Button(composite, 8);
        btnCancel.setText("Cancel");
        btnCancel.setLayoutData((Object)btnGridData);
        btnCancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Display.getCurrent().getActiveShell().dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return this.content;
    }

    protected void sendRequest() {
        if (this.btnCalulateMargin.getSelection()) {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                NetOffMarginRequest request = new NetOffMarginRequest(1);
                if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT) {
                    if (Resources.sendToAllMS((Message)request)) {
                        this.logger.info((Object)"Sending Net off Margin request ");
                    }
                } else {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
                }
            }
        } else if (this.btnSendNotification.getSelection()) {
            try {
                MarginNotificationsRequest mnr = new MarginNotificationsRequest();
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)mnr);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof NetOffMarginResponse) {
                        NetOffMarginResponse rsp = (NetOffMarginResponse)o;
                        MarginNetOffDialog.this.recieveMarginNetOffResponse(rsp);
                    } else if (o instanceof MarginNotificationsResponse) {
                        MarginNotificationsResponse resp = (MarginNotificationsResponse)o;
                        MarginNetOffDialog.this.recieveMarginNotificationResponse(resp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void recieveMarginNotificationResponse(final MarginNotificationsResponse resp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MarginNotificationsData[] data = resp.getRows();
                MarginNetOffNotificationDialog dialog = new MarginNetOffNotificationDialog(Display.getCurrent().getActiveShell(), data);
                dialog.open();
            }
        });
    }

    public void recieveMarginNetOffResponse(final NetOffMarginResponse resp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int action = resp.getAction();
                if (action == 1) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Margin Net Off", (String)resp.getRemarks());
                } else if (action == 2) {
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Margin Net Off", (String)resp.getRemarks());
                }
            }
        });
    }
}

