/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.LiquidateHoldingRequest;
import pk.com.softech.messages.LiquidateHoldingResponse;
import pk.com.softech.messages.ProgramsData;
import pk.com.softech.messages.ProgramsRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;

public class LiquidateStockDialog
extends Dialog
implements ICollectionObserver {
    Text txtStatus;
    public Color alert_danger_fg;
    public Color alert_success_fg;
    private Logger logger = Logger.getLogger(LiquidateStockDialog.class);
    private ComboViewer comboViewerBatch;
    private Combo cmbBatch;
    private Font font_bold_18;
    private Color alert_primary_fg;
    private Text txtDate;
    private Button btnSetDate;
    private LiquidateHoldingRequest liquidateRequest;
    public ProgramsData curPurogram;
    private Button btnLiquidate;
    private static final DateFormat df = new SimpleDateFormat("MM/dd/yyyy");
    public Date curDate;

    public LiquidateStockDialog() {
        super(Display.getDefault().getActiveShell());
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.createButton(parent, 1, "Cancel", false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.alert_success_fg = new Color(null, 139, 195, 74);
        this.alert_danger_fg = new Color(null, 217, 48, 37);
        area.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Resources.progResponse == null) {
                        LiquidateStockDialog.this.requestProgramsList();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.alert_primary_fg = new Color(null, 52, 99, 183);
        this.font_bold_18 = WidgetFactory.font_registry.get("FONT_18_BOLD");
        Label labelHead = new Label(composite, 0);
        labelHead.setFont(this.font_bold_18);
        labelHead.setForeground(this.alert_primary_fg);
        labelHead.setText("Stock Liquidation Request");
        Composite centerComposite = new Composite(composite, 0);
        centerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        centerComposite.setLayout((Layout)new GridLayout(3, false));
        new GridData(100, 15);
        GridData twoSpanGridData = new GridData();
        twoSpanGridData.grabExcessHorizontalSpace = true;
        twoSpanGridData.grabExcessVerticalSpace = false;
        twoSpanGridData.horizontalSpan = 2;
        twoSpanGridData.widthHint = 200;
        twoSpanGridData.heightHint = 22;
        this.liquidateRequest = new LiquidateHoldingRequest();
        this.txtDate = new Text(centerComposite, 8);
        this.txtDate.setLayoutData((Object)twoSpanGridData);
        this.curDate = Resources.systemDate;
        this.txtDate.setText(df.format(this.curDate));
        this.liquidateRequest.setDate(this.curDate);
        this.btnSetDate = new Button(centerComposite, 8);
        this.btnSetDate.setText("Date");
        this.btnSetDate.setLayoutData((Object)new GridData(4, 4, false, false));
        this.comboViewerBatch = new ComboViewer(centerComposite, 8);
        this.comboViewerBatch.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewerBatch.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ProgramsData)element).getProgramName();
            }
        });
        this.cmbBatch = this.comboViewerBatch.getCombo();
        this.cmbBatch.setLayoutData((Object)twoSpanGridData);
        this.comboViewerBatch.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LiquidateStockDialog.this.txtStatus.setText("");
                IStructuredSelection selectionObject = (IStructuredSelection)event.getSelection();
                Object o = selectionObject.getFirstElement();
                LiquidateStockDialog.this.curPurogram = (ProgramsData)o;
            }
        });
        this.btnLiquidate = new Button(centerComposite, 8);
        this.btnLiquidate.setText("Liquidate Stock");
        this.btnLiquidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LiquidateStockDialog.this.okPressed();
            }
        });
        GridData gridThreeSpan = new GridData();
        gridThreeSpan.grabExcessHorizontalSpace = false;
        gridThreeSpan.horizontalSpan = 3;
        gridThreeSpan.widthHint = 343;
        gridThreeSpan.heightHint = 20;
        new Label(centerComposite, 0);
        this.txtStatus = new Text(centerComposite, 8);
        this.txtStatus.setLayoutData((Object)gridThreeSpan);
        this.btnSetDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                String cfr_ignored_0 = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = this.covertStringToDate(dateString);
                        if (LiquidateStockDialog.this.liquidateRequest == null) {
                            LiquidateStockDialog.this.liquidateRequest = new LiquidateHoldingRequest();
                        }
                        LiquidateStockDialog.this.liquidateRequest.setDate(cDate);
                        LiquidateStockDialog.this.txtDate.setText(dateString);
                        dialog.close();
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }

            public Date covertStringToDate(String str) {
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
                try {
                    Date date = df.parse(str);
                    return date;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        area.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Resources.progResponse != null) {
                        LiquidateStockDialog.this.comboViewerBatch.setInput((Object)Resources.progResponse);
                    } else {
                        LiquidateStockDialog.this.requestProgramsList();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        return area;
    }

    public void requestProgramsList() {
        try {
            if (Resources.getServerLink((String)"", (boolean)true, (boolean)false).writeData((Object)new ProgramsRequest())) {
                this.logger.info((Object)"No Program Fetched, Because server is not connected");
            }
        }
        catch (Exception e) {
            this.logger.info((Object)("Program Fetched Exception" + e.getMessage()));
        }
    }

    protected void cancelPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.cancelPressed();
    }

    public boolean close() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        return super.close();
    }

    protected void okPressed() {
        this.btnLiquidate.setEnabled(false);
        if (this.curPurogram != null) {
            this.liquidateRequest.setProgram(this.curPurogram);
            Date date = this.liquidateRequest.getDate();
            if (date == null) {
                this.liquidateRequest.setDate(this.curDate);
            }
            if (Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)this.liquidateRequest)) {
                this.logger.info((Object)"Liquidate Request has been sent!");
                this.txtStatus.setText("Liquidate Request has been sent!");
                this.txtStatus.setForeground(this.alert_success_fg);
                this.txtStatus.setEnabled(false);
            } else {
                this.logger.info((Object)"NO Server Link For Liquidate Request sending!");
                this.txtStatus.setText("NO Server Link For Liquidate Request sending!");
                this.txtStatus.setForeground(this.alert_danger_fg);
            }
        } else {
            this.btnLiquidate.setEnabled(true);
            MessageDialog.openError(null, (String)"Invalid Form Fill", (String)"Please Provide Program Selection!");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Liquidate Stock");
    }

    protected Point getInitialSize() {
        return new Point(400, 260);
    }

    public void itemAdded(final Object o) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (o instanceof LiquidateHoldingResponse) {
                    LiquidateHoldingResponse response = (LiquidateHoldingResponse)o;
                    if (response.isStatus()) {
                        LiquidateStockDialog.this.txtStatus.setText("Confirmation Liquidate Stock Posted Successfully");
                        LiquidateStockDialog.this.txtStatus.setForeground(LiquidateStockDialog.this.alert_success_fg);
                    } else {
                        LiquidateStockDialog.this.txtStatus.setText("Confirmation Liquidate Stock Service Not Available!");
                        LiquidateStockDialog.this.txtStatus.setForeground(LiquidateStockDialog.this.alert_danger_fg);
                    }
                    LiquidateStockDialog.this.btnLiquidate.setEnabled(true);
                }
            }
        });
    }

    public void itemRemoved(Object o) {
    }
}

