/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.GenerateUserRequest;
import pk.com.softech.messages.GenerateUserResponse;
import pk.com.softech.messages.ProgramsRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.InterestVerifyListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;

public class GenerateUserDialog
extends Dialog
implements ICollectionObserver {
    Font font_bold;
    Combo cmbUserType;
    Combo cmbProgm;
    Text txtUserId;
    Text txtName;
    Text txtOpening;
    Text txtUserExpiry;
    Text txtInterestRate;
    public Date expiryDate;
    private String[] lstProgram = null;

    public GenerateUserDialog() {
        super(Display.getDefault().getActiveShell());
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
    }

    private void clear() {
        this.txtUserId.setText("");
        this.txtName.setText("");
        this.txtOpening.setText("");
        this.txtInterestRate.setText("");
        this.cmbUserType.select(0);
        this.cmbProgm.select(0);
        this.txtUserExpiry.setText("");
    }

    protected Control createDialogArea(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        mainComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblType = new Label(composite, 0);
        lblType.setText("User Type");
        this.cmbUserType = new Combo(composite, 8);
        this.cmbUserType.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.cmbUserType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GenerateUserDialog.this.cmbUserType != null && GenerateUserDialog.this.cmbUserType.getText().equals("Teacher")) {
                    GenerateUserDialog.this.txtOpening.setText("");
                    GenerateUserDialog.this.txtOpening.setEnabled(false);
                } else {
                    GenerateUserDialog.this.txtOpening.setEnabled(true);
                }
            }
        });
        Label lblId = new Label(composite, 0);
        lblId.setText("User Id");
        this.txtUserId = new Text(composite, 2048);
        this.txtUserId.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        Label lblName = new Label(composite, 0);
        lblName.setText("Name");
        this.txtName = new Text(composite, 2048);
        this.txtName.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtName.addVerifyListener((VerifyListener)new CapitalTextListener());
        Label lblProgm = new Label(composite, 0);
        lblProgm.setText("Program");
        this.cmbProgm = new Combo(composite, 8);
        this.cmbProgm.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        Label lblOpening = new Label(composite, 0);
        lblOpening.setText("Opening Cash Deposit");
        this.txtOpening = new Text(composite, 2048);
        this.txtOpening.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtOpening.addVerifyListener((VerifyListener)new PriceVerifyListener());
        Label lblInterestRate = new Label(composite, 0);
        lblInterestRate.setText("Interest Rate %");
        this.txtInterestRate = new Text(composite, 2048);
        this.txtInterestRate.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtInterestRate.addVerifyListener((VerifyListener)new InterestVerifyListener());
        Composite dateComposite = new Composite(mainComposite, 0);
        dateComposite.setLayout((Layout)new GridLayout(3, false));
        Label lblUserExpiry = new Label(dateComposite, 0);
        lblUserExpiry.setText("User Expiry");
        this.txtUserExpiry = new Text(dateComposite, 2048);
        this.txtUserExpiry.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        this.txtUserExpiry.setEnabled(false);
        Button setDate = new Button(dateComposite, 8);
        setDate.setText("Set Date");
        setDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = GenerateUserDialog.this.covertStringToDate(currentDate);
                        Date sDate = GenerateUserDialog.this.covertStringToDate(dateString);
                        if (sDate.compareTo(cDate) == 1 || sDate.compareTo(cDate) == 0) {
                            (this).GenerateUserDialog.this.txtUserExpiry.setText(dateString);
                            (this).GenerateUserDialog.this.expiryDate = sDate;
                            dialog.close();
                        } else {
                            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid Date");
                            (this).GenerateUserDialog.this.txtUserExpiry.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        Composite buttonComposite = new Composite(mainComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        Button btnGenerate = new Button(buttonComposite, 8);
        btnGenerate.setText("Generate");
        btnGenerate.setFont(this.font_bold);
        this.setButtonLayoutData(btnGenerate);
        btnGenerate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenerateUserDialog.this.requestUserGeneration();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnClear = new Button(buttonComposite, 8);
        btnClear.setText("Clear");
        btnClear.setFont(this.font_bold);
        this.setButtonLayoutData(btnClear);
        btnClear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenerateUserDialog.this.clear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createButton(buttonComposite, 1, "Cancel", false).setFont(this.font_bold);
        this.requestProgramsList();
        this.showScreen();
        return super.createDialogArea(parent);
    }

    public boolean fieldValidation() {
        if (this.txtUserId.getText() == null || this.txtUserId.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"UserId cannot be blank");
            return false;
        }
        if (this.txtName.getText() == null || this.txtName.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Name cannot be blank");
            return false;
        }
        if (this.cmbUserType != null && this.cmbUserType.getText().equals("Student") && (this.txtOpening.getText() == null || this.txtOpening.getText().equals(""))) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Opening cash deposit cannot be zero");
            return false;
        }
        if (this.txtUserExpiry == null || this.txtUserExpiry.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Please Enter User Expiry Date");
            return false;
        }
        if (this.txtInterestRate == null || this.txtInterestRate.getText().equals("")) {
            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Interest Rate cannot be blank");
            return false;
        }
        return true;
    }

    public void showScreen() {
        if (Resources.progResponse == null || Resources.progResponse.length == 0) {
            return;
        }
        try {
            this.lstProgram = new String[Resources.progResponse.length];
            String[] traderCodes = new String[Resources.progResponse.length];
            String traderProgram = "";
            int i = 0;
            while (i < Resources.progResponse.length) {
                int loggedInTrader;
                int traderCode;
                this.lstProgram[i] = Resources.progResponse[i].getProgramName();
                traderCodes[i] = Resources.progResponse[i].getTraderCode();
                if (Resources.userType == 3 && (traderCode = Integer.parseInt(traderCodes[i])) == (loggedInTrader = Integer.parseInt(Resources.traderId))) {
                    traderProgram = this.lstProgram[i];
                    break;
                }
                ++i;
            }
            this.cmbProgm.removeAll();
            if (Resources.userType == 3) {
                this.cmbProgm.add(traderProgram);
                this.cmbUserType.add("Student");
            } else if (Resources.userType == 0) {
                this.cmbUserType.add("Teacher");
                this.cmbUserType.add("Student");
                i = 0;
                while (i < this.lstProgram.length) {
                    this.cmbProgm.add(this.lstProgram[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cmbProgm.select(0);
        this.cmbUserType.select(0);
        if (this.cmbUserType.getText().equals("Teacher")) {
            this.txtOpening.setEnabled(false);
        } else {
            this.txtOpening.setEnabled(true);
        }
    }

    private String getTraderCode(String program) {
        String traderCode = "";
        int i = 0;
        while (i < Resources.progResponse.length) {
            String program1 = Resources.progResponse[i].getProgramName();
            if (program1.equals(program)) {
                traderCode = Resources.progResponse[i].getTraderCode();
                break;
            }
            ++i;
        }
        return traderCode;
    }

    public void requestProgramsList() {
        try {
            String traderCode = Resources.traderId;
            String userId = Resources.userId;
            if (Resources.userType == 0 || Resources.userType == 3) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new ProgramsRequest(traderCode, userId));
                }
            } else {
                MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Only Administrators or Traders are allowed this operation.");
            }
        }
        catch (Exception e) {
            System.out.println("requestUserListing():" + e);
            e.printStackTrace();
        }
    }

    protected void cancelPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.cancelPressed();
    }

    public boolean close() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        return super.close();
    }

    public void requestUserGeneration() {
        try {
            if (this.fieldValidation()) {
                String userId = this.txtUserId.getText();
                String userName = this.txtName.getText();
                String userRole = "";
                String userType = "";
                if (this.cmbUserType.getText().equals("Teacher")) {
                    userRole = "SYS-3";
                    userType = "TR";
                } else {
                    userRole = "SYS-2";
                    userType = "CL";
                }
                String programName = this.cmbProgm.getText();
                if (programName == null || programName.length() == 0) {
                    MessageDialog.openError(null, (String)"Invalid Program", (String)"Please select program");
                    return;
                }
                String traderCode = this.getTraderCode(programName);
                double cashDeposit = 0.0;
                if (!this.cmbUserType.getText().equals("Teacher")) {
                    cashDeposit = Double.parseDouble(this.txtOpening.getText());
                }
                if (!this.cmbUserType.getText().equals("Teacher") && cashDeposit <= 0.0) {
                    MessageDialog.openError(null, (String)"Invalid Amount", (String)"Please enter some valid amount");
                    return;
                }
                double interestRate = Double.parseDouble(this.txtInterestRate.getText());
                if (this.expiryDate == null) {
                    MessageDialog.openError(null, (String)"Invalid Date", (String)"Please enter valid Expiry Date");
                    return;
                }
                if (Resources.userType == 0 || Resources.userType == 3) {
                    if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                        Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new GenerateUserRequest(userId, userName, userId, traderCode, userRole, userType, cashDeposit, interestRate, this.expiryDate));
                    }
                } else {
                    MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Only Administrators or Traders are allowed this operation.");
                }
                this.clear();
            }
        }
        catch (Exception e) {
            System.out.println("requestUserListing():" + e);
            e.printStackTrace();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Generate User View");
    }

    public void itemAdded(final Object o) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (o instanceof GenerateUserResponse) {
                    GenerateUserResponse response = (GenerateUserResponse)o;
                    if (response.isUserGenerated()) {
                        MessageDialog.openInformation(null, (String)"User Creation", (String)"New User has been created Successfully");
                    } else {
                        MessageDialog.openInformation(null, (String)"User Creation", (String)("User could not be created. " + response.getError()));
                    }
                }
            }
        });
    }

    public void itemRemoved(Object o) {
    }

    public Date covertStringToDate(String str) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date date = df.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

