/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.admin.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.messages.ClientDlgInfo;
import pk.com.softech.messages.ClientDlgRequest;
import pk.com.softech.messages.ClientDlgResponse;
import pk.com.softech.messages.ClientGroupData;
import pk.com.softech.tradingterminal.admin.dialog.ClientComparatorDlg;
import pk.com.softech.tradingterminal.admin.dialog.SecurityFilterDlg;
import pk.com.softech.tradingterminal.admin.views.MessageBroadcastView;
import pk.com.softech.tradingterminal.admin.views.SMSMessageBroadcastView;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class ClientSearchingViewDialog
extends Dialog
implements ICollectionObserver {
    private Composite parent;
    private Composite content;
    private String grpCode;
    private ClientComparatorDlg comparator;
    private Text txtClientCode;
    private Text txtClientName;
    private Text txtLotCode;
    private Text txtMobileNo;
    private Text txtAddress;
    private Text txtIdCardNo;
    private SecurityFilterDlg filter;
    private TableViewer viewer;
    String viewID;
    int selection;
    int sortColumn = 0;
    int sortDirection = 1;
    public static final int CLIENTNAME = 0;
    public static final int CLIENTCODE = 1;
    public static final int LOTCODE = 2;
    public static final int TRADERCODE = 3;
    public static final int MOBILENO = 4;
    public static final int MAIDENNAME = 5;
    public static final int PINCODE = 6;
    public static final int ADDRESS = 7;
    public static final int IDCARDNO = 8;
    public static final int EMAIL = 9;
    public static final int CLIENTGRP = 10;
    private static String[] COLUMN_NAMES = new String[]{"Client Name", "Client Code", "Lot Code", "Trader Code", "Mobile Number", "Mother Maiden Name", "Pin Code", "Address", "ID Card", "Email", "Client Group"};
    public static final String PREFS_SORT_COLUMN = "CLIENTLISTING_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "CLIENTLISTING_SORT_DIRECTION";
    public static final String PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE = "PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE";
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ClientSearchingViewDialog.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientSearchingViewDialog.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(ClientSearchingViewDialog.PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = ClientSearchingViewDialog.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (ClientSearchingViewDialog.this.sortColumn == index) {
                ClientSearchingViewDialog.this.sortDirection = ClientSearchingViewDialog.this.sortDirection == 0 ? 1 : 0;
            } else {
                ClientSearchingViewDialog.this.sortColumn = index;
                ClientSearchingViewDialog.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(ClientSearchingViewDialog.PREFS_SORT_COLUMN, ClientSearchingViewDialog.this.sortColumn);
            prefs.setValue(ClientSearchingViewDialog.PREFS_SORT_DIRECTION, ClientSearchingViewDialog.this.sortDirection);
            ClientSearchingViewDialog.this.viewer.getTable().setSortColumn(ClientSearchingViewDialog.this.viewer.getTable().getColumn(ClientSearchingViewDialog.this.sortColumn));
            ClientSearchingViewDialog.this.viewer.getTable().setSortDirection(ClientSearchingViewDialog.this.sortDirection == 0 ? 128 : 1024);
            ClientSearchingViewDialog.this.comparator.setColumn(ClientSearchingViewDialog.this.sortColumn);
            ClientSearchingViewDialog.this.viewer.refresh();
        }
    };

    public ClientSearchingViewDialog(Shell parentShell, String viewID, int selection) {
        super(parentShell);
        this.viewID = viewID;
        this.selection = selection;
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(container, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(8, false));
        this.createLabel(composite, "Client Name");
        this.txtClientName = this.createText(composite, 16384);
        this.txtClientName.setEnabled(true);
        this.txtClientName.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                ClientSearchingViewDialog.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Client Code");
        this.txtClientCode = this.createText(composite, 16384);
        this.txtClientCode.setEnabled(true);
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                ClientSearchingViewDialog.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Lot Code");
        this.txtLotCode = this.createText(composite, 16384);
        this.txtLotCode.setEnabled(true);
        this.txtLotCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtLotCode.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                ClientSearchingViewDialog.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Client Group");
        Button btnRefresh = new Button(composite, 0x1000000);
        btnRefresh.setText("Refresh");
        btnRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ClientSearchingViewDialog.this.clearFields();
                    ClientSearchingViewDialog.this.sendClientListingRequest();
                    ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                    ClientSearchingViewDialog.this.viewer.refresh();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createLabel(composite, "Mobile No");
        this.txtMobileNo = this.createText(composite, 16384);
        this.txtMobileNo.setEnabled(true);
        this.txtMobileNo.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtMobileNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                ClientSearchingViewDialog.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "Address");
        this.txtAddress = this.createText(composite, 16384);
        this.txtAddress.setEnabled(true);
        this.txtAddress.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtAddress.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                ClientSearchingViewDialog.this.viewer.refresh();
            }
        });
        this.createLabel(composite, "ID Card");
        this.txtIdCardNo = this.createText(composite, 16384);
        this.txtIdCardNo.setEnabled(true);
        this.txtIdCardNo.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtIdCardNo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                ClientSearchingViewDialog.this.viewer.refresh();
            }
        });
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < Resources.clientGroups.size()) {
            list.add(((ClientGroupData)Resources.clientGroups.get(i)).getName());
            ++i;
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        final Combo cmbClientGrp = new Combo(composite, 8);
        cmbClientGrp.add("ALL");
        cmbClientGrp.setData("ALL", (Object)"");
        int i2 = 0;
        while (i2 < list.size()) {
            cmbClientGrp.add((String)list.get(i2));
            cmbClientGrp.setData(((ClientGroupData)Resources.clientGroups.get(i2)).getName(), (Object)((ClientGroupData)Resources.clientGroups.get(i2)).getCode());
            ++i2;
        }
        cmbClientGrp.select(0);
        this.grpCode = (String)cmbClientGrp.getData(cmbClientGrp.getItem(cmbClientGrp.getSelectionIndex()));
        cmbClientGrp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClientSearchingViewDialog.this.grpCode = (String)cmbClientGrp.getData(cmbClientGrp.getItem(cmbClientGrp.getSelectionIndex()));
                ClientSearchingViewDialog.this.filter.setSearchText(ClientSearchingViewDialog.this.txtClientCode.getText(), ClientSearchingViewDialog.this.txtClientName.getText(), ClientSearchingViewDialog.this.txtLotCode.getText(), ClientSearchingViewDialog.this.txtMobileNo.getText(), ClientSearchingViewDialog.this.txtAddress.getText(), ClientSearchingViewDialog.this.txtIdCardNo.getText(), ClientSearchingViewDialog.this.grpCode);
                ClientSearchingViewDialog.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer(this.content);
        this.comparator = new ClientComparatorDlg();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.comparator.setColumn(this.sortColumn);
        this.filter = new SecurityFilterDlg();
        this.viewer.addFilter((ViewerFilter)this.filter);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
        if (Resources.loginStatus && Resources.refDataComplete) {
            this.sendClientListingRequest();
        }
        return container;
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        ArrayList<ClientDlgInfo> lst = new ArrayList<ClientDlgInfo>();
        int i = 0;
        while (i < selection.size()) {
            lst.add((ClientDlgInfo)selection.toArray()[i]);
            ++i;
        }
        if (this.viewID.equals("pk.com.softech.tradingterminal.admin.views.MessageBroadcastView")) {
            try {
                IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.admin.views.MessageBroadcastView");
                if (viewPart != null) {
                    MessageBroadcastView view = (MessageBroadcastView)viewPart;
                    view.addRecipients(lst);
                }
            }
            catch (PartInitException e1) {
                e1.printStackTrace();
            }
        } else if (this.viewID.equals("pk.com.softech.tradingterminal.admin.views.SMSMessageBroadcastView")) {
            try {
                IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.admin.views.SMSMessageBroadcastView");
                if (viewPart != null) {
                    SMSMessageBroadcastView view = (SMSMessageBroadcastView)viewPart;
                    view.addRecipients(lst);
                }
            }
            catch (PartInitException e1) {
                e1.printStackTrace();
            }
        }
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.okPressed();
    }

    protected void cancelPressed() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.cancelPressed();
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 2176);
        temp.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(90), -1));
        temp.setEnabled(false);
        return temp;
    }

    protected Point getInitialSize() {
        return new Point(850, 500);
    }

    public void recieveClientDlgResponse(final ClientDlgResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (resp.getRows() != null) {
                            System.out.println("Length : " + resp.getRows().length);
                            ClientSearchingViewDialog.this.viewer.setInput(Arrays.asList(resp.getRows()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void clearFields() {
        try {
            this.txtClientCode.setText("");
            this.txtClientName.setText("");
            this.txtLotCode.setText("");
            this.txtMobileNo.setText("");
            this.txtAddress.setText("");
            this.txtIdCardNo.setText("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendClientListingRequest() {
        try {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                ClientDlgRequest request = new ClientDlgRequest();
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, this.selection | 0x100 | 0x200 | 0x10000 | 0x800);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            this.createTableViewerColumn(i);
            ++i;
        }
        int width = this.convertHorizontalDLUsToPixels(100);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_CLIENTS_LISTING_VIEW_COLUMNS_SIZE).split(";");
        int i2 = 0;
        while (i2 < viewer.getTable().getColumnCount()) {
            if (i2 < sizes.length && sizes[i2].length() != 0) {
                viewer.getTable().getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
            } else {
                viewer.getTable().getColumn(i2).pack();
                if (viewer.getTable().getColumn(i2).getWidth() == 0) {
                    viewer.getTable().getColumn(i2).setWidth(width);
                }
            }
            ++i2;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                try {
                    switch (colNumber) {
                        case 0: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getClientName().toUpperCase());
                            break;
                        }
                        case 1: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getClientCode().toUpperCase());
                            break;
                        }
                        case 2: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getClientLot().toUpperCase());
                            break;
                        }
                        case 3: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getTraderCode().toUpperCase());
                            break;
                        }
                        case 4: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getMobileNo());
                            break;
                        }
                        case 5: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getMaidenName());
                            break;
                        }
                        case 6: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getPinCode());
                            break;
                        }
                        case 7: {
                            String address = ((ClientDlgInfo)cell.getElement()).getAddress();
                            if (address == null) {
                                address = "";
                            }
                            cell.setText(address.toUpperCase());
                            break;
                        }
                        case 8: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getIdCardNo());
                            break;
                        }
                        case 9: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getEmail());
                            break;
                        }
                        case 10: {
                            cell.setText(((ClientDlgInfo)cell.getElement()).getClientGroup());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public String getToolTipText(Object element) {
                ClientDlgInfo sec = (ClientDlgInfo)element;
                return sec.getClientName();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Client Searching Dialoge");
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ClientDlgResponse) {
                        ClientDlgResponse rsp = (ClientDlgResponse)o;
                        ClientSearchingViewDialog.this.recieveClientDlgResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }
}

